/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import javax.annotation.Nullable;
import redradishes.decoder.parser.Parser;

class ExpectedResultParser<T>
implements Parser<T> {
    private final byte[] expectedBytes;
    private final int pos0;
    private final T reply;

    ExpectedResultParser(byte[] expectedBytes, @Nullable T reply) {
        this(expectedBytes, 0, reply);
    }

    private ExpectedResultParser(byte[] expectedBytes, int pos0, @Nullable T reply) {
        this.expectedBytes = expectedBytes;
        this.pos0 = pos0;
        this.reply = reply;
    }

    @Override
    public <U> U parse(ByteBuffer buffer, Function<? super T, U> resultHandler, Parser.PartialHandler<? super T, U> partialHandler, CharsetDecoder charsetDecoder) {
        for (int pos = this.pos0; pos < this.expectedBytes.length; ++pos) {
            if (buffer.hasRemaining()) {
                byte expected;
                byte actual = buffer.get();
                if (actual == (expected = this.expectedBytes[pos])) continue;
                throw new IllegalStateException(39 + expected + "' is expected but '" + (char)actual + "' was found");
            }
            return partialHandler.partial(new ExpectedResultParser<T>(this.expectedBytes, pos, this.reply));
        }
        return resultHandler.apply(this.reply);
    }
}

