/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import redradishes.decoder.parser.ReplyParser;

public class CharAppendingParser<A extends Appendable>
implements ReplyParser<A> {
    public static final ReplyParser<? extends CharSequence> CHAR_SEQUENCE_PARSER = new CharAppendingParser<StringBuilder>(StringBuilder::new);
    private static final int READING = 0;
    private static final int WAITING_FOR_LF = 1;
    private final Supplier<A> appendableSupplier;
    private final Exception exception0;
    private final int state0;

    CharAppendingParser(Supplier<A> appendableSupplier) {
        this(appendableSupplier, null, 0);
    }

    private CharAppendingParser(Supplier<A> appendableSupplier, @Nullable Exception exception0, int state0) {
        this.appendableSupplier = appendableSupplier;
        this.exception0 = exception0;
        this.state0 = state0;
    }

    @Override
    public <U> U parseReply(ByteBuffer buffer, Function<? super A, U> resultHandler, ReplyParser.PartialReplyHandler<? super A, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, CharsetDecoder charsetDecoder) {
        Appendable appendable = (Appendable)this.appendableSupplier.get();
        int state = this.state0;
        Exception exception = this.exception0;
        block6: while (buffer.hasRemaining()) {
            byte b = buffer.get();
            switch (state) {
                case 0: {
                    if (b == 13) {
                        state = 1;
                        break;
                    }
                    try {
                        appendable.append((char)b);
                    }
                    catch (Exception e) {
                        if (exception != null) continue block6;
                        exception = e;
                    }
                    break;
                }
                case 1: {
                    if (b == 10) {
                        return exception == null ? resultHandler.apply(appendable) : failureHandler.failure(exception);
                    }
                    throw new IllegalStateException("LF is expected");
                }
            }
        }
        return partialReplyHandler.partialReply(new CharAppendingParser<Appendable>(() -> appendable, exception, state));
    }
}

