/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import javax.annotation.Nullable;
import redradishes.decoder.BulkStringBuilderFactory;
import redradishes.decoder.ReplyParseException;
import redradishes.decoder.parser.ReplyParser;

public class BulkStringParser<T, B>
implements ReplyParser<T> {
    private static final int READING = 0;
    private static final int WAITING_FOR_CR = 1;
    private static final int WAITING_FOR_LF = 2;
    private final BulkStringBuilderFactory<B, ? extends T> builderFactory;
    private final int len;

    public BulkStringParser(int len, BulkStringBuilderFactory<B, ? extends T> builderFactory) {
        this.len = len;
        this.builderFactory = builderFactory;
    }

    @Override
    public <U> U parseReply(ByteBuffer buffer, Function<? super T, U> resultHandler, ReplyParser.PartialReplyHandler<? super T, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, CharsetDecoder charsetDecoder) {
        return this.doParse(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder, this.builderFactory.create(this.len, charsetDecoder), this.len, 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private <U> U doParse(ByteBuffer buffer, Function<? super T, U> resultHandler, ReplyParser.PartialReplyHandler<? super T, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, CharsetDecoder charsetDecoder, B builder, int len, int state, @Nullable T result, @Nullable Exception exception) {
        block12: while (buffer.hasRemaining()) {
            switch (state) {
                case 0: {
                    remaining = buffer.remaining();
                    if (remaining < len) ** GOTO lbl27
                    chunkLimit = buffer.position() + len;
                    if (exception == null) {
                        savedLimit = buffer.limit();
                        buffer.limit(chunkLimit);
                        try {
                            result = this.builderFactory.appendLast(builder, buffer, charsetDecoder);
                            if (buffer.hasRemaining()) {
                                exception = new ReplyParseException("Bulk string decoder has not consumed all input");
                            }
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        finally {
                            buffer.limit(savedLimit);
                        }
                    }
                    buffer.position(chunkLimit);
                    state = 1;
                    ** GOTO lbl49
lbl27:
                    // 1 sources

                    if (exception == null) {
                        try {
                            builder = this.builderFactory.append(builder, buffer, charsetDecoder);
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        bytesRead = remaining - buffer.remaining();
                        len -= bytesRead;
                        break block12;
                    }
                    buffer.position(buffer.limit());
                    len -= remaining;
                    break block12;
                }
                case 1: {
                    if (buffer.get() != 13) ** GOTO lbl44
                    state = 2;
                    ** GOTO lbl49
lbl44:
                    // 1 sources

                    throw new IllegalStateException("CR is expected");
                }
                case 2: {
                    if (buffer.get() == 10) {
                        return exception == null ? resultHandler.apply(result) : failureHandler.failure(exception);
                    }
                    throw new IllegalStateException("LF is expected");
                }
lbl49:
                // 3 sources

                default: {
                    continue block12;
                }
            }
        }
        builder1 = builder;
        len1 = len;
        state1 = state;
        result1 = result;
        exception1 = exception;
        return partialReplyHandler.partialReply(new ReplyParser<T>(){

            @Override
            public <U1> U1 parseReply(ByteBuffer buffer, Function<? super T, U1> resultHandler, ReplyParser.PartialReplyHandler<? super T, U1> partialReplyHandler, ReplyParser.FailureHandler<U1> failureHandler, CharsetDecoder charsetDecoder) {
                return (U1)BulkStringParser.this.doParse(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder, builder1, len1, state1, result1, exception1);
            }
        });
    }
}

