/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import redradishes.decoder.MapBuilderFactory;
import redradishes.decoder.parser.CombiningReplyParser;
import redradishes.decoder.parser.Parser;

public class ArrayAsMapParser<T, K, V>
implements Parser<T> {
    private final int len;
    private final MapBuilderFactory<K, V, ? extends T> builderFactory;
    private final CombiningReplyParser<K, V> kvParser;

    public ArrayAsMapParser(int len, MapBuilderFactory<K, V, ? extends T> builderFactory, CombiningReplyParser<K, V> kvParser) {
        this.len = len;
        this.builderFactory = builderFactory;
        this.kvParser = kvParser;
    }

    @Override
    public <U> U parse(ByteBuffer buffer, Function<? super T, U> resultHandler, Parser.PartialHandler<? super T, U> partialHandler, CharsetDecoder charsetDecoder) {
        return this.doParse(buffer, resultHandler, partialHandler, this.builderFactory.create(this.len), this.len, this.kvParser, charsetDecoder);
    }

    private <U> U doParse(ByteBuffer buffer, Function<? super T, U> resultHandler, Parser.PartialHandler<? super T, U> partialHandler, MapBuilderFactory.Builder<K, V, ? extends T> builder, int remaining, CombiningReplyParser<? extends K, ? extends V> kvSeqParser, CharsetDecoder charsetDecoder) {
        while (remaining > 0) {
            Parser<? extends T> partial = this.parsePartial(buffer, builder, remaining, kvSeqParser, charsetDecoder);
            if (partial != null) {
                return partialHandler.partial(partial);
            }
            --remaining;
            kvSeqParser = this.kvParser;
        }
        return resultHandler.apply(builder.build());
    }

    private Parser<T> parsePartial(ByteBuffer buffer, final MapBuilderFactory.Builder<K, V, ? extends T> builder, final int remaining, CombiningReplyParser<? extends K, ? extends V> kvSeqParser, CharsetDecoder charsetDecoder) {
        return kvSeqParser.parseReply(buffer, (? super T1 key, ? super T2 value) -> {
            builder.put(key, value);
            return null;
        }, (CombiningReplyParser<? super T1, ? super T2> partial) -> new Parser<T>(){

            @Override
            public <U1> U1 parse(ByteBuffer buffer, Function<? super T, U1> resultHandler, Parser.PartialHandler<? super T, U1> partialHandler, CharsetDecoder charsetDecoder) {
                return (U1)ArrayAsMapParser.this.doParse(buffer, resultHandler, partialHandler, builder, remaining, partial, charsetDecoder);
            }
        }, (Throwable e) -> {
            throw Throwables.propagate((Throwable)e);
        }, charsetDecoder);
    }
}

