/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import redradishes.decoder.parser.ReplyParser;

class AnyReplyParser<T>
implements ReplyParser<T> {
    private final ReplyParser<? extends T> simpleStrParser;
    private final ReplyParser<? extends T> errorParser;
    private final ReplyParser<? extends T> integerParser;
    private final ReplyParser<? extends T> bulkStrParser;
    private final ReplyParser<? extends T> arrayParser;

    AnyReplyParser(ReplyParser<? extends T> simpleStrParser, ReplyParser<? extends T> errorParser, ReplyParser<? extends T> integerParser, ReplyParser<? extends T> bulkStrParser, ReplyParser<? extends T> arrayParser) {
        this.simpleStrParser = simpleStrParser;
        this.errorParser = errorParser;
        this.integerParser = integerParser;
        this.bulkStrParser = bulkStrParser;
        this.arrayParser = arrayParser;
    }

    @Override
    public <U> U parseReply(ByteBuffer buffer, Function<? super T, U> resultHandler, ReplyParser.PartialReplyHandler<? super T, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, CharsetDecoder charsetDecoder) {
        if (buffer.hasRemaining()) {
            byte b = buffer.get();
            switch (b) {
                case 43: {
                    return this.simpleStrParser.parseReply(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder);
                }
                case 45: {
                    return this.errorParser.parseReply(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder);
                }
                case 58: {
                    return this.integerParser.parseReply(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder);
                }
                case 36: {
                    return this.bulkStrParser.parseReply(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder);
                }
                case 42: {
                    return this.arrayParser.parseReply(buffer, resultHandler, partialReplyHandler, failureHandler, charsetDecoder);
                }
            }
            throw new IllegalStateException("Marker is expected but '" + (char)b + "' was found");
        }
        return partialReplyHandler.partialReply(this);
    }
}

