/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import redradishes.decoder.BulkStringBuilderFactory;
import redradishes.decoder.SimpleBulkStringBuilderFactory;

public class BulkStringBuilders {
    private static final BulkStringBuilderFactory<?, byte[]> BYTE_ARRAY_BUILDER_FACTORY = (length, charsetDecoder) -> new SimpleBulkStringBuilderFactory.Builder<byte[]>(){
        private final byte[] bytes;
        private int offset;
        {
            this.bytes = new byte[length];
            this.offset = 0;
        }

        @Override
        public SimpleBulkStringBuilderFactory.Builder<byte[]> append(ByteBuffer buffer) {
            int len = buffer.remaining();
            buffer.get(this.bytes, this.offset, len);
            this.offset += len;
            return this;
        }

        @Override
        public byte[] build() {
            return this.bytes;
        }
    };
    private static final BulkStringBuilderFactory<?, CharSequence> CHAR_SEQUENCE_BUILDER_FACTORY = new BulkStringBuilderFactory<CharBuffer, CharSequence>(){

        @Override
        public CharBuffer create(int length, CharsetDecoder charsetDecoder) {
            return CharBuffer.allocate((int)((double)length * (double)charsetDecoder.maxCharsPerByte()));
        }

        @Override
        public CharBuffer append(CharBuffer charBuffer, ByteBuffer buffer, CharsetDecoder charsetDecoder) throws CharacterCodingException {
            this.checkResult(charsetDecoder.decode(buffer, charBuffer, false));
            return charBuffer;
        }

        @Override
        public CharSequence appendLast(CharBuffer charBuffer, ByteBuffer buffer, CharsetDecoder charsetDecoder) throws CharacterCodingException {
            this.checkResult(charsetDecoder.decode(buffer, charBuffer, true));
            this.checkResult(charsetDecoder.flush(charBuffer));
            charsetDecoder.reset();
            charBuffer.flip();
            return charBuffer;
        }

        private void checkResult(CoderResult coderResult) throws CharacterCodingException {
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
        }
    };
    private static final BulkStringBuilderFactory<?, String> STRING_BUILDER_FACTORY = CHAR_SEQUENCE_BUILDER_FACTORY.map(Object::toString);
    private static final int SIGN_OR_DIGIT = 0;
    private static final int DIGIT = 1;
    private static final BulkStringBuilderFactory<?, Long> LONG_BUILDER_FACTORY = (length, charsetDecoder) -> new SimpleBulkStringBuilderFactory.Builder<Long>(){
        int state = 0;
        boolean negative = false;
        long num = 0L;

        @Override
        public SimpleBulkStringBuilderFactory.Builder<Long> append(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                block0 : switch (this.state) {
                    case 0: {
                        this.state = 1;
                        if (b == 45) {
                            this.negative = true;
                            break;
                        }
                    }
                    case 1: {
                        switch (b) {
                            case 48: {
                                this.num *= 10L;
                                break block0;
                            }
                            case 49: {
                                this.num = this.num * 10L + 1L;
                                break block0;
                            }
                            case 50: {
                                this.num = this.num * 10L + 2L;
                                break block0;
                            }
                            case 51: {
                                this.num = this.num * 10L + 3L;
                                break block0;
                            }
                            case 52: {
                                this.num = this.num * 10L + 4L;
                                break block0;
                            }
                            case 53: {
                                this.num = this.num * 10L + 5L;
                                break block0;
                            }
                            case 54: {
                                this.num = this.num * 10L + 6L;
                                break block0;
                            }
                            case 55: {
                                this.num = this.num * 10L + 7L;
                                break block0;
                            }
                            case 56: {
                                this.num = this.num * 10L + 8L;
                                break block0;
                            }
                            case 57: {
                                this.num = this.num * 10L + 9L;
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Unexpected character: " + (char)b);
                    }
                }
            }
            return this;
        }

        @Override
        public Long build() {
            return this.negative ? -this.num : this.num;
        }
    };
    private static final BulkStringBuilderFactory<?, Integer> INTEGER_BUILDER_FACTORY = LONG_BUILDER_FACTORY.map(Long::intValue);

    public static BulkStringBuilderFactory<?, CharSequence> charSequence() {
        return CHAR_SEQUENCE_BUILDER_FACTORY;
    }

    public static BulkStringBuilderFactory<?, String> string() {
        return STRING_BUILDER_FACTORY;
    }

    public static BulkStringBuilderFactory<?, Integer> integer() {
        return INTEGER_BUILDER_FACTORY;
    }

    public static BulkStringBuilderFactory<?, Long> _long() {
        return LONG_BUILDER_FACTORY;
    }

    public static BulkStringBuilderFactory<?, byte[]> byteArray() {
        return BYTE_ARRAY_BUILDER_FACTORY;
    }
}

