/*
 * Decompiled with CFR 0.152.
 */
package redradishes;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import redradishes.RedisClientConnection;
import redradishes.Request;
import redradishes.decoder.parser.ReplyParser;
import redradishes.encoder.ByteSink;

public abstract class XnioRedisClient<F, SF extends F>
implements AutoCloseable {
    private final BlockingQueue<RedisClientConnection.CommandEncoderDecoder> writerQueue = new LinkedBlockingQueue<RedisClientConnection.CommandEncoderDecoder>();
    private volatile IoFuture<StreamConnection> streamConnectionFuture;
    private volatile RedisClientConnection redisClientConnection;
    private volatile IOException failure;
    private volatile boolean closed = false;

    protected XnioRedisClient(XnioWorker worker, SocketAddress address, Pool<ByteBuffer> bufferPool, Charset charset) {
        this.streamConnectionFuture = this.openConnection(worker, address, bufferPool, charset);
    }

    private IoFuture<StreamConnection> openConnection(final XnioWorker worker, final SocketAddress address, final Pool<ByteBuffer> bufferPool, final Charset charset) {
        IoFuture connectionFuture = worker.openStreamConnection(address, null, OptionMap.EMPTY);
        connectionFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, Void>(){

            public void handleFailed(IOException exception, Void v) {
                XnioRedisClient.this.failure = exception;
                XnioRedisClient.this.failAllCommands();
            }

            public void handleDone(StreamConnection connection, Void v) {
                XnioRedisClient.this.redisClientConnection = new RedisClientConnection(connection, (Pool<ByteBuffer>)bufferPool, charset, XnioRedisClient.this.writerQueue);
                if (!XnioRedisClient.this.writerQueue.isEmpty()) {
                    XnioRedisClient.this.redisClientConnection.commandAdded();
                }
                connection.setCloseListener(streamConnection -> {
                    if (!XnioRedisClient.this.closed) {
                        XnioRedisClient.this.streamConnectionFuture = XnioRedisClient.this.openConnection(worker, address, (Pool<ByteBuffer>)bufferPool, charset);
                    }
                });
            }
        }, null);
        return connectionFuture;
    }

    private void failAllCommands() {
        RedisClientConnection.CommandEncoderDecoder commandEncoderDecoder;
        while ((commandEncoderDecoder = (RedisClientConnection.CommandEncoderDecoder)this.writerQueue.poll()) != null) {
            commandEncoderDecoder.fail(this.failure);
        }
    }

    protected <T> F send_(final Request<T> request) {
        if (this.closed) {
            return this.createCancelledFuture();
        }
        if (this.failure != null) {
            return this.createFailedFuture(this.failure);
        }
        final SF future = this.createFuture();
        this.writerQueue.add(new RedisClientConnection.CommandEncoderDecoder(){
            private ReplyParser<? extends T> parser;
            {
                this.parser = request.parser();
            }

            @Override
            public void writeTo(ByteSink sink) {
                request.writeTo(sink);
            }

            @Override
            public boolean parse(ByteBuffer buffer, CharsetDecoder charsetDecoder) throws IOException {
                return this.parser.parseReply(buffer, value -> {
                    XnioRedisClient.this.complete(future, value);
                    return true;
                }, partial -> {
                    this.parser = partial;
                    return false;
                }, exception -> {
                    XnioRedisClient.this.completeExceptionally(future, exception);
                    return true;
                }, charsetDecoder);
            }

            @Override
            public void fail(Throwable e) {
                XnioRedisClient.this.completeExceptionally(future, e);
            }

            @Override
            public void cancel() {
                XnioRedisClient.this.cancel(future);
            }
        });
        if (this.redisClientConnection != null) {
            this.redisClientConnection.commandAdded();
        }
        if (this.failure != null) {
            this.failAllCommands();
        }
        return (F)future;
    }

    protected abstract F createCancelledFuture();

    protected abstract F createFailedFuture(Throwable var1);

    protected abstract SF createFuture();

    protected abstract <T> void complete(SF var1, T var2);

    protected abstract void completeExceptionally(SF var1, Throwable var2);

    protected abstract void cancel(SF var1);

    @Override
    public void close() {
        this.closed = true;
        IoUtils.safeClose(this.streamConnectionFuture);
    }
}

