/*
 * Decompiled with CFR 0.152.
 */
package redradishes;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import redradishes.Request;
import redradishes.decoder.parser.ReplyParser;
import redradishes.encoder.ByteSink;

public class CommandList<T>
implements Request<List<T>> {
    private final List<Request<T>> requests;

    public CommandList(List<Request<T>> requests) {
        this.requests = requests;
    }

    @Override
    public void writeTo(ByteSink sink) {
        for (Request<T> request : this.requests) {
            request.writeTo(sink);
        }
    }

    @Override
    public ReplyParser<List<T>> parser() {
        return new ReplyParser<List<T>>(){
            private final List<T> replies;
            private final Iterator<Request<T>> requestIterator;
            {
                this.replies = new ArrayList(CommandList.this.requests.size());
                this.requestIterator = CommandList.this.requests.iterator();
            }

            @Override
            public <U> U parseReply(ByteBuffer buffer, Function<? super List<T>, U> resultHandler, ReplyParser.PartialReplyHandler<? super List<T>, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, CharsetDecoder charsetDecoder) {
                if (this.requestIterator.hasNext()) {
                    return this.doParse(buffer, resultHandler, partialReplyHandler, failureHandler, this.requestIterator.next().parser(), charsetDecoder);
                }
                return resultHandler.apply(this.replies);
            }

            private <U> U doParse(ByteBuffer buffer, Function<? super List<T>, U> resultHandler, ReplyParser.PartialReplyHandler<? super List<T>, U> partialReplyHandler, ReplyParser.FailureHandler<U> failureHandler, ReplyParser<? extends T> parser, CharsetDecoder charsetDecoder) {
                return (U)parser.parseReply(buffer, (? super T value) -> {
                    this.replies.add(value);
                    return this.parseReply(buffer, resultHandler, partialReplyHandler, (ReplyParser.FailureHandler<U>)failureHandler, charsetDecoder);
                }, (ReplyParser<? super T> partial) -> partialReplyHandler.partialReply(new ReplyParser<List<T>>(){

                    @Override
                    public <U1> U1 parseReply(ByteBuffer buffer, Function<? super List<T>, U1> resultHandler, ReplyParser.PartialReplyHandler<? super List<T>, U1> partialReplyHandler, ReplyParser.FailureHandler<U1> failureHandler, CharsetDecoder charsetDecoder) {
                        return (U1)this.doParse(buffer, resultHandler, partialReplyHandler, failureHandler, partial, charsetDecoder);
                    }
                }), failureHandler, charsetDecoder);
            }
        };
    }
}

