/*
 * Decompiled with CFR 0.152.
 */
package redradishes;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import redradishes.ByteBufferBundle;
import redradishes.UncheckedCharacterCodingException;
import redradishes.encoder.ByteSink;

class ByteBufferSink
implements ByteSink {
    private final ByteBufferBundle byteBufferBundle;
    private ByteBuffer buffer;

    ByteBufferSink(ByteBufferBundle byteBufferBundle) {
        this.byteBufferBundle = byteBufferBundle;
        this.buffer = this.byteBufferBundle.get();
    }

    @Override
    public void write(byte b) {
        if (!this.buffer.hasRemaining()) {
            this.buffer = this.byteBufferBundle.getNew();
        }
        this.buffer.put(b);
    }

    @Override
    public void write(CharSequence s, CharsetEncoder charsetEncoder) {
        CharBuffer in = CharBuffer.wrap(s);
        try {
            charsetEncoder.reset();
            while (true) {
                CoderResult coderResult;
                CoderResult coderResult2 = coderResult = in.hasRemaining() ? charsetEncoder.encode(in, this.buffer, true) : CoderResult.UNDERFLOW;
                if (coderResult.isUnderflow()) {
                    coderResult = charsetEncoder.flush(this.buffer);
                }
                if (!coderResult.isUnderflow()) {
                    if (coderResult.isOverflow()) {
                        this.buffer = this.byteBufferBundle.getNew();
                        continue;
                    }
                    coderResult.throwException();
                    continue;
                }
                break;
            }
        }
        catch (CharacterCodingException e) {
            throw new UncheckedCharacterCodingException(e);
        }
    }

    @Override
    public void write(byte[] src) {
        this.write(src, 0, src.length);
    }

    @Override
    public void write(byte[] src, int offset, int length) {
        while (true) {
            int freeSpace;
            if ((freeSpace = this.buffer.remaining()) >= length) break;
            this.buffer.put(src, offset, freeSpace);
            this.buffer = this.byteBufferBundle.getNew();
            offset += freeSpace;
            length -= freeSpace;
        }
        this.buffer.put(src, offset, length);
    }
}

