/*
 * Decompiled with CFR 0.152.
 */
package redradishes;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.xnio.Pool;
import org.xnio.Pooled;

class ByteBufferBundle {
    private final Pool<ByteBuffer> pool;
    private final Deque<Pooled<ByteBuffer>> allocated = new LinkedList<Pooled<ByteBuffer>>();
    private ByteBuffer currentWriteBuffer = null;

    ByteBufferBundle(Pool<ByteBuffer> pool) {
        this.pool = pool;
    }

    ByteBuffer get() {
        if (this.currentWriteBuffer != null) {
            if (this.currentWriteBuffer.hasRemaining()) {
                return this.currentWriteBuffer;
            }
            this.currentWriteBuffer.flip();
        }
        this.currentWriteBuffer = this.allocateBuffer();
        return this.currentWriteBuffer;
    }

    ByteBuffer getNew() {
        if (this.currentWriteBuffer != null) {
            this.currentWriteBuffer.flip();
        }
        this.currentWriteBuffer = this.allocateBuffer();
        return this.currentWriteBuffer;
    }

    private ByteBuffer allocateBuffer() {
        Pooled pooledBuffer = this.pool.allocate();
        this.allocated.add((Pooled<ByteBuffer>)pooledBuffer);
        return (ByteBuffer)pooledBuffer.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeTo(GatheringByteChannel channel) throws IOException {
        this.startReading();
        try {
            long l = channel.write(this.getReadBuffers());
            return l;
        }
        finally {
            this.startWriting();
        }
    }

    private void startReading() {
        if (this.currentWriteBuffer != null) {
            this.currentWriteBuffer.flip();
        }
        this.currentWriteBuffer = null;
    }

    private ByteBuffer[] getReadBuffers() {
        return (ByteBuffer[])this.allocated.stream().map(Pooled::getResource).toArray(ByteBuffer[]::new);
    }

    private void startWriting() {
        ByteBuffer lastBuffer;
        Pooled<ByteBuffer> pooledBuffer;
        ByteBuffer byteBuffer;
        Iterator<Pooled<ByteBuffer>> iterator = this.allocated.iterator();
        while (iterator.hasNext() && !(byteBuffer = (ByteBuffer)(pooledBuffer = iterator.next()).getResource()).hasRemaining()) {
            byteBuffer.clear();
            pooledBuffer.free();
            iterator.remove();
        }
        Pooled<ByteBuffer> lastPooledBuffer = this.allocated.peekLast();
        if (lastPooledBuffer != null && (lastBuffer = (ByteBuffer)lastPooledBuffer.getResource()).limit() < lastBuffer.capacity()) {
            this.currentWriteBuffer = lastBuffer.compact();
        }
    }

    boolean isEmpty() {
        return this.allocated.isEmpty();
    }

    int allocSize() {
        return this.allocated.size();
    }
}

