/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm.header;

import org.redline_rpm.header.AbstractHeader;

public class Signature
extends AbstractHeader {
    public Signature() {
        for (SignatureTag tag : SignatureTag.values()) {
            this.tags.put(tag.getCode(), tag);
        }
    }

    @Override
    protected boolean pad() {
        return true;
    }

    public static enum SignatureTag implements AbstractHeader.Tag
    {
        SIGNATURES(62, 7, "signatures"),
        SIGSIZE(257, 4, "sigsize"),
        LEGACY_SIGSIZE(1000, 4, "sigsize"),
        PGP(259, 7, "pgp"),
        LEGACY_PGP(1002, 7, "pgp"),
        MD5(261, 7, "md5"),
        LEGACY_MD5(1004, 7, "md5"),
        GPG(262, 7, "gpg"),
        LEGACY_GPG(1005, 7, "gpg"),
        PAYLOADSIZE(1007, 4, "payloadsize"),
        SHA1HEADER(269, 6, "sha1header"),
        LEGACY_SHA1HEADER(1010, 6, "sha1header"),
        DSAHEADER(267, 7, "dsaheader"),
        LEGACY_DSAHEADER(1011, 7, "dsaheader"),
        RSAHEADER(268, 7, "rsaheader"),
        LEGACY_RSAHEADER(1012, 7, "rsaheader");

        private int code;
        private int type;
        private String name;

        private SignatureTag(int code, int type, String name) {
            this.code = code;
            this.type = type;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean isArrayType() {
            return this.type != 0;
        }
    }
}

