/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class SimpleNamespaceContext
implements NamespaceContext {
    protected Map<String, String> map = new HashMap<String, String>();

    public void addNamespace(String namespaceURI, String prefix) {
        this.map.put(prefix, namespaceURI);
    }

    public void removeNamespace(String prefix) {
        this.map.remove(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(prefix);
        }
        String result = this.map.get(prefix);
        if (result != null) {
            return result;
        }
        if ("".equals(prefix)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return "";
    }

    protected String commonPrefixCheck(String namespaceURI, boolean defaultNS) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException(namespaceURI);
        }
        if (defaultNS && this.getNamespaceURI("").equals(namespaceURI)) {
            return "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator<String> i;
        String result = this.commonPrefixCheck(namespaceURI, true);
        if (result == null && (i = this.prefixIterator(namespaceURI)).hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        String result = this.commonPrefixCheck(namespaceURI, false);
        if (result == null && this.getNamespaceURI("").equals(namespaceURI)) {
            result = "";
        }
        if (result != null) {
            return Collections.singleton(result).iterator();
        }
        return this.prefixIterator(namespaceURI);
    }

    protected Iterator<String> prefixIterator(final String namespaceURI) {
        return new Iterator<String>(){
            private Iterator<Map.Entry<String, String>> iterator;
            {
                this.iterator = SimpleNamespaceContext.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.iterator.hasNext()) {
                    if (!namespaceURI.equals(this.iterator.next().getValue())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                return this.iterator.next().getKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

