/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class RSAKeyPairGenerator {
    private static void exportKeyPair(OutputStream outputStream, OutputStream outputStream2, PublicKey publicKey, PrivateKey privateKey, String string, char[] cArray, boolean bl) throws IOException, InvalidKeyException, NoSuchProviderException, SignatureException, PGPException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyPair pGPKeyPair = new PGPKeyPair(1, publicKey, privateKey, new Date());
        PGPSecretKey pGPSecretKey = new PGPSecretKey(16, pGPKeyPair, string, pGPDigestCalculator, null, null, new JcaPGPContentSignerBuilder(pGPKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(3, pGPDigestCalculator).setProvider("BC").build(cArray));
        pGPSecretKey.encode(outputStream);
        outputStream.close();
        if (bl) {
            outputStream2 = new ArmoredOutputStream(outputStream2);
        }
        PGPPublicKey pGPPublicKey = pGPSecretKey.getPublicKey();
        pGPPublicKey.encode(outputStream2);
        outputStream2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        if (stringArray.length < 2) {
            System.out.println("RSAKeyPairGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        if (stringArray[0].equals("-a")) {
            if (stringArray.length < 3) {
                System.out.println("RSAKeyPairGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream fileOutputStream = new FileOutputStream("secret.asc");
            FileOutputStream fileOutputStream2 = new FileOutputStream("pub.asc");
            RSAKeyPairGenerator.exportKeyPair(fileOutputStream, fileOutputStream2, keyPair.getPublic(), keyPair.getPrivate(), stringArray[1], stringArray[2].toCharArray(), true);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream("secret.bpg");
            FileOutputStream fileOutputStream3 = new FileOutputStream("pub.bpg");
            RSAKeyPairGenerator.exportKeyPair(fileOutputStream, fileOutputStream3, keyPair.getPublic(), keyPair.getPrivate(), stringArray[0], stringArray[1].toCharArray(), false);
        }
    }
}

