/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.redline_rpm.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChannelWrapper {
    protected Map<Key<?>, Consumer<?>> consumers = new HashMap();

    public Key<Integer> start(final WritableByteChannel output) {
        Key<Integer> object = new Key<Integer>();
        this.consumers.put(object, new Consumer<Integer>(){
            int count;

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    this.count += output.write(buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Integer finish() {
                return this.count;
            }
        });
        return object;
    }

    public Key<Integer> start() {
        Key<Integer> object = new Key<Integer>();
        this.consumers.put(object, new Consumer<Integer>(){
            int count;

            @Override
            public void consume(ByteBuffer buffer) {
                this.count += buffer.remaining();
            }

            @Override
            public Integer finish() {
                return this.count;
            }
        });
        return object;
    }

    public Key<byte[]> start(PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        final Signature signature = Signature.getInstance(key.getAlgorithm());
        signature.initSign(key);
        Key<byte[]> object = new Key<byte[]>();
        this.consumers.put(object, new Consumer<byte[]>(){

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    signature.update(buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public byte[] finish() {
                try {
                    return signature.sign();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return object;
    }

    public Key<byte[]> start(PGPPrivateKey key, int algorithm) {
        BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(algorithm, 2);
        final PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(contentSignerBuilder);
        try {
            signatureGenerator.init(0, key);
        }
        catch (PGPException e) {
            throw new RuntimeException("Could not initialize PGP signature generator", e);
        }
        Key<byte[]> object = new Key<byte[]>();
        this.consumers.put(object, new Consumer<byte[]>(){

            @Override
            public void consume(ByteBuffer buffer) {
                if (!buffer.hasRemaining()) {
                    return;
                }
                try {
                    this.write(buffer);
                }
                catch (SignatureException e) {
                    throw new RuntimeException("Could not write buffer to PGP signature generator.", e);
                }
            }

            private void write(ByteBuffer buffer) throws SignatureException {
                if (buffer.hasArray()) {
                    byte[] bufferBytes = buffer.array();
                    int offset = buffer.arrayOffset();
                    int position = buffer.position();
                    int limit = buffer.limit();
                    signatureGenerator.update(bufferBytes, offset + position, limit - position);
                    buffer.position(limit);
                } else {
                    int chunk;
                    int length;
                    byte[] bytes = new byte[Util.getTempArraySize(length)];
                    for (length = buffer.remaining(); length > 0; length -= chunk) {
                        chunk = Math.min(length, bytes.length);
                        buffer.get(bytes, 0, chunk);
                        signatureGenerator.update(bytes, 0, chunk);
                    }
                }
            }

            @Override
            public byte[] finish() {
                try {
                    return signatureGenerator.generate().getEncoded();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not generate signature.", e);
                }
            }
        });
        return object;
    }

    public Key<byte[]> start(String algorithm) throws NoSuchAlgorithmException {
        final MessageDigest digest = MessageDigest.getInstance(algorithm);
        Key<byte[]> object = new Key<byte[]>();
        this.consumers.put(object, new Consumer<byte[]>(){

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    digest.update(buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public byte[] finish() {
                try {
                    return digest.digest();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return object;
    }

    public <T> T finish(Key<T> object) {
        return (T)this.consumers.remove(object).finish();
    }

    public void close() throws IOException {
        if (!this.consumers.isEmpty()) {
            throw new IOException("There are '" + this.consumers.size() + "' unfinished operations.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Consumer<T> {
        public void consume(ByteBuffer var1);

        public T finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key<T> {
    }
}

