/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.IntString;
import org.redline_rpm.SignatureGenerator;
import org.redline_rpm.Util;
import org.redline_rpm.WritableChannelWrapper;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Architecture;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.Os;
import org.redline_rpm.header.RpmType;
import org.redline_rpm.header.Signature;
import org.redline_rpm.payload.Contents;
import org.redline_rpm.payload.CpioHeader;
import org.redline_rpm.payload.Directive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    private static final int GPGSIZE = 65;
    private static final int DSASIZE = 65;
    private static final int SHASIZE = 41;
    private static final int MD5SIZE = 32;
    private static final String DEFAULTSCRIPTPROG = "/bin/sh";
    private static final char[] ILLEGAL_CHARS_VARIABLE = new char[]{'-', '~', '/'};
    private static final char[] ILLEGAL_CHARS_NAME = new char[]{'/', ' ', '\t', '\n', '\r'};
    protected final Format format = new Format();
    protected final Set<PrivateKey> signatures = new HashSet<PrivateKey>();
    protected final Map<String, CharSequence> dependencies = new LinkedHashMap<String, CharSequence>();
    protected final Map<String, Integer> flags = new LinkedHashMap<String, Integer>();
    protected final Map<String, CharSequence> obsoletes = new LinkedHashMap<String, CharSequence>();
    protected final Map<String, Integer> obsoletesFlags = new LinkedHashMap<String, Integer>();
    protected final Map<String, CharSequence> conflicts = new LinkedHashMap<String, CharSequence>();
    protected final Map<String, Integer> conflictsFlags = new LinkedHashMap<String, Integer>();
    protected final Map<String, CharSequence> provides = new LinkedHashMap<String, CharSequence>();
    protected final Map<String, Integer> providesFlags = new LinkedHashMap<String, Integer>();
    protected final List<String> triggerscripts = new LinkedList<String>();
    protected final List<String> triggerscriptprogs = new LinkedList<String>();
    protected final List<String> triggernames = new LinkedList<String>();
    protected final List<String> triggerversions = new LinkedList<String>();
    protected final List<Integer> triggerflags = new LinkedList<Integer>();
    protected final List<Integer> triggerindexes = new LinkedList<Integer>();
    private int triggerCounter = 0;
    protected final AbstractHeader.Entry<byte[]> signature = this.format.getSignature().addEntry(Signature.SignatureTag.SIGNATURES, 16);
    protected final AbstractHeader.Entry<byte[]> immutable = this.format.getHeader().addEntry(Header.HeaderTag.HEADERIMMUTABLE, 16);
    protected Contents contents = new Contents();
    protected File privateKeyRingFile;
    protected String privateKeyId;
    protected String privateKeyPassphrase;
    protected PGPPrivateKey privateKey;

    public Builder() {
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.HEADERI18NTABLE, "C");
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.BUILDTIME, (int)(System.currentTimeMillis() / 1000L));
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.RPMVERSION, "4.4.2");
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PAYLOADFORMAT, "cpio");
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PAYLOADCOMPRESSOR, "gzip");
        this.addDependencyLess("rpmlib(VersionedDependencies)", "3.0.3-1");
        this.addDependencyLess("rpmlib(CompressedFileNames)", "3.0.4-1");
        this.addDependencyLess("rpmlib(PayloadFilesHavePrefix)", "4.0-1");
    }

    public void addBuiltinDirectory(String builtinDirectory) {
        this.contents.addLocalBuiltinDirectory(builtinDirectory);
    }

    public void addObsoletes(String name, int comparison, String version) {
        this.obsoletes.put(name, version);
        this.obsoletesFlags.put(name, comparison);
    }

    public void addObsoletesLess(CharSequence name, CharSequence version) {
        int flag = 10;
        this.addObsoletes(name, version, flag);
    }

    public void addObsoletesMore(CharSequence name, CharSequence version) {
        int flag = 12;
        this.addObsoletes(name, version, flag);
    }

    protected void addObsoletes(CharSequence name, CharSequence version, int flag) {
        this.obsoletes.put(name.toString(), version);
        this.obsoletesFlags.put(name.toString(), flag);
    }

    public void addConflicts(String name, int comparison, String version) {
        this.conflicts.put(name, version);
        this.conflictsFlags.put(name, comparison);
    }

    public void addConflictsLess(CharSequence name, CharSequence version) {
        int flag = 10;
        this.addConflicts(name, version, flag);
    }

    public void addConflictsMore(CharSequence name, CharSequence version) {
        int flag = 12;
        this.addConflicts(name, version, flag);
    }

    protected void addConflicts(CharSequence name, CharSequence version, int flag) {
        this.conflicts.put(name.toString(), version);
        this.conflictsFlags.put(name.toString(), flag);
    }

    public void addProvides(String name, String version) {
        this.provides.put(name, version);
        this.providesFlags.put(name, version.length() > 0 ? 8 : 0);
    }

    protected void addProvides(CharSequence name, CharSequence version, int flag) {
        this.provides.put(name.toString(), version);
        this.providesFlags.put(name.toString(), flag);
    }

    public void addDependency(String name, int comparison, String version) {
        this.dependencies.put(name, version);
        this.flags.put(name, comparison);
    }

    public void addDependencyLess(CharSequence name, CharSequence version) {
        int flag = 10;
        if (name.toString().startsWith("rpmlib(")) {
            flag |= 0x1000040;
        }
        this.addDependency(name, version, flag);
    }

    public void addDependencyMore(CharSequence name, CharSequence version) {
        this.addDependency(name, version, 12);
    }

    protected void addDependency(CharSequence name, CharSequence version, int flag) {
        this.dependencies.put(name.toString(), version);
        this.flags.put(name.toString(), flag);
    }

    public void addHeaderEntry(AbstractHeader.Tag tag, String value) {
        this.format.getHeader().createEntry(tag, value);
    }

    private void checkVariableContainsIllegalChars(char[] illegalChars, CharSequence variable, String variableName) {
        for (int i = 0; i < variable.length(); ++i) {
            char currChar = variable.charAt(i);
            for (char illegalChar : illegalChars) {
                if (currChar != illegalChar) continue;
                throw new IllegalArgumentException(variableName + " with value: '" + variable + "' contains illegal character " + currChar);
            }
        }
    }

    public void setPackage(CharSequence name, CharSequence version, CharSequence release, int epoch) {
        this.checkVariableContainsIllegalChars(ILLEGAL_CHARS_NAME, name, "name");
        this.checkVariableContainsIllegalChars(ILLEGAL_CHARS_VARIABLE, version, "version");
        this.checkVariableContainsIllegalChars(ILLEGAL_CHARS_VARIABLE, release, "release");
        this.format.getLead().setName(name + "-" + version + "-" + release);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.NAME, name);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.VERSION, version);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.RELEASE, release);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.EPOCH, epoch);
        this.provides.clear();
        this.addProvides(String.valueOf(name), "" + epoch + ":" + version + "-" + release);
    }

    public void setPackage(CharSequence name, CharSequence version, CharSequence release) {
        this.setPackage(name, version, release, 0);
    }

    public void setType(RpmType type) {
        this.format.getLead().setType(type);
    }

    public void setPlatform(Architecture arch, Os os) {
        this.format.getLead().setArch(arch);
        this.format.getLead().setOs(os);
        String archName = arch.toString().toLowerCase();
        String osName = os.toString().toLowerCase();
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.ARCH, archName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.OS, osName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PLATFORM, archName + "-" + osName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.RHNPLATFORM, archName);
    }

    public void setPlatform(Architecture arch, CharSequence osName) {
        this.format.getLead().setArch(arch);
        this.format.getLead().setOs(Os.UNKNOWN);
        String archName = arch.toString().toLowerCase();
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.ARCH, archName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.OS, osName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PLATFORM, archName + "-" + osName);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.RHNPLATFORM, archName);
    }

    public void setSummary(CharSequence summary) {
        if (summary != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.SUMMARY, summary);
        }
    }

    public void setDescription(CharSequence description) {
        if (description != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.DESCRIPTION, description);
        }
    }

    public void setBuildHost(CharSequence host) {
        if (host != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.BUILDHOST, host);
        }
    }

    public void setLicense(CharSequence license) {
        if (license != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.LICENSE, license);
        }
    }

    public void setGroup(CharSequence group) {
        if (group != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.GROUP, group);
        }
    }

    public void setDistribution(CharSequence distribution) {
        if (distribution != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.DISTRIBUTION, distribution);
        }
    }

    public void setVendor(CharSequence vendor) {
        if (vendor != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.VENDOR, vendor);
        }
    }

    public void setPackager(CharSequence packager) {
        if (packager != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PACKAGER, packager);
        }
    }

    public void setUrl(CharSequence url) {
        if (url != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.URL, url);
        }
    }

    public void setProvides(CharSequence provides) {
        if (provides != null) {
            this.provides.clear();
            this.addProvides(provides, "", 8);
        }
    }

    public void setFiles(Contents contents) {
        this.contents = contents;
    }

    public void setSourceRpm(String rpm) {
        if (rpm != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.SOURCERPM, rpm);
        }
    }

    public void setPrefixes(String ... prefixes) {
        if (prefixes != null && 0 < prefixes.length) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREFIXES, prefixes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScript(File file) throws IOException {
        if (file == null) {
            return null;
        }
        StringBuilder script = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                script.append(line);
                script.append("\n");
            }
        }
        finally {
            in.close();
        }
        return script.toString();
    }

    private String readProgram(String script) {
        Pattern pattern;
        Matcher matcher;
        String program = null;
        if (script != null && (matcher = (pattern = Pattern.compile("^#!(/.*)")).matcher(script)).find()) {
            program = matcher.group(1);
        }
        return program;
    }

    public void setPreTransScript(String script) {
        this.setPreTransProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PRETRANSSCRIPT, script);
        }
    }

    public void setPreTransScript(File file) throws IOException {
        this.setPreTransScript(this.readScript(file));
    }

    public void setPreTransProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PRETRANSPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PRETRANSPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PRETRANSPROG, program);
        }
    }

    public void setPreInstallScript(String script) {
        this.setPreInstallProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREINSCRIPT, script);
        }
    }

    public void setPreInstallScript(File file) throws IOException {
        this.setPreInstallScript(this.readScript(file));
    }

    public void setPreInstallProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREINPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREINPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREINPROG, program);
        }
    }

    public void setPostInstallScript(String script) {
        this.setPostInstallProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTINSCRIPT, script);
        }
    }

    public void setPostInstallScript(File file) throws IOException {
        this.setPostInstallScript(this.readScript(file));
    }

    public void setPostInstallProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTINPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTINPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTINPROG, program);
        }
    }

    public void setPreUninstallScript(String script) {
        this.setPreUninstallProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREUNSCRIPT, script);
        }
    }

    public void setPreUninstallScript(File file) throws IOException {
        this.setPreUninstallScript(this.readScript(file));
    }

    public void setPreUninstallProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREUNPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREUNPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PREUNPROG, program);
        }
    }

    public void setPostUninstallScript(String script) {
        this.setPostUninstallProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTUNSCRIPT, script);
        }
    }

    public void setPostUninstallScript(File file) throws IOException {
        this.setPostUninstallScript(this.readScript(file));
    }

    public void setPostUninstallProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTUNPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTUNPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTUNPROG, program);
        }
    }

    public void setPostTransScript(String script) {
        this.setPostTransProgram(this.readProgram(script));
        if (script != null) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTTRANSSCRIPT, script);
        }
    }

    public void setPostTransScript(File file) throws IOException {
        this.setPostTransScript(this.readScript(file));
    }

    public void setPostTransProgram(String program) {
        if (null == program) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTTRANSPROG, DEFAULTSCRIPTPROG);
        } else if (0 == program.length()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTTRANSPROG, DEFAULTSCRIPTPROG);
        } else {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.POSTTRANSPROG, program);
        }
    }

    public void addTrigger(File script, String prog, Map<String, IntString> depends, int flag) throws IOException {
        this.triggerscripts.add(this.readScript(script));
        if (null == prog) {
            this.triggerscriptprogs.add(DEFAULTSCRIPTPROG);
        } else if (0 == prog.length()) {
            this.triggerscriptprogs.add(DEFAULTSCRIPTPROG);
        } else {
            this.triggerscriptprogs.add(prog);
        }
        for (Map.Entry<String, IntString> depend : depends.entrySet()) {
            this.triggernames.add(depend.getKey());
            this.triggerflags.add(depend.getValue().getInt() | flag);
            this.triggerversions.add(depend.getValue().getString());
            this.triggerindexes.add(this.triggerCounter);
        }
        ++this.triggerCounter;
    }

    public void addFile(String path, File source, int mode) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode);
    }

    public void addFile(String path, File source, int mode, int dirmode) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, dirmode);
    }

    public void addFile(String path, File source, int mode, int dirmode, String uname, String gname) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, null, uname, gname, dirmode);
    }

    public void addFile(String path, File source, int mode, int dirmode, Directive directive, String uname, String gname) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, directive, uname, gname, dirmode);
    }

    public void addFile(String path, File source, int mode, int dirmode, Directive directive, String uname, String gname, boolean addParents) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, directive, uname, gname, dirmode, addParents);
    }

    public void addFile(String path, File source, int mode, int dirmode, Directive directive, String uname, String gname, boolean addParents, int verifyFlags) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, directive, uname, gname, dirmode, addParents, verifyFlags);
    }

    public void addFile(String path, File source, int mode, Directive directive, String uname, String gname) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, directive, uname, gname);
    }

    public void addFile(String path, File source, int mode, Directive directive) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source, mode, directive);
    }

    public void addFile(String path, File source) throws NoSuchAlgorithmException, IOException {
        this.contents.addFile(path, source);
    }

    public void addURL(String path, URL source, int mode, int dirmode) throws NoSuchAlgorithmException, IOException {
        this.contents.addURL(path, source, mode, null, null, null, dirmode);
    }

    public void addURL(String path, URL source, int mode, int dirmode, String username, String group) throws NoSuchAlgorithmException, IOException {
        this.contents.addURL(path, source, mode, null, username, group, dirmode);
    }

    public void addURL(String path, URL source, int mode, int dirmode, Directive directive, String username, String group) throws NoSuchAlgorithmException, IOException {
        this.contents.addURL(path, source, mode, directive, username, group, dirmode);
    }

    public void addDirectory(String path) throws NoSuchAlgorithmException, IOException {
        this.contents.addDirectory(path);
    }

    public void addDirectory(String path, int permissions, Directive directive, String uname, String gname) throws NoSuchAlgorithmException, IOException {
        this.contents.addDirectory(path, permissions, directive, uname, gname);
    }

    public void addDirectory(String path, int permissions, Directive directive, String uname, String gname, boolean addParents) throws NoSuchAlgorithmException, IOException {
        this.contents.addDirectory(path, permissions, directive, uname, gname, addParents);
    }

    public void addDirectory(String path, Directive directive) throws NoSuchAlgorithmException, IOException {
        this.contents.addDirectory(path, directive);
    }

    public void addLink(String path, String target) throws NoSuchAlgorithmException, IOException {
        this.contents.addLink(path, target);
    }

    public void addLink(String path, String target, int permissions) throws NoSuchAlgorithmException, IOException {
        this.contents.addLink(path, target, permissions);
    }

    public void addLink(String path, String target, int permissions, String username, String groupname) throws NoSuchAlgorithmException, IOException {
        this.contents.addLink(path, target, permissions, username, groupname);
    }

    public void addSignature(PrivateKey key) {
        this.signatures.add(key);
    }

    public void setPrivateKeyRingFile(File privateKeyRingFile) {
        this.privateKeyRingFile = privateKeyRingFile;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setPrivateKey(PGPPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String build(File directory) throws NoSuchAlgorithmException, IOException {
        String rpm = this.format.getLead().getName() + "." + this.format.getLead().getArch().toString().toLowerCase() + ".rpm";
        File file = new File(directory, rpm);
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile raFile = new RandomAccessFile(file, "rw");
        this.build(raFile.getChannel());
        raFile.close();
        return rpm;
    }

    public void build(FileChannel original) throws NoSuchAlgorithmException, IOException {
        WritableChannelWrapper output = new WritableChannelWrapper(original);
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.REQUIRENAME, this.dependencies.keySet().toArray(new String[this.dependencies.size()]));
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.REQUIREVERSION, this.dependencies.values().toArray(new String[this.dependencies.size()]));
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.REQUIREFLAGS, this.convert(this.flags.values().toArray(new Integer[this.flags.size()])));
        if (0 < this.obsoletes.size()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.OBSOLETENAME, this.obsoletes.keySet().toArray(new String[this.obsoletes.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.OBSOLETEVERSION, this.obsoletes.values().toArray(new String[this.obsoletes.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.OBSOLETEFLAGS, this.convert(this.obsoletesFlags.values().toArray(new Integer[this.obsoletesFlags.size()])));
        }
        if (0 < this.conflicts.size()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.CONFLICTNAME, this.conflicts.keySet().toArray(new String[this.conflicts.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.CONFLICTVERSION, this.conflicts.values().toArray(new String[this.conflicts.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.CONFLICTFLAGS, this.convert(this.conflictsFlags.values().toArray(new Integer[this.conflictsFlags.size()])));
        }
        if (0 < this.provides.size()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PROVIDENAME, this.provides.keySet().toArray(new String[this.provides.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PROVIDEVERSION, this.provides.values().toArray(new String[this.provides.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PROVIDEFLAGS, this.convert(this.providesFlags.values().toArray(new Integer[this.providesFlags.size()])));
        }
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.SIZE, this.contents.getTotalSize());
        if (0 < this.contents.size()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.DIRNAMES, this.contents.getDirNames());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.DIRINDEXES, this.contents.getDirIndexes());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.BASENAMES, this.contents.getBaseNames());
        }
        if (0 < this.triggerCounter) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERSCRIPTS, this.triggerscripts.toArray(new String[this.triggerscripts.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERNAME, this.triggernames.toArray(new String[this.triggernames.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERVERSION, this.triggerversions.toArray(new String[this.triggerversions.size()]));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERFLAGS, this.convert(this.triggerflags.toArray(new Integer[this.triggerflags.size()])));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERINDEX, this.convert(this.triggerindexes.toArray(new Integer[this.triggerindexes.size()])));
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.TRIGGERSCRIPTPROG, this.triggerscriptprogs.toArray(new String[this.triggerscriptprogs.size()]));
        }
        if (0 < this.contents.size()) {
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEMD5S, this.contents.getMD5s());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILESIZES, this.contents.getSizes());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEMODES, this.contents.getModes());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILERDEVS, this.contents.getRdevs());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEMTIMES, this.contents.getMtimes());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILELINKTOS, this.contents.getLinkTos());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEFLAGS, this.contents.getFlags());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEUSERNAME, this.contents.getUsers());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEGROUPNAME, this.contents.getGroups());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEVERIFYFLAGS, this.contents.getVerifyFlags());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEDEVICES, this.contents.getDevices());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILEINODES, this.contents.getInodes());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILELANGS, this.contents.getLangs());
            this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.FILECONTEXTS, this.contents.getContexts());
        }
        this.format.getHeader().createEntry((AbstractHeader.Tag)Header.HeaderTag.PAYLOADFLAGS, new String[]{"9"});
        AbstractHeader.Entry<?> sigsize = this.format.getSignature().addEntry(Signature.SignatureTag.LEGACY_SIGSIZE, 1);
        AbstractHeader.Entry<?> payload = this.format.getSignature().addEntry(Signature.SignatureTag.PAYLOADSIZE, 1);
        AbstractHeader.Entry<?> md5 = this.format.getSignature().addEntry(Signature.SignatureTag.LEGACY_MD5, 16);
        AbstractHeader.Entry<?> sha = this.format.getSignature().addEntry(Signature.SignatureTag.SHA1HEADER, 1);
        sha.setSize(41);
        SignatureGenerator signatureGenerator = this.createSignatureGenerator();
        signatureGenerator.prepare(this.format.getSignature());
        this.format.getLead().write(original);
        this.signature.setValues(this.getSignature(this.format.getSignature().count()));
        Util.empty(output, ByteBuffer.allocate(this.format.getSignature().write(original)));
        ChannelWrapper.Key<Integer> sigsizekey = output.start();
        ChannelWrapper.Key<byte[]> shakey = output.start("SHA");
        ChannelWrapper.Key<byte[]> md5key = output.start("MD5");
        signatureGenerator.startBeforeHeader(output);
        this.immutable.setValues(this.getImmutable(this.format.getHeader().count()));
        this.format.getHeader().write(output);
        sha.setValues(new String[]{Util.hex(output.finish(shakey))});
        signatureGenerator.finishAfterHeader(output);
        GZIPOutputStream zip = new GZIPOutputStream(Channels.newOutputStream(output));
        WritableChannelWrapper compressor = new WritableChannelWrapper(Channels.newChannel(zip));
        ChannelWrapper.Key<Integer> payloadkey = compressor.start();
        int total = 0;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        for (CpioHeader header : this.contents.headers()) {
            if ((header.getFlags() & 0x40) == 64) continue;
            String path = header.getName();
            if (path.startsWith("/")) {
                header.setName("." + path);
            }
            total = header.write(compressor, total);
            Object object = this.contents.getSource(header);
            if (object instanceof File) {
                FileInputStream fin = new FileInputStream((File)object);
                FileChannel in = fin.getChannel();
                while (in.read((ByteBuffer)buffer.rewind()) > 0) {
                    total += compressor.write((ByteBuffer)buffer.flip());
                    buffer.compact();
                }
                total += header.skip(compressor, total);
                fin.close();
                continue;
            }
            if (object instanceof URL) {
                ReadableByteChannel in = Channels.newChannel(((URL)object).openConnection().getInputStream());
                while (in.read((ByteBuffer)buffer.rewind()) > 0) {
                    total += compressor.write((ByteBuffer)buffer.flip());
                    buffer.compact();
                }
                total += header.skip(compressor, total);
                in.close();
                continue;
            }
            if (!(object instanceof CharSequence)) continue;
            CharSequence target = (CharSequence)object;
            total += compressor.write(ByteBuffer.wrap(String.valueOf(target).getBytes()));
            total += header.skip(compressor, target.length());
        }
        CpioHeader trailer = new CpioHeader();
        trailer.setLast();
        total = trailer.write(compressor, total);
        trailer.skip(compressor, total);
        int length = compressor.finish(payloadkey);
        int pad = Util.difference(length, 3);
        Util.empty(compressor, ByteBuffer.allocate(pad));
        payload.setValues(new int[]{length += pad});
        zip.finish();
        md5.setValues(output.finish(md5key));
        sigsize.setValues(new int[]{output.finish(sigsizekey)});
        signatureGenerator.finishAfterPayload(output);
        this.format.getSignature().writePending(original);
    }

    protected SignatureGenerator createSignatureGenerator() {
        if (this.privateKey != null) {
            return new SignatureGenerator(this.privateKey);
        }
        return new SignatureGenerator(this.privateKeyRingFile, this.privateKeyId, this.privateKeyPassphrase);
    }

    protected byte[] getSignature(int count) {
        return this.getSpecial(62, count);
    }

    protected byte[] getImmutable(int count) {
        return this.getSpecial(63, count);
    }

    protected byte[] getSpecial(int tag, int count) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(tag);
        buffer.putInt(7);
        buffer.putInt(count * -16);
        buffer.putInt(16);
        return buffer.array();
    }

    protected int[] convert(Integer[] ints) {
        int[] array = new int[ints.length];
        int count = 0;
        Integer[] integerArray = ints;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            array[count++] = i2;
        }
        return array;
    }
}

