/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm.ant;

import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.TarFileSet;
import org.redline_rpm.payload.Directive;

public class RpmFileSet
extends TarFileSet {
    private Directive directive = new Directive();
    private boolean addParents = true;

    public RpmFileSet() {
    }

    protected RpmFileSet(FileSet fileset) {
        super(fileset);
    }

    protected RpmFileSet(RpmFileSet fileset) {
        super(fileset);
        this.directive = fileset.directive;
    }

    public Directive getDirective() {
        return this.directive;
    }

    public void setGhost(boolean ghost) {
        this.checkRpmFileSetAttributesAllowed();
        if (ghost) {
            this.directive.set(64);
        } else {
            this.directive.unset(64);
        }
    }

    public void setConfig(boolean config) {
        this.checkRpmFileSetAttributesAllowed();
        if (config) {
            this.directive.set(1);
        } else {
            this.directive.unset(1);
        }
    }

    public void setNoReplace(boolean noReplace) {
        this.checkRpmFileSetAttributesAllowed();
        if (noReplace) {
            this.directive.set(16);
        } else {
            this.directive.unset(16);
        }
    }

    public void setDoc(boolean doc) {
        this.checkRpmFileSetAttributesAllowed();
        if (doc) {
            this.directive.set(2);
        } else {
            this.directive.unset(2);
        }
    }

    @Override
    public Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        return super.clone();
    }

    private void checkRpmFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof RpmFileSet) {
            this.checkAttributesAllowed();
        }
    }

    public boolean getAddParents() {
        return this.addParents;
    }

    public void setAddParents(boolean addParents) {
        this.addParents = addParents;
    }
}

