/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.redline.ant;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.freecompany.redline.Builder;
import org.freecompany.redline.Util;
import org.freecompany.redline.ant.Depends;
import org.freecompany.redline.ant.Ghost;
import org.freecompany.redline.ant.Link;
import org.freecompany.redline.ant.RpmFileSet;
import org.freecompany.redline.ant.TriggerIn;
import org.freecompany.redline.ant.TriggerPostUn;
import org.freecompany.redline.ant.TriggerPreIn;
import org.freecompany.redline.ant.TriggerUn;
import org.freecompany.redline.header.Architecture;
import org.freecompany.redline.header.Header;
import org.freecompany.redline.header.Os;
import org.freecompany.redline.header.RpmType;
import org.freecompany.redline.payload.Directive;

public class RedlineTask
extends Task {
    public static final String NAMESPACE = "http://freecompany.org/namespace/redline";
    protected String name;
    protected String version;
    protected String group;
    protected String release = "1";
    protected String host;
    protected String summary = "";
    protected String description = "";
    protected String license = "";
    protected String packager = System.getProperty("user.name", "");
    protected String distribution = "";
    protected String vendor = "";
    protected String url = "";
    protected String sourcePackage = null;
    protected String provides;
    protected String prefixes;
    protected RpmType type = RpmType.BINARY;
    protected Architecture architecture = Architecture.NOARCH;
    protected Os os = Os.LINUX;
    protected File destination;
    protected List<ArchiveFileSet> filesets = new ArrayList<ArchiveFileSet>();
    protected List<Ghost> ghosts = new ArrayList<Ghost>();
    protected List<Link> links = new ArrayList<Link>();
    protected List<Depends> depends = new ArrayList<Depends>();
    protected List<TriggerPreIn> triggersPreIn = new ArrayList<TriggerPreIn>();
    protected List<TriggerIn> triggersIn = new ArrayList<TriggerIn>();
    protected List<TriggerUn> triggersUn = new ArrayList<TriggerUn>();
    protected List<TriggerPostUn> triggersPostUn = new ArrayList<TriggerPostUn>();
    protected File preTransScript;
    protected File preInstallScript;
    protected File postInstallScript;
    protected File preUninstallScript;
    protected File postUninstallScript;
    protected File postTransScript;
    protected File privateKeyRingFile;
    protected String privateKeyId;
    protected String privateKeyPassphrase;

    public RedlineTask() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.host = "";
        }
    }

    public void execute() {
        if (this.name == null) {
            throw new BuildException("Attribute 'name' is required.");
        }
        if (this.version == null) {
            throw new BuildException("Attribute 'version' is required.");
        }
        if (this.group == null) {
            throw new BuildException("Attribute 'group' is required.");
        }
        Builder builder = new Builder();
        builder.setPackage(this.name, this.version, this.release);
        builder.setType(this.type);
        builder.setPlatform(this.architecture, this.os);
        builder.setGroup(this.group);
        builder.setBuildHost(this.host);
        builder.setSummary(this.summary);
        builder.setDescription(this.description);
        builder.setLicense(this.license);
        builder.setPackager(this.packager);
        builder.setDistribution(this.distribution);
        builder.setVendor(this.vendor);
        builder.setUrl(this.url);
        builder.setProvides(this.provides == null ? this.name : this.provides);
        builder.setPrefixes(this.prefixes == null ? null : this.prefixes.split(","));
        builder.setPrivateKeyRingFile(this.privateKeyRingFile);
        builder.setPrivateKeyId(this.privateKeyId);
        builder.setPrivateKeyPassphrase(this.privateKeyPassphrase);
        if (this.sourcePackage != null) {
            builder.addHeaderEntry(Header.HeaderTag.SOURCERPM, this.sourcePackage);
        }
        try {
            if (null != this.preTransScript) {
                builder.setPreTransScript(this.preTransScript);
                builder.setPreTransProgram("");
            }
            if (null != this.preInstallScript) {
                builder.setPreInstallScript(this.preInstallScript);
                builder.setPreInstallProgram("");
            }
            if (null != this.postInstallScript) {
                builder.setPostInstallScript(this.postInstallScript);
                builder.setPostInstallProgram("");
            }
            if (null != this.preUninstallScript) {
                builder.setPreUninstallScript(this.preUninstallScript);
                builder.setPreUninstallProgram("");
            }
            if (null != this.postUninstallScript) {
                builder.setPostUninstallScript(this.postUninstallScript);
                builder.setPostUninstallProgram("");
            }
            if (null != this.postTransScript) {
                builder.setPostTransScript(this.postTransScript);
                builder.setPostTransProgram("");
            }
            for (ArchiveFileSet fileset : this.filesets) {
                File archive = fileset.getSrc(this.getProject());
                String prefix = Util.normalizePath(fileset.getPrefix(this.getProject()));
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
                int filemode = fileset.getFileMode(this.getProject()) & 0xFFF;
                int dirmode = fileset.getDirMode(this.getProject()) & 0xFFF;
                String username = null;
                String group = null;
                Directive directive = null;
                if (fileset instanceof TarFileSet) {
                    TarFileSet tarFileSet = (TarFileSet)fileset;
                    username = tarFileSet.getUserName();
                    group = tarFileSet.getGroup();
                    if (fileset instanceof RpmFileSet) {
                        RpmFileSet rpmFileSet = (RpmFileSet)fileset;
                        directive = rpmFileSet.getDirective();
                    }
                }
                for (String entry : scanner.getIncludedDirectories()) {
                    String dir = Util.normalizePath(prefix + entry);
                    if ("".equals(entry)) continue;
                    builder.addDirectory(dir, dirmode, directive, username, group, true);
                }
                for (String entry : scanner.getIncludedFiles()) {
                    if (archive != null) {
                        URL url = new URL("jar:" + archive.toURL() + "!/" + entry);
                        builder.addURL(prefix + entry, url, filemode, dirmode, directive, username, group);
                        continue;
                    }
                    File file = new File(scanner.getBasedir(), entry);
                    builder.addFile(prefix + entry, file, filemode, dirmode, directive, username, group);
                }
            }
            for (Ghost ghost : this.ghosts) {
                builder.addFile(ghost.getPath(), null, ghost.getFilemode(), ghost.getDirmode(), Directive.GHOST, ghost.getUsername(), ghost.getGroup());
            }
            for (Link link : this.links) {
                builder.addLink(link.getPath(), link.getTarget(), link.getPermissions());
            }
            for (Depends dependency : this.depends) {
                builder.addDependency(dependency.getName(), dependency.getComparison(), dependency.getVersion());
            }
            for (TriggerPreIn triggerPreIn : this.triggersPreIn) {
                builder.addTrigger(triggerPreIn.getScript(), "", triggerPreIn.getDepends(), triggerPreIn.getFlag());
            }
            for (TriggerIn triggerIn : this.triggersIn) {
                builder.addTrigger(triggerIn.getScript(), "", triggerIn.getDepends(), triggerIn.getFlag());
            }
            for (TriggerUn triggerUn : this.triggersUn) {
                builder.addTrigger(triggerUn.getScript(), "", triggerUn.getDepends(), triggerUn.getFlag());
            }
            for (TriggerPostUn triggerPostUn : this.triggersPostUn) {
                builder.addTrigger(triggerPostUn.getScript(), "", triggerPostUn.getDepends(), triggerPostUn.getFlag());
            }
            this.log("Created rpm: " + builder.build(this.destination));
        }
        catch (IOException e) {
            throw new BuildException("Error packaging distribution files.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("This system does not support MD5 digests.", (Throwable)e);
        }
    }

    public void restrict(String name) {
        Iterator<Depends> i = this.depends.iterator();
        while (i.hasNext()) {
            Depends dependency = i.next();
            if (!dependency.getName().equals(name)) continue;
            i.remove();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = RpmType.valueOf(type);
    }

    public void setArchitecture(String architecture) {
        this.architecture = Architecture.valueOf(architecture);
    }

    public void setOs(String os) {
        this.os = Os.valueOf(os);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setPackager(String packager) {
        this.packager = packager;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProvides(String provides) {
        this.provides = provides;
    }

    public void setPrefixes(String prefixes) {
        this.prefixes = prefixes;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void addZipfileset(ZipFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addTarfileset(TarFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addRpmfileset(RpmFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addGhost(Ghost ghost) {
        this.ghosts.add(ghost);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addDepends(Depends dependency) {
        this.depends.add(dependency);
    }

    public void addTriggerPreIn(TriggerPreIn triggerPreIn) {
        this.triggersPreIn.add(triggerPreIn);
    }

    public void addTriggerIn(TriggerIn triggerIn) {
        this.triggersIn.add(triggerIn);
    }

    public void addTriggerUn(TriggerUn triggerUn) {
        this.triggersUn.add(triggerUn);
    }

    public void addTriggerPostUn(TriggerPostUn triggerPostUn) {
        this.triggersPostUn.add(triggerPostUn);
    }

    public void setPreTransScript(File preTransScript) {
        this.preTransScript = preTransScript;
    }

    public void setPreInstallScript(File preInstallScript) {
        this.preInstallScript = preInstallScript;
    }

    public void setPostInstallScript(File postInstallScript) {
        this.postInstallScript = postInstallScript;
    }

    public void setPreUninstallScript(File preUninstallScript) {
        this.preUninstallScript = preUninstallScript;
    }

    public void setPostUninstallScript(File postUninstallScript) {
        this.postUninstallScript = postUninstallScript;
    }

    public void setPostTransScript(File postTransScript) {
        this.postTransScript = postTransScript;
    }

    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    public void setPrivateKeyRingFile(File privateKeyRingFile) {
        this.privateKeyRingFile = privateKeyRingFile;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }
}

