/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.weixin;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.redkale.convert.json.JsonConvert;
import org.redkale.net.WorkThread;
import org.redkale.service.Local;
import org.redkale.service.Service;
import org.redkale.util.AutoLoad;
import org.redkale.util.ByteArray;
import org.redkale.util.TypeToken;
import org.redkale.util.Utility;
import org.redkalex.weixin.WeiXinQYMessage;

@Local
@AutoLoad(value=false)
public class WeiXinQYService
implements Service {
    protected final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final boolean finest = this.logger.isLoggable(Level.FINEST);
    private final boolean finer = this.logger.isLoggable(Level.FINER);
    private static final String BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Random RANDOM = new Random();
    protected static final Type MAPTYPE = new TypeToken<Map<String, String>>(){}.getType();
    @Resource
    protected JsonConvert convert;
    @Resource(name="property.wxqy.token")
    protected String qytoken = "";
    @Resource(name="property.wxqy.corpid")
    protected String qycorpid = "wxYYYYYYYYYYYYYYYY";
    @Resource(name="property.wxqy.aeskey")
    protected String qyaeskey = "";
    @Resource(name="property.wxqy.secret")
    private String qysecret = "#########################";
    private SecretKeySpec qykeyspec;
    private IvParameterSpec qyivspec;
    private final Token qyAccessToken = new Token();

    public Map<String, String> getQYUserCode(String code, String agentid) throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=" + this.getQYAccessToken() + "&code=" + code + "&agentid=" + agentid;
        String json = Utility.getHttpContent((String)url);
        if (this.finest) {
            this.logger.finest(url + "--->" + json);
        }
        return (Map)this.convert.convertFrom(MAPTYPE, json);
    }

    public void sendQYTextMessage(String agentid, String message) {
        this.sendQYMessage(new WeiXinQYMessage(agentid, message));
    }

    public void sendQYTextMessage(String agentid, Supplier<String> contentSupplier) {
        this.sendQYMessage(new WeiXinQYMessage(agentid, contentSupplier));
    }

    public void sendQYMessage(WeiXinQYMessage message) {
        this.runAsync(() -> {
            String result = null;
            try {
                message.supplyContent();
                if (message.getText() == null) {
                    return;
                }
                String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + this.getQYAccessToken();
                result = Utility.postHttpContent((String)url, (String)this.convert.convertTo((Object)message));
                if (this.finest) {
                    this.logger.finest("sendQYMessage ok: " + message + " -> " + result);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "sendQYMessage error: " + message + " -> " + result, e);
            }
        });
    }

    public String verifyQYURL(String msgSignature, String timeStamp, String nonce, String echoStr) {
        String signature = WeiXinQYService.sha1(this.qytoken, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new RuntimeException("signature verification error");
        }
        return this.decryptQY(echoStr);
    }

    protected String getQYAccessToken() throws IOException {
        if (this.qyAccessToken.accesstime < System.currentTimeMillis() - this.qyAccessToken.expires) {
            this.qyAccessToken.token = null;
        }
        if (this.qyAccessToken.token == null) {
            String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + this.qycorpid + "&corpsecret=" + this.qysecret;
            String json = Utility.getHttpContent((String)url);
            if (this.finest) {
                this.logger.finest(url + "--->" + json);
            }
            Map jsonmap = (Map)this.convert.convertFrom(MAPTYPE, json);
            this.qyAccessToken.accesstime = System.currentTimeMillis();
            this.qyAccessToken.token = (String)jsonmap.get("access_token");
            String exp = (String)jsonmap.get("expires_in");
            if (exp != null) {
                this.qyAccessToken.expires = (Integer.parseInt(exp) - 100) * 1000;
            }
        }
        return this.qyAccessToken.token;
    }

    protected String encryptQYMessage(String replyMsg, String timeStamp, String nonce) {
        String encrypt = this.encryptQY(WeiXinQYService.random16String(), replyMsg);
        if (timeStamp == null || timeStamp.isEmpty()) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String signature = WeiXinQYService.sha1(this.qytoken, timeStamp, nonce, encrypt);
        return "<xml>\n<Encrypt><![CDATA[" + encrypt + "]]></Encrypt>\n<MsgSignature><![CDATA[" + signature + "]]></MsgSignature>\n<TimeStamp>" + timeStamp + "</TimeStamp>\n<Nonce><![CDATA[" + nonce + "]]></Nonce>\n</xml>";
    }

    protected String decryptQYMessage(String msgSignature, String timeStamp, String nonce, String postData) {
        String encrypt = postData.substring(postData.indexOf("<Encrypt><![CDATA[") + "<Encrypt><![CDATA[".length(), postData.indexOf("]]></Encrypt>"));
        if (!WeiXinQYService.sha1(this.qytoken, timeStamp, nonce, encrypt).equals(msgSignature)) {
            throw new RuntimeException("signature verification error");
        }
        return this.decryptQY(encrypt);
    }

    protected String encryptQY(String randomStr, String text) {
        ByteArray bytes = new ByteArray();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] corpidBytes = this.qycorpid.getBytes(CHARSET);
        bytes.write(randomStrBytes);
        bytes.writeInt(textBytes.length);
        bytes.write(textBytes);
        bytes.write(corpidBytes);
        byte[] padBytes = WeiXinQYService.encodePKCS7(bytes.size());
        bytes.write(padBytes);
        try {
            byte[] encrypted = this.createQYCipher(1).doFinal(bytes.directBytes(), 0, bytes.size());
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    protected String decryptQY(String text) {
        byte[] original;
        try {
            original = this.createQYCipher(2).doFinal(Base64.getDecoder().decode(text));
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25", e);
        }
        try {
            byte[] bytes = WeiXinQYService.decodePKCS7(original);
            int xmlLength = (bytes[16] & 0xFF) << 24 | (bytes[17] & 0xFF) << 16 | (bytes[18] & 0xFF) << 8 | bytes[19] & 0xFF;
            if (!this.qycorpid.equals(new String(bytes, 20 + xmlLength, bytes.length - 20 - xmlLength, CHARSET))) {
                throw new RuntimeException("corpid\u6821\u9a8c\u5931\u8d25");
            }
            return new String(bytes, 20, xmlLength, CHARSET);
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("corpid")) {
                throw e;
            }
            throw new RuntimeException("\u89e3\u5bc6\u540e\u5f97\u5230\u7684buffer\u975e\u6cd5", e);
        }
    }

    protected Cipher createQYCipher(int mode) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        if (this.qykeyspec == null) {
            byte[] aeskeyBytes = Base64.getDecoder().decode(this.qyaeskey + "=");
            this.qykeyspec = new SecretKeySpec(aeskeyBytes, "AES");
            this.qyivspec = new IvParameterSpec(aeskeyBytes, 0, 16);
        }
        cipher.init(mode, (Key)this.qykeyspec, this.qyivspec);
        return cipher;
    }

    protected void runAsync(Runnable runner) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkThread) {
            ((WorkThread)thread).runAsync(runner);
            return;
        }
        runner.run();
    }

    protected static String random16String() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(BASE.charAt(RANDOM.nextInt(BASE.length())));
        }
        return sb.toString();
    }

    protected static String sha1(String ... strings) {
        try {
            Arrays.sort(strings);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String s : strings) {
                md.update(s.getBytes());
            }
            return Utility.binToHexString((byte[])md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException("SHA encryption to generate signature failure", e);
        }
    }

    private static byte[] encodePKCS7(int count) {
        int amountToPad = 32 - count % 32;
        if (amountToPad == 0) {
            amountToPad = 32;
        }
        char padChr = (char)(amountToPad & 0xFF);
        StringBuilder tmp = new StringBuilder();
        for (int index = 0; index < amountToPad; ++index) {
            tmp.append(padChr);
        }
        return tmp.toString().getBytes(CHARSET);
    }

    private static byte[] decodePKCS7(byte[] decrypted) {
        byte pad = decrypted[decrypted.length - 1];
        if (pad < 1 || pad > 32) {
            pad = 0;
        }
        return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
    }

    private static class Token {
        public String token;
        public long expires = 7100000L;
        public long accesstime;

        private Token() {
        }
    }
}

