/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.weixin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Local;
import org.redkale.service.RetResult;
import org.redkale.service.Service;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Utility;

@Local
@AutoLoad(value=false)
public class WeiXinMPService
implements Service {
    protected final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final boolean finest = this.logger.isLoggable(Level.FINEST);
    private final boolean finer = this.logger.isLoggable(Level.FINER);
    protected Map<String, MpElement> appidElements = new HashMap<String, MpElement>();
    protected Map<String, MpElement> clientidElements = new HashMap<String, MpElement>();
    @Resource
    protected JsonConvert convert;
    @Resource(name="property.weixin.mp.conf")
    protected String conf = "config.properties";
    @Resource(name="APP_HOME")
    protected File home;
    @Resource(name="property.weixin.mp.clientid")
    protected String clientid = "";
    @Resource(name="property.weixin.mp.appid")
    protected String appid = "";
    @Resource(name="property.weixin.mp.appsecret")
    protected String appsecret = "";
    @Resource(name="property.weixin.mp.token")
    protected String mptoken = "";

    public void init(AnyValue conf) {
        if (this.conf != null && !this.conf.isEmpty()) {
            try {
                FileInputStream in;
                File file = this.conf.indexOf(47) == 0 || this.conf.indexOf(58) > 0 ? new File(this.conf) : new File(this.home, "conf/" + this.conf);
                InputStream inputStream = in = file.isFile() && file.canRead() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.conf);
                if (in == null) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                this.appidElements = MpElement.create(this.logger, properties, this.home);
                MpElement defElement = this.appidElements.get("");
                if (defElement != null && (this.appid == null || this.appid.isEmpty())) {
                    this.clientid = defElement.clientid;
                    this.appid = defElement.appid;
                    this.appsecret = defElement.appsecret;
                    this.mptoken = defElement.mptoken;
                }
                this.appidElements.values().forEach(element -> this.clientidElements.put(element.clientid, (MpElement)element));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "init weixinmp conf error", e);
            }
        }
    }

    public RetResult<String> getMPOpenidByCode(String code) throws IOException {
        if (code != null) {
            code = code.replace("\"", "").replace("'", "");
        }
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + this.appid + "&secret=" + this.appsecret + "&code=" + code + "&grant_type=authorization_code";
        String json = Utility.getHttpContent((String)url);
        if (this.finest) {
            this.logger.finest(url + "--->" + json);
        }
        Map jsonmap = (Map)this.convert.convertFrom(JsonConvert.TYPE_MAP_STRING_STRING, json);
        return new RetResult(jsonmap.get("openid"));
    }

    public RetResult<String> getMPWxunionidByCode(String code) {
        try {
            Map<String, String> wxmap = this.getMPUserTokenByCode(code);
            String unionid = wxmap.get("unionid");
            if (unionid != null && !unionid.isEmpty()) {
                return new RetResult((Object)unionid);
            }
            return new RetResult(1011002);
        }
        catch (IOException e) {
            return new RetResult(1011001);
        }
    }

    public Map<String, String> getMPUserTokenByCode(String code) throws IOException {
        return this.getMPUserTokenByCode(this.appid, this.appsecret, code);
    }

    public Map<String, String> getMPUserTokenByCode(String clientid, String code) throws IOException {
        MpElement element = this.clientidElements.get(clientid);
        return this.getMPUserTokenByCode(element == null ? this.appid : element.appid, element == null ? this.appsecret : element.appsecret, code);
    }

    public Map<String, String> getMPUserTokenByCodeAndAppid(String appid, String code) throws IOException {
        MpElement element = this.appidElements.get(appid);
        return this.getMPUserTokenByCode(element == null ? appid : element.appid, element == null ? this.appsecret : element.appsecret, code);
    }

    private Map<String, String> getMPUserTokenByCode(String appid0, String appsecret0, String code) throws IOException {
        if (code != null) {
            code = code.replace("\"", "").replace("'", "");
        }
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid0 + "&secret=" + appsecret0 + "&code=" + code + "&grant_type=authorization_code";
        String json = Utility.getHttpContent((String)url);
        if (this.finest) {
            this.logger.finest(url + "--->" + json);
        }
        Map jsonmap = (Map)this.convert.convertFrom(JsonConvert.TYPE_MAP_STRING_STRING, json);
        return this.getMPUserTokenByOpenid((String)jsonmap.get("access_token"), (String)jsonmap.get("openid"));
    }

    public Map<String, String> getMPUserTokenByOpenid(String access_token, String openid) throws IOException {
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openid;
        String json = Utility.getHttpContent((String)url);
        if (this.finest) {
            this.logger.finest(url + "--->" + json);
        }
        Map jsonmap = (Map)this.convert.convertFrom(JsonConvert.TYPE_MAP_STRING_STRING, json.replaceFirst("\\[.*\\]", "null"));
        return jsonmap;
    }

    public String verifyMPURL(String msgSignature, String timeStamp, String nonce, String echoStr) {
        return this.verifyMPURL0(this.mptoken, msgSignature, timeStamp, nonce, echoStr);
    }

    public String verifyMPURL(String clientid, String msgSignature, String timeStamp, String nonce, String echoStr) {
        MpElement element = this.clientidElements.get(clientid);
        return this.verifyMPURL0(element == null ? this.mptoken : element.mptoken, msgSignature, timeStamp, nonce, echoStr);
    }

    public String verifyMPURLByAppid(String appid, String msgSignature, String timeStamp, String nonce, String echoStr) {
        MpElement element = this.appidElements.get(appid);
        return this.verifyMPURL0(element == null ? this.mptoken : element.mptoken, msgSignature, timeStamp, nonce, echoStr);
    }

    private String verifyMPURL0(String mptoken, String msgSignature, String timeStamp, String nonce, String echoStr) {
        String signature = WeiXinMPService.sha1(mptoken, timeStamp, nonce);
        if (!signature.equals(msgSignature)) {
            throw new RuntimeException("signature verification error");
        }
        return echoStr;
    }

    protected static String sha1(String ... strings) {
        try {
            Arrays.sort(strings);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String s : strings) {
                md.update(s.getBytes());
            }
            return Utility.binToHexString((byte[])md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException("SHA encryption to generate signature failure", e);
        }
    }

    public static class MpElement {
        public String clientid = "";
        public String appid = "";
        public String appsecret = "";
        public String mptoken = "";

        public static Map<String, MpElement> create(Logger logger, Properties properties, File home) {
            String def_clientid = properties.getProperty("weixin.mp.clientid", "").trim();
            String def_appid = properties.getProperty("weixin.mp.appid", "").trim();
            String def_appsecret = properties.getProperty("weixin.mp.appsecret", "").trim();
            String def_mptoken = properties.getProperty("weixin.mp.mptoken", "").trim();
            HashMap<String, MpElement> map = new HashMap<String, MpElement>();
            properties.keySet().stream().filter(x -> x.toString().startsWith("weixin.mp.") && x.toString().endsWith(".appid")).forEach(appid_key -> {
                String prefix = appid_key.toString().substring(0, appid_key.toString().length() - ".appid".length());
                String clientid = properties.getProperty(prefix + ".clientid", def_clientid).trim();
                String appid = properties.getProperty(prefix + ".appid", def_appid).trim();
                String appsecret = properties.getProperty(prefix + ".appsecret", def_appsecret).trim();
                String mptoken = properties.getProperty(prefix + ".mptoken", def_mptoken).trim();
                if (appid.isEmpty() || appsecret.isEmpty()) {
                    logger.log(Level.WARNING, properties + "; has illegal weixinmp conf by prefix" + prefix);
                    return;
                }
                MpElement element = new MpElement();
                element.clientid = clientid;
                element.appid = appid;
                element.appsecret = appsecret;
                element.mptoken = mptoken;
                map.put(appid, element);
                if (def_appid.equals(appid)) {
                    map.put("", element);
                }
            });
            return map;
        }

        public String toString() {
            return JsonConvert.root().convertTo((Object)this);
        }
    }
}

