/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.pgsql;

import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.redkale.net.AsyncConnection;
import org.redkale.service.Local;
import org.redkale.source.ColumnNode;
import org.redkale.source.DataSource;
import org.redkale.source.DataSqlSource;
import org.redkale.source.EntityInfo;
import org.redkale.source.FilterFuncColumn;
import org.redkale.source.FilterNode;
import org.redkale.source.Flipper;
import org.redkale.source.PoolSource;
import org.redkale.util.Attribute;
import org.redkale.util.AutoLoad;
import org.redkale.util.ByteArray;
import org.redkale.util.ByteBufferReader;
import org.redkale.util.ByteBufferWriter;
import org.redkale.util.ObjectPool;
import org.redkale.util.ResourceType;
import org.redkale.util.SelectColumn;
import org.redkale.util.Sheet;
import org.redkalex.source.pgsql.PgPoolSource;
import org.redkalex.source.pgsql.PgRespRowDataDecoder;
import org.redkalex.source.pgsql.PgRespRowDescDecoder;
import org.redkalex.source.pgsql.PgResultSet;
import org.redkalex.source.pgsql.PgRowData;
import org.redkalex.source.pgsql.PgRowDesc;

@Local
@AutoLoad(value=false)
@ResourceType(value=DataSource.class)
public class PgsqlLDataSource
extends DataSqlSource<AsyncConnection> {
    private static final byte[] TRUE = new byte[]{116};
    private static final byte[] FALSE = new byte[]{102};
    static final DateTimeFormatter TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    static final DateTimeFormatter TIMESTAMPZ_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "").toFormatter();
    static final DateTimeFormatter TIMEZ_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "").toFormatter();

    public PgsqlLDataSource(String unitName, URL persistxml, Properties readprop, Properties writeprop) {
        super(unitName, persistxml, readprop, writeprop);
    }

    @Local
    protected PoolSource<AsyncConnection> readPoolSource() {
        return this.readPool;
    }

    @Local
    protected PoolSource<AsyncConnection> writePoolSource() {
        return this.writePool;
    }

    protected static String readUTF8String(ByteBuffer buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            c = buffer.get();
        }
        return array == null ? new String(store, 0, i, StandardCharsets.UTF_8) : array.toString(StandardCharsets.UTF_8);
    }

    protected static String readUTF8String(ByteBufferReader buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            c = buffer.get();
        }
        return array == null ? new String(store, 0, i, StandardCharsets.UTF_8) : array.toString(StandardCharsets.UTF_8);
    }

    protected static ByteBuffer writeUTF8String(ByteBuffer buffer, String string) {
        buffer.put(string.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)0);
        return buffer;
    }

    protected static ByteBufferWriter writeUTF8String(ByteBufferWriter buffer, String string) {
        buffer.put(string.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)0);
        return buffer;
    }

    protected String prepareParamSign(int index) {
        return "$" + index;
    }

    protected final boolean isAsync() {
        return true;
    }

    protected PoolSource<AsyncConnection> createPoolSource(DataSource source, String rwtype, ArrayBlockingQueue queue, Semaphore semaphore, Properties prop) {
        return new PgPoolSource(rwtype, queue, semaphore, prop, this.logger, (ObjectPool<ByteBuffer>)this.bufferPool, this.executor);
    }

    protected <T> CompletableFuture<Integer> insertDB(EntityInfo<T> info, T ... values) {
        String sql0;
        Attribute[] attrs = info.getInsertAttributes();
        Object[][] objs = new Object[values.length][];
        for (int i = 0; i < values.length; ++i) {
            Object[] params = new Object[attrs.length];
            for (int j = 0; j < attrs.length; ++j) {
                params[j] = attrs[j].get(values[i]);
            }
            objs[i] = params;
        }
        String sql = sql0 = info.getInsertDollarPrepareSQL(values[0]);
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, sql, values, 0, true, (Attribute<T, Serializable>[])attrs, objs));
    }

    protected <T> CompletableFuture<Integer> deleteDB(EntityInfo<T> info, Flipper flipper, String sql) {
        if (info.isLoggable(this.logger, Level.FINEST)) {
            String debugsql;
            String string = debugsql = flipper == null || flipper.getLimit() <= 0 ? sql : sql + " LIMIT " + flipper.getLimit();
            if (info.isLoggable(this.logger, Level.FINEST, debugsql)) {
                this.logger.finest(info.getType().getSimpleName() + " delete sql=" + debugsql);
            }
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, sql, null, PgsqlLDataSource.fetchSize(flipper), false, null, new Object[0][]));
    }

    protected <T> CompletableFuture<Integer> clearTableDB(EntityInfo<T> info, String table, String sql) {
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, sql)) {
            this.logger.finest(info.getType().getSimpleName() + " clearTable sql=" + sql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, sql, null, 0, false, null, new Object[0][]));
    }

    protected <T> CompletableFuture<Integer> dropTableDB(EntityInfo<T> info, String table, String sql) {
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, sql)) {
            this.logger.finest(info.getType().getSimpleName() + " dropTable sql=" + sql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, sql, null, 0, false, null, new Object[0][]));
    }

    protected <T> CompletableFuture<Integer> updateDB(EntityInfo<T> info, T ... values) {
        Attribute primary = info.getPrimary();
        Attribute[] attrs = info.getUpdateAttributes();
        Object[][] objs = new Object[values.length][];
        for (int i = 0; i < values.length; ++i) {
            Object[] params = new Object[attrs.length + 1];
            for (int j = 0; j < attrs.length; ++j) {
                params[j] = attrs[j].get(values[i]);
            }
            params[attrs.length] = primary.get(values[i]);
            objs[i] = params;
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, info.getUpdateDollarPrepareSQL(values[0]), null, 0, false, (Attribute<T, Serializable>[])attrs, objs));
    }

    protected <T> CompletableFuture<Integer> updateDB(EntityInfo<T> info, Flipper flipper, String sql, boolean prepared, Object ... params) {
        Object[][] objectArray;
        if (info.isLoggable(this.logger, Level.FINEST)) {
            String debugsql;
            String string = debugsql = flipper == null || flipper.getLimit() <= 0 ? sql : sql + " LIMIT " + flipper.getLimit();
            if (info.isLoggable(this.logger, Level.FINEST, debugsql)) {
                this.logger.finest(info.getType().getSimpleName() + " update sql=" + debugsql);
            }
        }
        if (params == null || params.length == 0) {
            objectArray = null;
        } else {
            Object[][] objectArrayArray = new Object[1][];
            objectArray = objectArrayArray;
            objectArrayArray[0] = params;
        }
        Object[][] objs = objectArray;
        return this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(info, (AsyncConnection)conn, sql, null, PgsqlLDataSource.fetchSize(flipper), false, null, objs));
    }

    protected <T, N extends Number> CompletableFuture<Map<String, N>> getNumberMapDB(EntityInfo<T> info, String sql, FilterFuncColumn ... columns) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            HashMap<String, Number> map = new HashMap<String, Number>();
            try {
                if (set.next()) {
                    int index = 0;
                    for (FilterFuncColumn ffc : columns) {
                        for (String col : ffc.cols()) {
                            Object o = set.getObject(++index);
                            Number rs = ffc.getDefvalue();
                            if (o != null) {
                                rs = (Number)o;
                            }
                            map.put(ffc.col(col), rs);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return map;
        }));
    }

    protected <T> CompletableFuture<Number> getNumberResultDB(EntityInfo<T> info, String sql, Number defVal, String column) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            Number rs = defVal;
            try {
                Object o;
                if (set.next() && (o = set.getObject(1)) != null) {
                    rs = (Number)o;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T, K extends Serializable, N extends Number> CompletableFuture<Map<K, N>> queryColumnMapDB(EntityInfo<T> info, String sql, String keyColumn) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            LinkedHashMap<Serializable, Number> rs = new LinkedHashMap<Serializable, Number>();
            try {
                while (set.next()) {
                    rs.put((Serializable)set.getObject(1), (Number)set.getObject(2));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T, K extends Serializable, N extends Number> CompletableFuture<Map<K[], N[]>> queryColumnMapDB(EntityInfo<T> info, String sql, ColumnNode[] funcNodes, String[] groupByColumns) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            LinkedHashMap<Serializable[], Number[]> rs = new LinkedHashMap<Serializable[], Number[]>();
            try {
                while (set.next()) {
                    int index = 0;
                    Serializable[] keys = new Serializable[groupByColumns.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = (Serializable)set.getObject(++index);
                    }
                    Number[] vals = new Number[funcNodes.length];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = (Number)set.getObject(++index);
                    }
                    rs.put(keys, vals);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T> CompletableFuture<T> findDB(EntityInfo<T> info, String sql, boolean onlypk, SelectColumn selects) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            Object rs = null;
            try {
                rs = set.next() ? this.getEntityValue(info, selects, (ResultSet)set) : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T> CompletableFuture<Serializable> findColumnDB(EntityInfo<T> info, String sql, boolean onlypk, String column, Serializable defValue) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            Serializable val = defValue;
            try {
                if (set.next()) {
                    Attribute attr = info.getAttribute(column);
                    val = this.getFieldValue(info, attr, (ResultSet)set, 1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return val == null ? defValue : val;
        }));
    }

    protected <T> CompletableFuture<Boolean> existsDB(EntityInfo<T> info, String sql, boolean onlypk) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            try {
                boolean rs = set.next() ? set.getInt(1) > 0 : false;
                return rs;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    protected <T> CompletableFuture<Sheet<T>> querySheetDB(EntityInfo<T> info, boolean readcache, boolean needtotal, boolean distinct, SelectColumn selects, Flipper flipper, FilterNode node) {
        SelectColumn sels = selects;
        Map joinTabalis = node == null ? null : this.getJoinTabalis(node);
        CharSequence join = node == null ? null : this.createSQLJoin(node, (Function)((Object)this), false, joinTabalis, new HashSet(), info);
        CharSequence where = node == null ? null : this.createSQLExpress(node, info, joinTabalis);
        String listsql = "SELECT " + (distinct ? "DISTINCT " : "") + info.getQueryColumns("a", selects) + " FROM " + info.getTable(node) + " a" + (join == null ? "" : join) + (where == null || where.length() == 0 ? "" : " WHERE " + where) + this.createSQLOrderby(info, flipper) + (flipper == null || flipper.getLimit() < 1 ? "" : " LIMIT " + flipper.getLimit() + " OFFSET " + flipper.getOffset());
        if (readcache && info.isLoggable(this.logger, Level.FINEST, listsql)) {
            this.logger.finest(info.getType().getSimpleName() + " query sql=" + listsql);
        }
        if (!needtotal) {
            return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, listsql).thenApply(set -> {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (set.next()) {
                        list.add(this.getEntityValue(info, sels, (ResultSet)set));
                    }
                    return Sheet.asSheet(list);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        String countsql = "SELECT " + (distinct ? "DISTINCT COUNT(" + info.getQueryColumns("a", selects) + ")" : "COUNT(*)") + " FROM " + info.getTable(node) + " a" + (join == null ? "" : join) + (where == null || where.length() == 0 ? "" : " WHERE " + where);
        return this.getNumberResultDB(info, countsql, 0, countsql).thenCompose(total -> {
            if (total.longValue() <= 0L) {
                return CompletableFuture.completedFuture(new Sheet(0, new ArrayList()));
            }
            return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, listsql).thenApply(set -> {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (set.next()) {
                        list.add(this.getEntityValue(info, sels, (ResultSet)set));
                    }
                    return new Sheet(total.longValue(), list);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        });
    }

    protected static int fetchSize(Flipper flipper) {
        return flipper == null || flipper.getLimit() <= 0 ? 0 : flipper.getLimit();
    }

    protected static <T> byte[] formatPrepareParam(EntityInfo<T> info, Attribute<T, Serializable> attr, Object param) {
        if (param == null && info.isNotNullJson(attr)) {
            return new byte[0];
        }
        if (param == null) {
            return null;
        }
        if (param instanceof byte[]) {
            return (byte[])param;
        }
        if (param instanceof Boolean) {
            return (Boolean)param != false ? TRUE : FALSE;
        }
        if (param instanceof Date) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format(((Date)param).toLocalDate()).getBytes(StandardCharsets.UTF_8);
        }
        if (param instanceof Time) {
            return DateTimeFormatter.ISO_LOCAL_TIME.format(((Time)param).toLocalTime()).getBytes(StandardCharsets.UTF_8);
        }
        if (param instanceof Timestamp) {
            return TIMESTAMP_FORMAT.format(((Timestamp)param).toLocalDateTime()).getBytes(StandardCharsets.UTF_8);
        }
        if (!(param instanceof Number || param instanceof CharSequence || param instanceof java.util.Date || param.getClass().getName().startsWith("java.sql.") || param.getClass().getName().startsWith("java.time."))) {
            if (attr == null) {
                return info.getJsonConvert().convertTo(param).getBytes(StandardCharsets.UTF_8);
            }
            return info.getJsonConvert().convertTo(attr.genericType(), param).getBytes(StandardCharsets.UTF_8);
        }
        return String.valueOf(param).getBytes(StandardCharsets.UTF_8);
    }

    protected <T> CompletableFuture<Integer> executeUpdate(final EntityInfo<T> info, final AsyncConnection conn, final String sql, final T[] values, int fetchSize, final boolean insert, Attribute<T, Serializable>[] attrs, Object[] ... parameters) {
        final byte[] bytes = (byte[])conn.getAttribute("BYTESBAME");
        ByteBufferWriter writer = ByteBufferWriter.create((Supplier)this.bufferPool);
        writer.put((byte)80);
        int start = writer.position();
        writer.putInt(0);
        writer.put((byte)0);
        PgsqlLDataSource.writeUTF8String(writer, sql);
        writer.putShort((short)0);
        writer.putInt(start, writer.position() - start);
        writer.put((byte)68);
        writer.putInt(6);
        writer.put((byte)83);
        writer.put((byte)0);
        if (parameters != null && parameters.length > 0) {
            for (Object[] params : parameters) {
                writer.put((byte)66);
                int start2 = writer.position();
                writer.putInt(0);
                writer.put((byte)0);
                writer.put((byte)0);
                writer.putShort((short)0);
                if (params == null || params.length == 0) {
                    writer.putShort((short)0);
                } else {
                    writer.putShort((short)params.length);
                    int i = -1;
                    Object[] objectArray = params;
                    int n = objectArray.length;
                    for (int j = 0; j < n; ++j) {
                        Object param;
                        byte[] bs = PgsqlLDataSource.formatPrepareParam(info, attrs == null ? null : attrs[++i], param = objectArray[j]);
                        if (bs == null) {
                            writer.putInt(-1);
                            continue;
                        }
                        writer.putInt(bs.length);
                        writer.put(bs);
                    }
                }
                writer.putShort((short)0);
                writer.putInt(start2, writer.position() - start2);
                writer.put((byte)69);
                writer.putInt(9);
                writer.put((byte)0);
                writer.putInt(fetchSize);
            }
        } else {
            writer.put((byte)66);
            start = writer.position();
            writer.putInt(0);
            writer.put((byte)0);
            writer.put((byte)0);
            writer.putShort((short)0);
            writer.putShort((short)0);
            writer.putShort((short)0);
            writer.putInt(start, writer.position() - start);
            writer.put((byte)69);
            writer.putInt(9);
            writer.put((byte)0);
            writer.putInt(fetchSize);
        }
        writer.put((byte)83);
        writer.putInt(4);
        ByteBuffer[] buffers = writer.toBuffers();
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        conn.write(buffers, (Object)buffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

            @Override
            public void completed(Integer result, ByteBuffer[] attachment1) {
                if (result < 0) {
                    this.failed((Throwable)new SQLException("Write Buffer Error"), attachment1);
                    return;
                }
                int index = -1;
                for (int i = 0; i < attachment1.length; ++i) {
                    if (attachment1[i].hasRemaining()) {
                        index = i;
                        break;
                    }
                    PgsqlLDataSource.this.bufferPool.accept((Object)attachment1[i]);
                }
                if (index == 0) {
                    conn.write(attachment1, (Object)attachment1, (CompletionHandler)this);
                    return;
                }
                if (index > 0) {
                    ByteBuffer[] newattachs = new ByteBuffer[attachment1.length - index];
                    System.arraycopy(attachment1, index, newattachs, 0, newattachs.length);
                    conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                    return;
                }
                final ArrayList readBuffs = new ArrayList();
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment2) {
                        if (result < 0) {
                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment2);
                            return;
                        }
                        if (result == 8192 || !attachment2.hasRemaining()) {
                            attachment2.flip();
                            readBuffs.add(attachment2);
                            conn.read((CompletionHandler)this);
                            return;
                        }
                        attachment2.flip();
                        readBuffs.add(attachment2);
                        ByteBufferReader buffer = ByteBufferReader.create((Collection)readBuffs);
                        boolean endok = false;
                        boolean futureover = false;
                        boolean success = false;
                        PgRowDesc rowDesc = null;
                        int count = 0;
                        int valueIndex = -1;
                        block6: while (buffer.hasRemaining()) {
                            char cmd = (char)buffer.get();
                            int length = buffer.getInt();
                            switch (cmd) {
                                case 'C': {
                                    String val = PgsqlLDataSource.readUTF8String(buffer, bytes);
                                    int pos = val.lastIndexOf(32);
                                    if (pos <= 0) continue block6;
                                    count += Integer.parseInt(val.substring(pos + 1));
                                    success = true;
                                    futureover = true;
                                    continue block6;
                                }
                                case 'T': {
                                    rowDesc = new PgRespRowDescDecoder().read(buffer, length, bytes);
                                    continue block6;
                                }
                                case 'D': {
                                    Attribute primary = info.getPrimary();
                                    PgRowData rowData = new PgRespRowDataDecoder().read(buffer, length, bytes);
                                    if (!insert || rowData.length() <= 0) continue block6;
                                    primary.set(values[++valueIndex], (Object)rowData.getObject(rowDesc, 0));
                                    continue block6;
                                }
                                case 'Z': {
                                    buffer.skip(length - 4);
                                    endok = true;
                                    continue block6;
                                }
                            }
                            buffer.skip(length - 4);
                        }
                        if (success) {
                            future.complete(count);
                        }
                        for (ByteBuffer buf : readBuffs) {
                            PgsqlLDataSource.this.bufferPool.accept((Object)buf);
                        }
                        if (!futureover) {
                            future.completeExceptionally(new SQLException("SQL(" + sql + ") executeUpdate error"));
                        }
                        if (endok) {
                            PgsqlLDataSource.this.writePool.offerConnection((Object)conn);
                        } else {
                            conn.dispose();
                        }
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment2) {
                        conn.offerBuffer(attachment2);
                        future.completeExceptionally(exc);
                        conn.dispose();
                    }
                });
            }

            @Override
            public void failed(Throwable exc, ByteBuffer[] attachment1) {
                for (ByteBuffer attach : attachment1) {
                    PgsqlLDataSource.this.bufferPool.accept((Object)attach);
                }
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    protected <T> CompletableFuture<ResultSet> executeQuery(EntityInfo<T> info, final AsyncConnection conn, final String sql) {
        final byte[] bytes = (byte[])conn.getAttribute("BYTESBAME");
        ByteBufferWriter writer = ByteBufferWriter.create((Supplier)this.bufferPool);
        writer.put((byte)81);
        int start = writer.position();
        writer.putInt(0);
        PgsqlLDataSource.writeUTF8String(writer, sql);
        writer.putInt(start, writer.position() - start);
        ByteBuffer[] buffers = writer.toBuffers();
        final CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        conn.write(buffers, (Object)buffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

            @Override
            public void completed(Integer result, ByteBuffer[] attachment1) {
                if (result < 0) {
                    this.failed((Throwable)new SQLException("Write Buffer Error"), attachment1);
                    return;
                }
                int index = -1;
                for (int i = 0; i < attachment1.length; ++i) {
                    if (attachment1[i].hasRemaining()) {
                        index = i;
                        break;
                    }
                    PgsqlLDataSource.this.bufferPool.accept((Object)attachment1[i]);
                }
                if (index == 0) {
                    conn.write(attachment1, (Object)attachment1, (CompletionHandler)this);
                    return;
                }
                if (index > 0) {
                    ByteBuffer[] newattachs = new ByteBuffer[attachment1.length - index];
                    System.arraycopy(attachment1, index, newattachs, 0, newattachs.length);
                    conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                    return;
                }
                final PgResultSet resultSet = new PgResultSet();
                final ArrayList readBuffs = new ArrayList();
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment2) {
                        if (result < 0) {
                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment2);
                            return;
                        }
                        if (result == 8192 || !attachment2.hasRemaining()) {
                            attachment2.flip();
                            readBuffs.add(attachment2);
                            conn.read((CompletionHandler)this);
                            return;
                        }
                        attachment2.flip();
                        readBuffs.add(attachment2);
                        ByteBufferReader buffer = ByteBufferReader.create((Collection)readBuffs);
                        boolean endok = false;
                        boolean futureover = false;
                        block5: while (buffer.hasRemaining()) {
                            char cmd = (char)buffer.get();
                            int length = buffer.getInt();
                            switch (cmd) {
                                case 'T': {
                                    PgRowDesc rowDesc = new PgRespRowDescDecoder().read(buffer, length, bytes);
                                    resultSet.setRowDesc(rowDesc);
                                    continue block5;
                                }
                                case 'D': {
                                    PgRowData rowData = new PgRespRowDataDecoder().read(buffer, length, bytes);
                                    resultSet.addRowData(rowData);
                                    futureover = true;
                                    continue block5;
                                }
                                case 'Z': {
                                    buffer.skip(length - 4);
                                    endok = true;
                                    continue block5;
                                }
                            }
                            buffer.skip(length - 4);
                        }
                        for (ByteBuffer buf : readBuffs) {
                            PgsqlLDataSource.this.bufferPool.accept((Object)buf);
                        }
                        if (!futureover) {
                            future.completeExceptionally(new SQLException("SQL(" + sql + ") executeQuery error"));
                        }
                        if (endok) {
                            PgsqlLDataSource.this.readPool.offerConnection((Object)conn);
                            future.complete(resultSet);
                        } else {
                            conn.dispose();
                        }
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment2) {
                        future.completeExceptionally(exc);
                        conn.dispose();
                    }
                });
            }

            @Override
            public void failed(Throwable exc, ByteBuffer[] attachment1) {
                for (ByteBuffer attach : attachment1) {
                    PgsqlLDataSource.this.bufferPool.accept((Object)attach);
                }
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    @Local
    public int directExecute(String sql) {
        return (Integer)((CompletableFuture)this.writePool.pollAsync().thenCompose(conn -> this.executeUpdate(null, (AsyncConnection)conn, sql, null, 0, false, null, new Object[0][]))).join();
    }

    @Local
    public int[] directExecute(String ... sqls) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Local
    public <V> V directQuery(String sql, Function<ResultSet, V> handler) {
        return (V)((CompletableFuture)this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(null, (AsyncConnection)conn, sql).thenApply(set -> handler.apply((ResultSet)set)))).join();
    }
}

