/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.pgsql;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.redkale.net.AsyncConnection;
import org.redkale.source.PoolTcpSource;
import org.redkale.util.ObjectPool;
import org.redkale.util.Utility;
import org.redkalex.source.pgsql.PgsqlLDataSource;

public class PgPoolSource
extends PoolTcpSource {
    protected static final String CONN_ATTR_BYTES_NAME = "BYTESBAME";

    public PgPoolSource(String rwtype, ArrayBlockingQueue queue, Semaphore semaphore, Properties prop, Logger logger, ObjectPool<ByteBuffer> bufferPool, ThreadPoolExecutor executor) {
        super(rwtype, queue, semaphore, prop, logger, bufferPool, executor);
    }

    protected ByteBuffer reqConnectBuffer(AsyncConnection conn) {
        if (conn.getAttribute(CONN_ATTR_BYTES_NAME) == null) {
            conn.setAttribute(CONN_ATTR_BYTES_NAME, (Object)new byte[255]);
        }
        ByteBuffer buffer = (ByteBuffer)this.bufferPool.get();
        buffer.putInt(0);
        buffer.putInt(196608);
        PgsqlLDataSource.writeUTF8String(PgsqlLDataSource.writeUTF8String(buffer, "user"), this.username);
        PgsqlLDataSource.writeUTF8String(PgsqlLDataSource.writeUTF8String(buffer, "database"), this.database);
        PgsqlLDataSource.writeUTF8String(PgsqlLDataSource.writeUTF8String(buffer, "client_encoding"), "UTF8");
        buffer.put((byte)0);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        return buffer;
    }

    protected void respConnectBuffer(final ByteBuffer buffer, final CompletableFuture<AsyncConnection> future, final AsyncConnection conn) {
        char cmd = (char)buffer.get();
        int length = buffer.getInt();
        if (cmd == 'R') {
            int type = buffer.getInt();
            if (type != 0) {
                if (type == 3 || type == 5) {
                    byte[] salt = null;
                    if (type == 5) {
                        salt = new byte[4];
                        buffer.get(salt);
                    }
                    buffer.clear();
                    buffer.put((byte)112);
                    buffer.putInt(0);
                    if (salt == null) {
                        buffer.put(this.password.getBytes(StandardCharsets.UTF_8));
                    } else {
                        MessageDigest md5;
                        try {
                            md5 = MessageDigest.getInstance("MD5");
                        }
                        catch (NoSuchAlgorithmException e) {
                            this.bufferPool.accept((Object)buffer);
                            future.completeExceptionally(e);
                            return;
                        }
                        md5.update(this.password.getBytes(StandardCharsets.UTF_8));
                        md5.update(this.username.getBytes(StandardCharsets.UTF_8));
                        md5.update(Utility.binToHexString((byte[])md5.digest()).getBytes(StandardCharsets.UTF_8));
                        md5.update(salt);
                        buffer.put((byte)109);
                        buffer.put((byte)100);
                        buffer.put((byte)53);
                        buffer.put(Utility.binToHexString((byte[])md5.digest()).getBytes(StandardCharsets.UTF_8));
                    }
                    buffer.put((byte)0);
                    buffer.putInt(1, buffer.position() - 1);
                    buffer.flip();
                    conn.write(buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                        @Override
                        public void completed(Integer result, Void attachment1) {
                            if (result < 0) {
                                this.failed((Throwable)new RuntimeException("Write Buffer Error"), attachment1);
                                return;
                            }
                            if (buffer.hasRemaining()) {
                                conn.write(buffer, (Object)attachment1, (CompletionHandler)this);
                                return;
                            }
                            buffer.clear();
                            conn.setReadBuffer(buffer);
                            conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                                @Override
                                public void completed(Integer result, ByteBuffer attachment2) {
                                    if (result < 0) {
                                        this.failed((Throwable)new RuntimeException("Read Buffer Error"), attachment2);
                                        return;
                                    }
                                    attachment2.flip();
                                    PgPoolSource.this.respConnectBuffer(attachment2, future, conn);
                                }

                                @Override
                                public void failed(Throwable exc, ByteBuffer attachment2) {
                                    conn.offerBuffer(attachment2);
                                    future.completeExceptionally(exc);
                                    conn.dispose();
                                }
                            });
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment1) {
                            PgPoolSource.this.bufferPool.accept((Object)buffer);
                            future.completeExceptionally(exc);
                            conn.dispose();
                        }
                    });
                    return;
                }
                this.bufferPool.accept((Object)buffer);
                future.completeExceptionally(new SQLException("postgres connect error"));
                conn.dispose();
                return;
            }
            cmd = (char)buffer.get();
            length = buffer.getInt();
        }
        while (cmd != 'E' && cmd != 'Z') {
            buffer.position(buffer.position() + length - 4);
            cmd = (char)buffer.get();
            length = buffer.getInt();
        }
        if (cmd == 'E') {
            byte[] field = new byte[255];
            String level = null;
            String code = null;
            String message = null;
            byte type = buffer.get();
            while (type != 0) {
                String value = PgsqlLDataSource.readUTF8String(buffer, field);
                if (type == 83) {
                    level = value;
                } else if (type == 67) {
                    code = value;
                } else if (type == 77) {
                    message = value;
                }
                type = buffer.get();
            }
            this.bufferPool.accept((Object)buffer);
            future.completeExceptionally(new SQLException(message, code, 0));
            conn.dispose();
            return;
        }
        if (cmd == 'Z') {
            this.bufferPool.accept((Object)buffer);
            future.complete(conn);
            return;
        }
        this.bufferPool.accept((Object)buffer);
        future.completeExceptionally(new SQLException("postgres connect resp error"));
        conn.dispose();
    }

    protected int getDefaultPort() {
        return 5432;
    }

    protected CompletableFuture<AsyncConnection> sendPingCommand(AsyncConnection conn) {
        return null;
    }

    protected CompletableFuture<AsyncConnection> sendCloseCommand(AsyncConnection conn) {
        return null;
    }
}

