/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.pgsql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.UUID;
import org.redkale.convert.json.JsonConvert;
import org.redkale.util.Utility;
import org.redkalex.source.pgsql.PgOid;
import org.redkalex.source.pgsql.PgsqlLDataSource;

public class PgColumnDesc {
    final String name;
    final PgOid type;

    public PgColumnDesc(String name, PgOid type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public PgOid getType() {
        return this.type;
    }

    public Serializable getObject(byte[] value) {
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case TEXT: 
            case CHAR: 
            case BPCHAR: 
            case VARCHAR: {
                return new String(value, StandardCharsets.UTF_8);
            }
            case INT2: {
                return Short.valueOf(new String(value, StandardCharsets.UTF_8));
            }
            case INT4: {
                return Integer.valueOf(new String(value, StandardCharsets.UTF_8));
            }
            case INT8: {
                return Long.valueOf(new String(value, StandardCharsets.UTF_8));
            }
            case FLOAT4: {
                return Float.valueOf(new String(value, StandardCharsets.UTF_8));
            }
            case NUMERIC: 
            case FLOAT8: {
                return new BigDecimal(new String(value, StandardCharsets.UTF_8));
            }
            case BIT: {
                return Byte.valueOf(Utility.hexToBin((String)new String(value, 2, value.length - 2, StandardCharsets.UTF_8))[0]);
            }
            case BIT_ARRAY: 
            case BYTEA: {
                return Utility.hexToBin((String)new String(value, 2, value.length - 2, StandardCharsets.UTF_8));
            }
            case DATE: {
                String date = new String(value, StandardCharsets.UTF_8);
                try {
                    return Date.valueOf(LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE));
                }
                catch (DateTimeParseException e) {
                    throw new RuntimeException("Invalid date: " + date);
                }
            }
            case TIMETZ: {
                return Time.valueOf(OffsetTime.parse(new String(value, StandardCharsets.UTF_8), PgsqlLDataSource.TIMEZ_FORMAT).toLocalTime());
            }
            case TIME: {
                return Time.valueOf(LocalTime.parse(new String(value, StandardCharsets.UTF_8), DateTimeFormatter.ISO_LOCAL_TIME));
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(LocalDateTime.parse(new String(value, StandardCharsets.UTF_8), PgsqlLDataSource.TIMESTAMP_FORMAT));
            }
            case TIMESTAMPTZ: {
                return Timestamp.valueOf(OffsetDateTime.parse(new String(value, StandardCharsets.UTF_8), PgsqlLDataSource.TIMESTAMPZ_FORMAT).toLocalDateTime());
            }
            case UUID: {
                return UUID.fromString(new String(value, StandardCharsets.UTF_8));
            }
            case BOOL: {
                return Boolean.valueOf(116 == value[0]);
            }
            case INT2_ARRAY: 
            case INT4_ARRAY: 
            case INT8_ARRAY: 
            case FLOAT4_ARRAY: 
            case FLOAT8_ARRAY: 
            case TEXT_ARRAY: 
            case CHAR_ARRAY: 
            case BPCHAR_ARRAY: 
            case VARCHAR_ARRAY: 
            case TIMESTAMP_ARRAY: 
            case TIMESTAMPTZ_ARRAY: 
            case TIMETZ_ARRAY: 
            case TIME_ARRAY: 
            case BOOL_ARRAY: {
                throw new IllegalStateException("Unsupported array type: " + (Object)((Object)this.type));
            }
        }
        throw new IllegalStateException("Unsupported array type: " + (Object)((Object)this.type));
    }

    public String toString() {
        return JsonConvert.root().convertTo((Object)this);
    }
}

