/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.redkale.util.ByteArray;
import org.redkale.util.ByteBufferReader;
import org.redkale.util.ByteBufferWriter;

class Mysqls {
    public static final int MAX_PACKET_SIZE = 0xFFFFFF;
    static final String CODE_PAGE_1252 = "Cp1252";
    static final int NULL_LENGTH = -1;
    static final int COMP_HEADER_LENGTH = 3;
    static final int MIN_COMPRESS_LEN = 50;
    static final int HEADER_LENGTH = 4;
    static final int AUTH_411_OVERHEAD = 33;
    static final int SEED_LENGTH = 20;
    static int maxBufferSize = 65535;
    static final int SERVER_STATUS_IN_TRANS = 1;
    static final int SERVER_STATUS_AUTOCOMMIT = 2;
    static final int SERVER_MORE_RESULTS_EXISTS = 8;
    static final int SERVER_QUERY_NO_GOOD_INDEX_USED = 16;
    static final int SERVER_QUERY_NO_INDEX_USED = 32;
    static final int SERVER_STATUS_CURSOR_EXISTS = 64;
    static final int SERVER_STATUS_LAST_ROW_SENT = 128;
    static final int SERVER_QUERY_WAS_SLOW = 2048;
    static final int CLIENT_LONG_PASSWORD = 1;
    static final int CLIENT_FOUND_ROWS = 2;
    static final int CLIENT_LONG_FLAG = 4;
    static final int CLIENT_CONNECT_WITH_DB = 8;
    static final int CLIENT_NO_SCHEMA = 16;
    static final int CLIENT_COMPRESS = 32;
    static final int CLIENT_ODBC = 64;
    static final int CLIENT_LOCAL_FILES = 128;
    static final int CLIENT_IGNORE_SPACE = 256;
    static final int CLIENT_PROTOCOL_41 = 512;
    static final int CLIENT_INTERACTIVE = 1024;
    static final int CLIENT_SSL = 2048;
    static final int CLIENT_IGNORE_SIGPIPE = 4096;
    static final int CLIENT_TRANSACTIONS = 8192;
    static final int CLIENT_RESERVED = 16384;
    static final int CLIENT_SECURE_CONNECTION = 32768;
    static final int CLIENT_MULTI_STATEMENTS = 65536;
    static final int CLIENT_MULTI_RESULTS = 131072;
    static final int CLIENT_PLUGIN_AUTH = 524288;
    static final int CLIENT_CONNECT_ATTRS = 0x100000;
    static final int CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA = 0x200000;
    static final int CLIENT_CAN_HANDLE_EXPIRED_PASSWORD = 0x400000;
    static final int CLIENT_SESSION_TRACK = 0x800000;
    static final int CLIENT_DEPRECATE_EOF = 0x1000000;
    static final String FALSE_SCRAMBLE = "xxxxxxxx";
    static final int MAX_QUERY_SIZE_TO_LOG = 1024;
    static final int MAX_QUERY_SIZE_TO_EXPLAIN = 0x100000;
    static final int INITIAL_PACKET_SIZE = 1024;
    static final String ZERO_DATE_VALUE_MARKER = "0000-00-00";
    static final String ZERO_DATETIME_VALUE_MARKER = "0000-00-00 00:00:00";
    static final String EXPLAINABLE_STATEMENT = "SELECT";
    static final String[] EXPLAINABLE_STATEMENT_EXTENSION = new String[]{"INSERT", "UPDATE", "REPLACE", "DELETE"};
    static final short TYPE_ID_ERROR = 255;
    static final short TYPE_ID_EOF = 254;
    static final short TYPE_ID_AUTH_SWITCH = 254;
    static final short TYPE_ID_LOCAL_INFILE = 251;
    static final short TYPE_ID_OK = 0;

    Mysqls() {
    }

    protected static final int getLength(byte[] src) {
        int length = src.length;
        if (length < 251) {
            return 1 + length;
        }
        if ((long)length < 65536L) {
            return 3 + length;
        }
        if ((long)length < 0x1000000L) {
            return 4 + length;
        }
        return 9 + length;
    }

    protected static void writeUB2(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    protected static void writeUB2(ByteBufferWriter buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    protected static void writeUB3(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
    }

    protected static void writeUB3(ByteBufferWriter buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
    }

    protected static void writeInt(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
        buffer.put((byte)(i >>> 24));
    }

    protected static void writeInt(ByteBufferWriter buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
        buffer.put((byte)(i >>> 24));
    }

    protected static void writeFloat(ByteBuffer buffer, float f) {
        Mysqls.writeInt(buffer, Float.floatToIntBits(f));
    }

    protected static void writeFloat(ByteBufferWriter buffer, float f) {
        Mysqls.writeInt(buffer, Float.floatToIntBits(f));
    }

    protected static void writeUB4(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    protected static void writeUB4(ByteBufferWriter buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    protected static void writeLong(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 32));
        buffer.put((byte)(l >>> 40));
        buffer.put((byte)(l >>> 48));
        buffer.put((byte)(l >>> 56));
    }

    protected static void writeLong(ByteBufferWriter buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 32));
        buffer.put((byte)(l >>> 40));
        buffer.put((byte)(l >>> 48));
        buffer.put((byte)(l >>> 56));
    }

    protected static void writeDouble(ByteBuffer buffer, double d) {
        Mysqls.writeLong(buffer, Double.doubleToLongBits(d));
    }

    protected static void writeDouble(ByteBufferWriter buffer, double d) {
        Mysqls.writeLong(buffer, Double.doubleToLongBits(d));
    }

    protected static void writeLength(ByteBuffer buffer, long l) {
        if (l < 251L) {
            buffer.put((byte)l);
        } else if (l < 65536L) {
            buffer.put((byte)-4);
            Mysqls.writeUB2(buffer, (int)l);
        } else if (l < 0x1000000L) {
            buffer.put((byte)-3);
            Mysqls.writeUB3(buffer, (int)l);
        } else {
            buffer.put((byte)-2);
            Mysqls.writeLong(buffer, l);
        }
    }

    protected static void writeLength(ByteBufferWriter buffer, long l) {
        if (l < 251L) {
            buffer.put((byte)l);
        } else if (l < 65536L) {
            buffer.put((byte)-4);
            Mysqls.writeUB2(buffer, (int)l);
        } else if (l < 0x1000000L) {
            buffer.put((byte)-3);
            Mysqls.writeUB3(buffer, (int)l);
        } else {
            buffer.put((byte)-2);
            Mysqls.writeLong(buffer, l);
        }
    }

    protected static void writeWithNull(ByteBuffer buffer, byte[] src) {
        buffer.put(src);
        buffer.put((byte)0);
    }

    protected static void writeWithNull(ByteBufferWriter buffer, byte[] src) {
        buffer.put(src);
        buffer.put((byte)0);
    }

    protected static void writeWithLength(ByteBuffer buffer, byte[] src) {
        int length = src.length;
        if (length < 251) {
            buffer.put((byte)length);
        } else if ((long)length < 65536L) {
            buffer.put((byte)-4);
            Mysqls.writeUB2(buffer, length);
        } else if ((long)length < 0x1000000L) {
            buffer.put((byte)-3);
            Mysqls.writeUB3(buffer, length);
        } else {
            buffer.put((byte)-2);
            Mysqls.writeLong(buffer, (long)length);
        }
        buffer.put(src);
    }

    protected static void writeWithLength(ByteBufferWriter buffer, byte[] src) {
        int length = src.length;
        if (length < 251) {
            buffer.put((byte)length);
        } else if ((long)length < 65536L) {
            buffer.put((byte)-4);
            Mysqls.writeUB2(buffer, length);
        } else if ((long)length < 0x1000000L) {
            buffer.put((byte)-3);
            Mysqls.writeUB3(buffer, length);
        } else {
            buffer.put((byte)-2);
            Mysqls.writeLong(buffer, (long)length);
        }
        buffer.put(src);
    }

    protected static void writeWithLength(ByteBuffer buffer, byte[] src, byte nullValue) {
        if (src == null) {
            buffer.put(nullValue);
        } else {
            Mysqls.writeWithLength(buffer, src);
        }
    }

    protected static void writeWithLength(ByteBufferWriter buffer, byte[] src, byte nullValue) {
        if (src == null) {
            buffer.put(nullValue);
        } else {
            Mysqls.writeWithLength(buffer, src);
        }
    }

    protected static int readUB2(ByteBuffer buffer) {
        return buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8;
    }

    protected static int readUB2(ByteBufferReader buffer) {
        return buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8;
    }

    protected static int readUB3(ByteBuffer buffer) {
        return buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16;
    }

    protected static int readUB3(ByteBufferReader buffer) {
        return buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16;
    }

    protected static long readUB4(ByteBuffer buffer) {
        return (long)buffer.get() & 0xFFL | ((long)buffer.get() & 0xFFL) << 8 | (long)(buffer.get() & 0xFF) << 16 | (long)(buffer.get() & 0xFF) << 24;
    }

    protected static long readUB4(ByteBufferReader buffer) {
        return (long)buffer.get() & 0xFFL | ((long)buffer.get() & 0xFFL) << 8 | (long)(buffer.get() & 0xFF) << 16 | (long)(buffer.get() & 0xFF) << 24;
    }

    protected static long readLong(ByteBuffer buffer) {
        return (long)buffer.get() & 0xFFL | ((long)buffer.get() & 0xFFL) << 8 | (long)(buffer.get() & 0xFF) << 16 | (long)(buffer.get() & 0xFF) << 24 | (long)(buffer.get() & 0xFF) << 32 | (long)(buffer.get() & 0xFF) << 40 | (long)(buffer.get() & 0xFF) << 48 | (long)(buffer.get() & 0xFF) << 56;
    }

    protected static long readLong(ByteBufferReader buffer) {
        return (long)buffer.get() & 0xFFL | ((long)buffer.get() & 0xFFL) << 8 | (long)(buffer.get() & 0xFF) << 16 | (long)(buffer.get() & 0xFF) << 24 | (long)(buffer.get() & 0xFF) << 32 | (long)(buffer.get() & 0xFF) << 40 | (long)(buffer.get() & 0xFF) << 48 | (long)(buffer.get() & 0xFF) << 56;
    }

    protected static long readLength(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        switch (length) {
            case 251: {
                return -1L;
            }
            case 252: {
                return Mysqls.readUB2(buffer);
            }
            case 253: {
                return Mysqls.readUB3(buffer);
            }
            case 254: {
                return Mysqls.readLong(buffer);
            }
        }
        return length;
    }

    protected static boolean checkLength(ByteBufferReader buffer) {
        int remain = buffer.remaining();
        if (remain < 1) {
            return false;
        }
        int length = buffer.preget() & 0xFF;
        switch (length) {
            case 251: {
                return true;
            }
            case 252: {
                return remain > 3;
            }
            case 253: {
                return remain > 4;
            }
            case 254: {
                return remain > 9;
            }
        }
        return true;
    }

    protected static long readLength(ByteBufferReader buffer) {
        int length = buffer.get() & 0xFF;
        switch (length) {
            case 251: {
                return -1L;
            }
            case 252: {
                return Mysqls.readUB2(buffer);
            }
            case 253: {
                return Mysqls.readUB3(buffer);
            }
            case 254: {
                return Mysqls.readLong(buffer);
            }
        }
        return length;
    }

    protected static byte[] readBytesWithLength(ByteBuffer buffer) {
        int length = (int)Mysqls.readLength(buffer);
        if (length == -1) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bs = new byte[length];
        buffer.get(bs);
        return bs;
    }

    protected static byte[] readBytesWithLength(ByteBufferReader buffer) {
        int length = (int)Mysqls.readLength(buffer);
        if (length == -1) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bs = new byte[length];
        buffer.get(bs);
        return bs;
    }

    protected static byte[] readBytes(ByteBufferReader buffer, int length) {
        if (length <= 0) {
            return new byte[0];
        }
        byte[] bs = new byte[length];
        buffer.get(bs);
        return bs;
    }

    protected static byte[] readBytes(ByteBuffer buffer, byte[] store, int len) {
        byte[] bs = store == null || len > store.length ? new byte[len] : store;
        buffer.get(bs, 0, len);
        return bs == store ? Arrays.copyOf(store, len) : bs;
    }

    protected static byte[] readBytes(ByteBufferReader buffer, byte[] store, int len) {
        byte[] bs = store == null || len > store.length ? new byte[len] : store;
        buffer.get(bs, 0, len);
        return bs == store ? Arrays.copyOf(store, len) : bs;
    }

    protected static byte[] readBytes(ByteBuffer buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            if (!buffer.hasRemaining()) break;
            c = buffer.get();
        }
        return array == null ? Arrays.copyOf(store, i) : array.getBytes();
    }

    protected static byte[] readBytes(ByteBufferReader buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            if (!buffer.hasRemaining()) break;
            c = buffer.get();
        }
        return array == null ? Arrays.copyOf(store, i) : array.getBytes();
    }

    protected static String readUTF8String(ByteBufferReader buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            if (!buffer.hasRemaining()) break;
            c = buffer.get();
        }
        return array == null ? new String(store, 0, i, StandardCharsets.UTF_8) : array.toString(StandardCharsets.UTF_8);
    }

    protected static String readASCIIString(ByteBuffer buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            if (!buffer.hasRemaining()) break;
            c = buffer.get();
        }
        return array == null ? new String(store, 0, i, StandardCharsets.US_ASCII) : array.toString(StandardCharsets.US_ASCII);
    }

    protected static String readASCIIString(ByteBuffer buffer, int length) {
        byte[] store = new byte[length];
        buffer.get(store);
        return new String(store, StandardCharsets.US_ASCII);
    }

    protected static String readASCIIString(ByteBufferReader buffer, byte[] store) {
        int i = 0;
        ByteArray array = null;
        byte c = buffer.get();
        while (c != 0) {
            if (array != null) {
                array.write(c);
            } else {
                store[i++] = c;
                if (i == store.length) {
                    array = new ByteArray(1024);
                    array.write(store);
                }
            }
            if (!buffer.hasRemaining()) break;
            c = buffer.get();
        }
        return array == null ? new String(store, 0, i, StandardCharsets.US_ASCII) : array.toString(StandardCharsets.US_ASCII);
    }

    protected static String readASCIIString(ByteBufferReader buffer, int length) {
        byte[] store = new byte[length];
        buffer.get(store);
        return new String(store, StandardCharsets.US_ASCII);
    }

    protected static ByteBuffer writeUTF8String(ByteBuffer buffer, String string) {
        buffer.put(string.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)0);
        return buffer;
    }

    protected static ByteBufferWriter writeUTF8String(ByteBufferWriter buffer, String string) {
        buffer.put(string.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)0);
        return buffer;
    }

    protected static byte[] scramble411(String password, byte[] seeds) {
        if (password == null || password.isEmpty()) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] passwordHashStage1 = md.digest(password.getBytes());
        md.reset();
        byte[] passwordHashStage2 = md.digest(passwordHashStage1);
        md.reset();
        md.update(seeds);
        md.update(passwordHashStage2);
        byte[] toBeXord = md.digest();
        int numToXor = toBeXord.length;
        for (int i = 0; i < numToXor; ++i) {
            toBeXord[i] = (byte)(toBeXord[i] ^ passwordHashStage1[i]);
        }
        return toBeXord;
    }

    protected static byte[] scrambleCachingSha2(String password, byte[] seeds) {
        if (password == null || password.isEmpty()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] passwordBytes = password.getBytes();
            int CACHING_SHA2_DIGEST_LENGTH = 32;
            byte[] dig1 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            byte[] dig2 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            byte[] scramble1 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            md.update(passwordBytes, 0, passwordBytes.length);
            md.digest(dig1, 0, CACHING_SHA2_DIGEST_LENGTH);
            md.reset();
            md.update(dig1, 0, dig1.length);
            md.digest(dig2, 0, CACHING_SHA2_DIGEST_LENGTH);
            md.reset();
            md.update(dig2, 0, dig1.length);
            md.update(seeds, 0, seeds.length);
            md.digest(scramble1, 0, CACHING_SHA2_DIGEST_LENGTH);
            byte[] mysqlScrambleBuff = new byte[CACHING_SHA2_DIGEST_LENGTH];
            Mysqls.xorString(dig1, mysqlScrambleBuff, scramble1, CACHING_SHA2_DIGEST_LENGTH);
            return mysqlScrambleBuff;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void xorString(byte[] from, byte[] to, byte[] scramble, int length) {
        int scrambleLength = scramble.length;
        for (int pos = 0; pos < length; ++pos) {
            to[pos] = (byte)(from[pos] ^ scramble[pos % scrambleLength]);
        }
    }
}

