/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.redkale.net.AsyncConnection;
import org.redkale.service.Local;
import org.redkale.source.ColumnNode;
import org.redkale.source.DataSource;
import org.redkale.source.DataSqlSource;
import org.redkale.source.EntityInfo;
import org.redkale.source.FilterFuncColumn;
import org.redkale.source.FilterNode;
import org.redkale.source.Flipper;
import org.redkale.source.PoolSource;
import org.redkale.util.Attribute;
import org.redkale.util.AutoLoad;
import org.redkale.util.ByteArray;
import org.redkale.util.ByteBufferReader;
import org.redkale.util.ByteBufferWriter;
import org.redkale.util.ObjectPool;
import org.redkale.util.ResourceType;
import org.redkale.util.SelectColumn;
import org.redkale.util.Sheet;
import org.redkalex.source.mysql.MyColumnCountPacket;
import org.redkalex.source.mysql.MyColumnDescPacket;
import org.redkalex.source.mysql.MyEOFPacket;
import org.redkalex.source.mysql.MyOKPacket;
import org.redkalex.source.mysql.MyPoolSource;
import org.redkalex.source.mysql.MyQueryPacket;
import org.redkalex.source.mysql.MyResultSet;
import org.redkalex.source.mysql.MyRowDataPacket;
import org.redkalex.source.mysql.Mysqls;

@Local
@AutoLoad(value=false)
@ResourceType(value=DataSource.class)
public class MysqlDataSource
extends DataSqlSource<AsyncConnection> {
    private static final byte[] BYTES_NULL = "NULL".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SQL_SET_AUTOCOMMIT_0 = "SET autocommit=0".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SQL_SET_AUTOCOMMIT_1 = "SET autocommit=1".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SQL_COMMIT = "COMMIT".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SQL_ROLLBACK = "ROLLBACK".getBytes(StandardCharsets.UTF_8);

    public static void main(String[] args) throws Throwable {
        Properties prop = new Properties();
        prop.setProperty("javax.persistence.jdbc.url", "jdbc:mysql://localhost:3306/platf_core?characterEncoding=utf8");
        prop.setProperty("javax.persistence.jdbc.user", "root");
        prop.setProperty("javax.persistence.jdbc.password", "");
        MysqlDataSource source = new MysqlDataSource("", null, prop, prop);
        source.getReadPoolSource().poll();
        source.directExecute("SET NAMES UTF8MB4");
    }

    public MysqlDataSource(String unitName, URL persistxml, Properties readprop, Properties writeprop) {
        super(unitName, persistxml, readprop, writeprop);
    }

    @Local
    protected PoolSource<AsyncConnection> readPoolSource() {
        return this.readPool;
    }

    @Local
    protected PoolSource<AsyncConnection> writePoolSource() {
        return this.writePool;
    }

    protected String prepareParamSign(int index) {
        return "$" + index;
    }

    protected final boolean isAsync() {
        return true;
    }

    protected PoolSource<AsyncConnection> createPoolSource(DataSource source, String rwtype, ArrayBlockingQueue queue, Semaphore semaphore, Properties prop) {
        return new MyPoolSource(rwtype, queue, semaphore, prop, this.logger, (ObjectPool<ByteBuffer>)this.bufferPool, this.executor);
    }

    protected <T> CompletableFuture<Integer> insertDB(EntityInfo<T> info, T ... values) {
        String realsql;
        Attribute[] attrs = info.getInsertAttributes();
        byte[][] sqlBytesArray = new byte[1][];
        String presql = info.getInsertPrepareSQL(values[0]);
        byte[] prebs = (presql.substring(0, presql.indexOf("VALUES")) + "VALUES").getBytes(StandardCharsets.UTF_8);
        ByteArray ba = new ByteArray();
        ba.write(prebs);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                ba.write((byte)44);
            }
            ba.write((byte)40);
            for (int j = 0; j < attrs.length; ++j) {
                byte[] param;
                if (j > 0) {
                    ba.write((byte)44);
                }
                if ((param = MysqlDataSource.formatPrepareParam(info, attrs[j], attrs[j].get(values[i]))) == null) {
                    ba.write(BYTES_NULL);
                    continue;
                }
                ba.write((byte)39);
                for (byte b : param) {
                    if (b == 92 || b == 39) {
                        ba.write((byte)92);
                    }
                    ba.write(b);
                }
                ba.write((byte)39);
            }
            ba.write((byte)41);
        }
        sqlBytesArray[0] = ba.getBytes();
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, realsql = ba.toString(StandardCharsets.UTF_8))) {
            this.logger.finest(info.getType().getSimpleName() + " insert sql=" + realsql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeBatchUpdate(info, (AsyncConnection)conn, (Object)values[0], true, sqlBytesArray).thenApply(rs -> {
            int count = 0;
            for (int i : rs) {
                count += i;
            }
            return count;
        }));
    }

    protected <T> CompletableFuture<Integer> deleteDB(EntityInfo<T> info, Flipper flipper, String sql) {
        String realsql;
        String string = realsql = flipper == null || flipper.getLimit() <= 0 ? sql : sql + " LIMIT " + flipper.getLimit();
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, realsql)) {
            this.logger.finest(info.getType().getSimpleName() + " delete sql=" + realsql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(info, (AsyncConnection)conn, realsql.getBytes(StandardCharsets.UTF_8)));
    }

    protected <T> CompletableFuture<Integer> clearTableDB(EntityInfo<T> info, String table, String sql) {
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, sql)) {
            this.logger.finest(info.getType().getSimpleName() + " clearTable sql=" + sql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(info, (AsyncConnection)conn, sql.getBytes(StandardCharsets.UTF_8)));
    }

    protected <T> CompletableFuture<Integer> dropTableDB(EntityInfo<T> info, String table, String sql) {
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, sql)) {
            this.logger.finest(info.getType().getSimpleName() + " dropTable sql=" + sql);
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(info, (AsyncConnection)conn, sql.getBytes(StandardCharsets.UTF_8)));
    }

    protected <T> CompletableFuture<Integer> updateDB(EntityInfo<T> info, T ... values) {
        Attribute primary = info.getPrimary();
        Attribute[] attrs = info.getUpdateAttributes();
        byte[][] sqlBytesArray = new byte[values.length][];
        char[] sqlChs = info.getUpdatePrepareSQL(values[0]).toCharArray();
        ByteArray ba = new ByteArray();
        for (int i = 0; i < values.length; ++i) {
            String realsql;
            int index = -1;
            for (char ch : sqlChs) {
                byte[] param;
                if (ch != '?') {
                    ba.write((byte)ch);
                    continue;
                }
                byte[] byArray = param = ++index < attrs.length ? MysqlDataSource.formatPrepareParam(info, attrs[index], attrs[index].get(values[i])) : MysqlDataSource.formatPrepareParam(info, primary, primary.get(values[i]));
                if (param == null) {
                    ba.write(BYTES_NULL);
                    continue;
                }
                ba.write((byte)39);
                for (byte b : param) {
                    if (b == 92 || b == 39) {
                        ba.write((byte)92);
                    }
                    ba.write(b);
                }
                ba.write((byte)39);
            }
            sqlBytesArray[i] = ba.getBytes();
            if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, realsql = ba.toString(StandardCharsets.UTF_8))) {
                this.logger.finest(info.getType().getSimpleName() + " update sql=" + realsql);
            }
            ba.clear();
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeBatchUpdate(info, (AsyncConnection)conn, null, false, sqlBytesArray).thenApply(rs -> {
            int count = 0;
            for (int i : rs) {
                count += i;
            }
            return count;
        }));
    }

    protected <T> CompletableFuture<Integer> updateDB(EntityInfo<T> info, Flipper flipper, String sql, boolean prepared, Object ... params) {
        int i;
        String realsql;
        String string = realsql = flipper == null || flipper.getLimit() <= 0 ? sql : sql + " LIMIT " + flipper.getLimit();
        if (info.isLoggable(this.logger, Level.FINEST) && info.isLoggable(this.logger, Level.FINEST, realsql)) {
            this.logger.finest(info.getType().getSimpleName() + " update sql=" + realsql);
        }
        if (!prepared) {
            return this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(info, (AsyncConnection)conn, realsql.getBytes(StandardCharsets.UTF_8)));
        }
        ByteArray ba = new ByteArray();
        String[] subsqls = realsql.split("\\" + this.prepareParamSign(1).replace("1", "") + "\\d+");
        for (i = 0; i < params.length; ++i) {
            ba.write(subsqls[i].getBytes(StandardCharsets.UTF_8));
            byte[] param = MysqlDataSource.formatPrepareParam(info, null, params[i]);
            if (param == null) {
                ba.write(BYTES_NULL);
                continue;
            }
            ba.write((byte)39);
            for (byte b : param) {
                if (b == 92 || b == 39) {
                    ba.write((byte)92);
                }
                ba.write(b);
            }
            ba.write((byte)39);
        }
        for (i = params.length; i < subsqls.length; ++i) {
            ba.write(subsqls[i].getBytes(StandardCharsets.UTF_8));
        }
        return this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(info, (AsyncConnection)conn, ba.getBytes()));
    }

    protected <T, N extends Number> CompletableFuture<Map<String, N>> getNumberMapDB(EntityInfo<T> info, String sql, FilterFuncColumn ... columns) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            HashMap<String, Number> map = new HashMap<String, Number>();
            try {
                if (set.next()) {
                    int index = 0;
                    for (FilterFuncColumn ffc : columns) {
                        for (String col : ffc.cols()) {
                            Object o = set.getObject(++index);
                            Number rs = ffc.getDefvalue();
                            if (o != null) {
                                rs = (Number)o;
                            }
                            map.put(ffc.col(col), rs);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return map;
        }));
    }

    protected <T> CompletableFuture<Number> getNumberResultDB(EntityInfo<T> info, String sql, Number defVal, String column) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            Number rs = defVal;
            try {
                Object o;
                if (set.next() && (o = set.getObject(1)) != null) {
                    rs = (Number)o;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T, K extends Serializable, N extends Number> CompletableFuture<Map<K, N>> queryColumnMapDB(EntityInfo<T> info, String sql, String keyColumn) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            LinkedHashMap<Serializable, Number> rs = new LinkedHashMap<Serializable, Number>();
            try {
                while (set.next()) {
                    rs.put((Serializable)set.getObject(1), (Number)set.getObject(2));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T, K extends Serializable, N extends Number> CompletableFuture<Map<K[], N[]>> queryColumnMapDB(EntityInfo<T> info, String sql, ColumnNode[] funcNodes, String[] groupByColumns) {
        return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, sql).thenApply(set -> {
            LinkedHashMap<Serializable[], Number[]> rs = new LinkedHashMap<Serializable[], Number[]>();
            try {
                while (set.next()) {
                    int index = 0;
                    Serializable[] keys = new Serializable[groupByColumns.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = (Serializable)set.getObject(++index);
                    }
                    Number[] vals = new Number[funcNodes.length];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = (Number)set.getObject(++index);
                    }
                    rs.put(keys, vals);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T> CompletableFuture<T> findDB(EntityInfo<T> info, String sql, boolean onlypk, SelectColumn selects) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            Object rs = null;
            try {
                rs = set.next() ? this.getEntityValue(info, selects, (ResultSet)set) : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return rs;
        }));
    }

    protected <T> CompletableFuture<Serializable> findColumnDB(EntityInfo<T> info, String sql, boolean onlypk, String column, Serializable defValue) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            Serializable val = defValue;
            try {
                if (set.next()) {
                    Attribute attr = info.getAttribute(column);
                    val = this.getFieldValue(info, attr, (ResultSet)set, 1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return val == null ? defValue : val;
        }));
    }

    protected <T> CompletableFuture<Boolean> existsDB(EntityInfo<T> info, String sql, boolean onlypk) {
        return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, sql), info).thenApply(set -> {
            try {
                boolean rs = set.next() ? set.getInt(1) > 0 : false;
                return rs;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    protected <T> CompletableFuture<Sheet<T>> querySheetDB(EntityInfo<T> info, boolean readcache, boolean needtotal, boolean distinct, SelectColumn selects, Flipper flipper, FilterNode node) {
        SelectColumn sels = selects;
        Map joinTabalis = node == null ? null : this.getJoinTabalis(node);
        CharSequence join = node == null ? null : this.createSQLJoin(node, (Function)((Object)this), false, joinTabalis, new HashSet(), info);
        CharSequence where = node == null ? null : this.createSQLExpress(node, info, joinTabalis);
        String listsql = "SELECT " + (distinct ? "DISTINCT " : "") + info.getQueryColumns("a", selects) + " FROM " + info.getTable(node) + " a" + (join == null ? "" : join) + (where == null || where.length() == 0 ? "" : " WHERE " + where) + this.createSQLOrderby(info, flipper) + (flipper == null || flipper.getLimit() < 1 ? "" : " LIMIT " + flipper.getLimit() + " OFFSET " + flipper.getOffset());
        if (readcache && info.isLoggable(this.logger, Level.FINEST, listsql)) {
            this.logger.finest(info.getType().getSimpleName() + " query sql=" + listsql);
        }
        if (!needtotal) {
            return this.readPool.pollAsync().thenCompose(conn -> this.exceptionallyQueryTableNotExist(this.executeQuery(info, (AsyncConnection)conn, listsql), info).thenApply(set -> {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (set.next()) {
                        list.add(this.getEntityValue(info, sels, (ResultSet)set));
                    }
                    return Sheet.asSheet(list);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        String countsql = "SELECT " + (distinct ? "DISTINCT COUNT(" + info.getQueryColumns("a", selects) + ")" : "COUNT(*)") + " FROM " + info.getTable(node) + " a" + (join == null ? "" : join) + (where == null || where.length() == 0 ? "" : " WHERE " + where);
        return this.getNumberResultDB(info, countsql, 0, countsql).thenCompose(total -> {
            if (total.longValue() <= 0L) {
                return CompletableFuture.completedFuture(new Sheet(0, new ArrayList()));
            }
            return this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(info, (AsyncConnection)conn, listsql).thenApply(set -> {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (set.next()) {
                        list.add(this.getEntityValue(info, sels, (ResultSet)set));
                    }
                    return new Sheet(total.longValue(), list);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        });
    }

    protected CompletableFuture<ResultSet> exceptionallyQueryTableNotExist(CompletableFuture<ResultSet> future, EntityInfo info) {
        if (info == null || info.getTableStrategy() == null) {
            return future;
        }
        return future.exceptionally(ex -> {
            Throwable sqlex = ex;
            while (sqlex instanceof CompletionException) {
                sqlex = sqlex.getCause();
            }
            if (info.getTableStrategy() != null && sqlex instanceof SQLException && info.isTableNotExist((SQLException)sqlex)) {
                return new MyResultSet(new MyColumnDescPacket[0], new ArrayList<MyRowDataPacket>());
            }
            future.obtrudeException(sqlex);
            return null;
        });
    }

    protected <T> CompletableFuture<Integer> exceptionallyUpdateTableNotExist(CompletableFuture<Integer> future, EntityInfo<T> info, AsyncConnection conn, byte[] array, T oneEntity, boolean checkAndCreateTable, byte[] sqlBytes) {
        CompletableFuture<Integer> newFuture = new CompletableFuture<Integer>();
        future.whenComplete((o, ex1) -> {
            if (ex1 == null) {
                newFuture.complete((Integer)o);
                return;
            }
            try {
                while (ex1 instanceof CompletionException) {
                    ex1 = ex1.getCause();
                }
                if (info.getTableStrategy() != null && ex1 instanceof SQLException && info.isTableNotExist((SQLException)ex1)) {
                    if (!checkAndCreateTable) {
                        newFuture.complete(0);
                        return;
                    }
                    String newTable = info.getTable(oneEntity);
                    byte[] createTableSqlBytes = info.getTableCopySQL(newTable).getBytes(StandardCharsets.UTF_8);
                    this.executeAtomicOneUpdate(info, conn, array, createTableSqlBytes).whenComplete((o2, ex2) -> {
                        if (ex2 == null) {
                            info.addDisTable(newTable);
                            this.executeAtomicOneUpdate(info, conn, array, sqlBytes).whenComplete((o3, ex3) -> {
                                if (ex3 == null) {
                                    newFuture.complete((Integer)o3);
                                } else {
                                    while (ex3 instanceof CompletionException) {
                                        ex3 = ex3.getCause();
                                    }
                                    newFuture.completeExceptionally((Throwable)ex3);
                                }
                            });
                        } else {
                            while (ex2 instanceof CompletionException) {
                                ex2 = ex2.getCause();
                            }
                            if (newTable.indexOf(46) > 0 && ex2 instanceof SQLException && ("HY000".equals(((SQLException)ex2).getSQLState()) || "42000".equals(((SQLException)ex2).getSQLState()))) {
                                this.executeAtomicOneUpdate(info, conn, array, ("CREATE DATABASE " + newTable.substring(0, newTable.indexOf(46))).getBytes()).whenComplete((o3, ex3) -> {
                                    if (ex3 == null) {
                                        this.executeAtomicOneUpdate(info, conn, array, createTableSqlBytes).whenComplete((o4, ex4) -> {
                                            if (ex4 == null) {
                                                info.addDisTable(newTable);
                                                this.executeAtomicOneUpdate(info, conn, array, sqlBytes).whenComplete((o5, ex5) -> {
                                                    if (ex5 == null) {
                                                        newFuture.complete((Integer)o5);
                                                    } else {
                                                        while (ex5 instanceof CompletionException) {
                                                            ex5 = ex5.getCause();
                                                        }
                                                        newFuture.completeExceptionally((Throwable)ex5);
                                                    }
                                                });
                                            } else {
                                                while (ex4 instanceof CompletionException) {
                                                    ex4 = ex4.getCause();
                                                }
                                                newFuture.completeExceptionally((Throwable)ex4);
                                            }
                                        });
                                    } else {
                                        while (ex3 instanceof CompletionException) {
                                            ex3 = ex3.getCause();
                                        }
                                        newFuture.completeExceptionally((Throwable)ex3);
                                    }
                                });
                            } else {
                                newFuture.completeExceptionally((Throwable)ex2);
                            }
                        }
                    });
                } else {
                    newFuture.completeExceptionally((Throwable)ex1);
                }
            }
            catch (Throwable t) {
                newFuture.completeExceptionally(t);
            }
        });
        return newFuture;
    }

    protected static <T> byte[] formatPrepareParam(EntityInfo<T> info, Attribute<T, Serializable> attr, Object param) {
        if (param == null && info.isNotNullJson(attr)) {
            return new byte[0];
        }
        if (param == null) {
            return null;
        }
        if (param instanceof CharSequence) {
            return param.toString().getBytes(StandardCharsets.UTF_8);
        }
        if (param instanceof Boolean) {
            byte[] byArray;
            if (((Boolean)param).booleanValue()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 49;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 48;
            }
            return byArray;
        }
        if (param instanceof byte[]) {
            return (byte[])param;
        }
        if (param instanceof Blob) {
            Blob blob = (Blob)param;
            try {
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(param instanceof Number || param instanceof CharSequence || param instanceof Date || param.getClass().getName().startsWith("java.sql.") || param.getClass().getName().startsWith("java.time."))) {
            if (attr == null) {
                return info.getJsonConvert().convertTo(param).getBytes(StandardCharsets.UTF_8);
            }
            return info.getJsonConvert().convertTo(attr.genericType(), param).getBytes(StandardCharsets.UTF_8);
        }
        return String.valueOf(param).getBytes(StandardCharsets.UTF_8);
    }

    protected <T> CompletableFuture<Integer> executeOneUpdate(EntityInfo<T> info, AsyncConnection conn, byte[] sqlBytes) {
        return this.executeBatchUpdate(info, conn, null, false, new byte[][]{sqlBytes}).thenApply(a -> a[0]);
    }

    /*
     * Exception decompiling
     */
    protected <T> CompletableFuture<int[]> executeBatchUpdate(EntityInfo<T> info, AsyncConnection conn, T oneEntity, boolean checkAndCreateTable, byte[] ... sqlBytesArray) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <T> CompletableFuture<Integer> executeAtomicOneUpdate(EntityInfo<T> info, final AsyncConnection conn, final byte[] array, byte[] sqlBytes) {
        ByteBufferWriter writer = ByteBufferWriter.create((Supplier)this.bufferPool);
        new MyQueryPacket(sqlBytes).writeTo(writer);
        ByteBuffer[] buffers = writer.toBuffers();
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        conn.write(buffers, (Object)buffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

            @Override
            public void completed(Integer result, ByteBuffer[] attachment1) {
                if (result < 0) {
                    this.failed((Throwable)new SQLException("Write Buffer Error"), attachment1);
                    return;
                }
                int index = -1;
                for (int i = 0; i < attachment1.length; ++i) {
                    if (attachment1[i].hasRemaining()) {
                        index = i;
                        break;
                    }
                    MysqlDataSource.this.bufferPool.accept((Object)attachment1[i]);
                }
                if (index == 0) {
                    conn.write(attachment1, (Object)attachment1, (CompletionHandler)this);
                    return;
                }
                if (index > 0) {
                    ByteBuffer[] newattachs = new ByteBuffer[attachment1.length - index];
                    System.arraycopy(attachment1, index, newattachs, 0, newattachs.length);
                    conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                    return;
                }
                final ArrayList readBuffs = new ArrayList();
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment2) {
                        if (result < 0) {
                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment2);
                            return;
                        }
                        if (result == 16384 || !attachment2.hasRemaining()) {
                            attachment2.flip();
                            readBuffs.add(attachment2);
                            conn.read((CompletionHandler)this);
                            return;
                        }
                        attachment2.flip();
                        readBuffs.add(attachment2);
                        ByteBufferReader bufferReader = ByteBufferReader.create((Collection)readBuffs);
                        MyOKPacket okPacket = new MyOKPacket(-1, bufferReader, array);
                        if (!okPacket.isOK()) {
                            future.completeExceptionally(new SQLException(okPacket.toMessageString("MySQLOKPacket statusCode not success"), okPacket.sqlState, okPacket.vendorCode));
                        } else {
                            for (ByteBuffer buf : readBuffs) {
                                MysqlDataSource.this.bufferPool.accept((Object)buf);
                            }
                            future.complete((int)okPacket.updateCount);
                        }
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment2) {
                        conn.offerBuffer(attachment2);
                        future.completeExceptionally(exc);
                    }
                });
            }

            @Override
            public void failed(Throwable exc, ByteBuffer[] attachment1) {
                for (ByteBuffer attach : attachment1) {
                    MysqlDataSource.this.bufferPool.accept((Object)attach);
                }
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    protected <T> CompletableFuture<ResultSet> executeQuery(EntityInfo<T> info, final AsyncConnection conn, final String sql) {
        final byte[] array = (byte[])conn.getAttribute("BYTES_NAME");
        ByteBufferWriter writer = ByteBufferWriter.create((Supplier)this.bufferPool);
        new MyQueryPacket(sql.getBytes(StandardCharsets.UTF_8)).writeTo(writer);
        ByteBuffer[] buffers = writer.toBuffers();
        final CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        conn.write(buffers, (Object)buffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

            @Override
            public void completed(Integer result, ByteBuffer[] attachment1) {
                if (result < 0) {
                    this.failed((Throwable)new SQLException("Write Buffer Error"), attachment1);
                    return;
                }
                int index = -1;
                for (int i = 0; i < attachment1.length; ++i) {
                    if (attachment1[i].hasRemaining()) {
                        index = i;
                        break;
                    }
                    MysqlDataSource.this.bufferPool.accept((Object)attachment1[i]);
                }
                if (index == 0) {
                    conn.write(attachment1, (Object)attachment1, (CompletionHandler)this);
                    return;
                }
                if (index > 0) {
                    ByteBuffer[] newattachs = new ByteBuffer[attachment1.length - index];
                    System.arraycopy(attachment1, index, newattachs, 0, newattachs.length);
                    conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                    return;
                }
                final ArrayList readBuffs = new ArrayList();
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment2) {
                        if (result < 0) {
                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment2);
                            return;
                        }
                        if (result == 16384 || !attachment2.hasRemaining()) {
                            attachment2.flip();
                            readBuffs.add(attachment2);
                            conn.read((CompletionHandler)this);
                            return;
                        }
                        attachment2.flip();
                        readBuffs.add(attachment2);
                        ByteBufferReader bufferReader = ByteBufferReader.create((Collection)readBuffs);
                        boolean endok = false;
                        boolean futureover = false;
                        boolean success = false;
                        SQLException ex = null;
                        int packetLength = Mysqls.readUB3(bufferReader);
                        MyResultSet resultSet = null;
                        if (packetLength < 4) {
                            MyColumnCountPacket countPacket = new MyColumnCountPacket(packetLength, bufferReader, array);
                            MyColumnDescPacket[] colDescs = new MyColumnDescPacket[countPacket.columnCount];
                            for (int i = 0; i < colDescs.length; ++i) {
                                colDescs[i] = new MyColumnDescPacket(bufferReader, array);
                            }
                            MyEOFPacket eofPacket = new MyEOFPacket(-1, -1000, bufferReader, array);
                            ArrayList<MyRowDataPacket> rows = new ArrayList<MyRowDataPacket>();
                            int colPacketLength = Mysqls.readUB3(bufferReader);
                            byte packetIndex = bufferReader.get();
                            int typeid = bufferReader.preget() & 0xFF;
                            while (typeid != 254) {
                                MyRowDataPacket rowData = new MyRowDataPacket(colDescs, colPacketLength, packetIndex, bufferReader, countPacket.columnCount, array);
                                while (!rowData.readColumnValue(bufferReader) || bufferReader.remaining() < 9) {
                                    final CompletableFuture patchFuture = new CompletableFuture();
                                    conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                                        @Override
                                        public void completed(Integer result3, ByteBuffer attachment3) {
                                            if (result3 < 0) {
                                                this.failed((Throwable)new SQLException("Read Buffer Error"), attachment3);
                                                return;
                                            }
                                            attachment3.flip();
                                            patchFuture.complete(attachment3);
                                        }

                                        @Override
                                        public void failed(Throwable exc, ByteBuffer attachment3) {
                                            patchFuture.completeExceptionally(exc);
                                        }
                                    });
                                    bufferReader.append(new ByteBuffer[]{(ByteBuffer)patchFuture.join()});
                                }
                                colPacketLength = Mysqls.readUB3(bufferReader);
                                packetIndex = bufferReader.get();
                                typeid = bufferReader.preget() & 0xFF;
                                rows.add(rowData);
                            }
                            eofPacket = new MyEOFPacket(colPacketLength, packetIndex, bufferReader, array);
                            resultSet = new MyResultSet(colDescs, rows);
                            success = true;
                            endok = true;
                            futureover = true;
                        } else {
                            MyOKPacket okPacket = new MyOKPacket(packetLength, bufferReader, array);
                            ex = new SQLException(okPacket.toMessageString("MySQLOKPacket statusCode not success"), okPacket.sqlState, okPacket.vendorCode);
                        }
                        if (!futureover) {
                            future.completeExceptionally(ex == null ? new SQLException("SQL(" + sql + ") executeQuery error") : ex);
                        }
                        if (endok) {
                            MysqlDataSource.this.readPool.offerConnection((Object)conn);
                            future.complete(resultSet);
                        } else {
                            conn.dispose();
                        }
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment2) {
                        future.completeExceptionally(exc);
                        conn.dispose();
                    }
                });
            }

            @Override
            public void failed(Throwable exc, ByteBuffer[] attachment1) {
                for (ByteBuffer attach : attachment1) {
                    MysqlDataSource.this.bufferPool.accept((Object)attach);
                }
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    @Local
    public int directExecute(String sql) {
        return (Integer)((CompletableFuture)this.writePool.pollAsync().thenCompose(conn -> this.executeOneUpdate(null, (AsyncConnection)conn, sql.getBytes(StandardCharsets.UTF_8)))).join();
    }

    @Local
    public int[] directExecute(String ... sqls) {
        byte[][] sqlBytesArray = new byte[sqls.length][];
        for (int i = 0; i < sqls.length; ++i) {
            sqlBytesArray[i] = sqls[i].getBytes(StandardCharsets.UTF_8);
        }
        return (int[])((CompletableFuture)this.writePool.pollAsync().thenCompose(conn -> this.executeBatchUpdate(null, (AsyncConnection)conn, null, false, sqlBytesArray))).join();
    }

    @Local
    public <V> V directQuery(String sql, Function<ResultSet, V> handler) {
        return (V)((CompletableFuture)this.readPool.pollAsync().thenCompose(conn -> this.executeQuery(null, (AsyncConnection)conn, sql).thenApply(set -> handler.apply((ResultSet)set)))).join();
    }

    private /* synthetic */ void lambda$executeBatchUpdate$46(AsyncConnection conn, int[] o, Throwable t) {
        if (t == null) {
            this.writePool.offerConnection((Object)conn);
        } else {
            conn.dispose();
        }
    }

    private static /* synthetic */ int[] lambda$executeBatchUpdate$45(int[] rs, byte[][] sqlBytesArray, Integer a) {
        return Arrays.copyOfRange(rs, 1, sqlBytesArray.length + 1);
    }

    private /* synthetic */ CompletionStage lambda$executeBatchUpdate$44(EntityInfo info, AsyncConnection conn, byte[] array, int[] rs, byte[][] sqlBytesArray, Integer a) {
        CompletableFuture<Integer> nextFuture = this.executeAtomicOneUpdate(info, conn, array, SQL_COMMIT);
        nextFuture.thenAccept(b -> {
            rs[sqlBytesArray.length] = b;
        });
        return nextFuture;
    }

    private /* synthetic */ CompletionStage lambda$executeBatchUpdate$42(EntityInfo info, AsyncConnection conn, byte[] array, byte[] sqlBytes, int[] rs, int index, boolean checkAndCreateTable, Object oneEntity, Integer a) {
        CompletableFuture<Integer> nextFuture = this.executeAtomicOneUpdate(info, conn, array, sqlBytes);
        nextFuture.thenAccept(b -> {
            rs[index] = b;
        });
        if (checkAndCreateTable && info != null && info.getTableStrategy() != null) {
            nextFuture = this.exceptionallyUpdateTableNotExist(nextFuture, info, conn, array, oneEntity, checkAndCreateTable, sqlBytes);
        }
        nextFuture.whenComplete((o, t) -> {
            if (t != null) {
                this.executeAtomicOneUpdate(info, conn, array, SQL_ROLLBACK).join();
            }
        });
        return nextFuture;
    }

    private static /* synthetic */ void lambda$executeBatchUpdate$39(int[] rs, Integer a) {
        rs[0] = a;
    }

    private /* synthetic */ void lambda$executeBatchUpdate$38(AsyncConnection conn, int[] o, Throwable t) {
        if (t == null) {
            this.writePool.offerConnection((Object)conn);
        } else {
            conn.dispose();
        }
    }
}

