/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.redkale.util.ByteBufferReader;
import org.redkalex.source.mysql.MyColumnDescPacket;
import org.redkalex.source.mysql.MyPacket;
import org.redkalex.source.mysql.Mysqls;

public class MyRowDataPacket
extends MyPacket {
    public final MyColumnDescPacket[] columns;
    public int columnCount;
    public final byte[][] values;
    private int currValueIndex = 0;
    private int currValueLength = -2;

    public MyRowDataPacket(MyColumnDescPacket[] columns, int len, int index, ByteBufferReader reader, int columnCount, byte[] array) {
        this.columns = columns;
        this.columnCount = columnCount;
        this.packetLength = len;
        this.packetIndex = index < -999 ? reader.get() : (byte)index;
        this.values = new byte[columnCount][];
    }

    public boolean readColumnValue(ByteBufferReader reader) {
        int start;
        if (this.currValueIndex > this.columnCount) {
            return true;
        }
        for (int i = start = this.currValueIndex; i < this.columnCount; ++i) {
            if (this.currValueLength == -2) {
                if (!Mysqls.checkLength(reader)) {
                    return false;
                }
                this.currValueLength = (int)Mysqls.readLength(reader);
            }
            if (this.currValueLength > -1 && reader.remaining() < this.currValueLength) {
                return false;
            }
            this.values[i] = this.currValueLength == -1 ? null : Mysqls.readBytes(reader, this.currValueLength);
            ++this.currValueIndex;
            this.currValueLength = -2;
        }
        ++this.currValueIndex;
        return true;
    }

    public byte[] getValue(int i) {
        return this.values[i];
    }

    public Serializable getObject(int i) {
        boolean binary;
        byte[] bs = this.values[i];
        if (bs == null) {
            return null;
        }
        MyColumnDescPacket coldesc = this.columns[i];
        int mytype = coldesc.type;
        boolean bl = binary = (coldesc.flags & 0x80) > 0;
        if (mytype == 16) {
            return Byte.valueOf(bs[0]);
        }
        if (mytype == 252) {
            Object object;
            if (binary) {
                object = bs;
            } else {
                String string;
                object = string;
                string = new String(bs, StandardCharsets.UTF_8);
            }
            return object;
        }
        if (mytype == 10) {
            return Date.valueOf(new String(bs));
        }
        if (mytype == 12) {
            return Timestamp.valueOf(new String(bs));
        }
        if (mytype == 0) {
            throw new UnsupportedOperationException("FIELD_TYPE_DECIMAL not supported yet.");
        }
        if (mytype == 5) {
            return Double.valueOf(Double.parseDouble(new String(bs)));
        }
        if (mytype == 247) {
            throw new UnsupportedOperationException("FIELD_TYPE_ENUM not supported yet.");
        }
        if (mytype == 4) {
            return Float.valueOf(Float.parseFloat(new String(bs)));
        }
        if (mytype == 255) {
            throw new UnsupportedOperationException("FIELD_TYPE_GEOMETRY not supported yet.");
        }
        if (mytype == 9) {
            return Integer.valueOf(Integer.parseInt(new String(bs)));
        }
        if (mytype == 245) {
            throw new UnsupportedOperationException("FIELD_TYPE_JSON not supported yet.");
        }
        if (mytype == 3) {
            return Long.valueOf(Long.parseLong(new String(bs)));
        }
        if (mytype == 8) {
            return Long.valueOf(Long.parseLong(new String(bs)));
        }
        if (mytype == 251) {
            Object object;
            if (binary) {
                object = bs;
            } else {
                String string;
                object = string;
                string = new String(bs, StandardCharsets.UTF_8);
            }
            return object;
        }
        if (mytype == 250) {
            Object object;
            if (binary) {
                object = bs;
            } else {
                String string;
                object = string;
                string = new String(bs, StandardCharsets.UTF_8);
            }
            return object;
        }
        if (mytype == 246) {
            return Double.valueOf(Double.parseDouble(new String(bs)));
        }
        if (mytype == 6) {
            return null;
        }
        if (mytype == 248) {
            throw new UnsupportedOperationException("FIELD_TYPE_SET not supported yet.");
        }
        if (mytype == 2) {
            return Short.valueOf(Short.parseShort(new String(bs)));
        }
        if (mytype == 254) {
            return new String(bs, StandardCharsets.UTF_8);
        }
        if (mytype == 11) {
            return Time.valueOf(new String(bs));
        }
        if (mytype == 7) {
            return Timestamp.valueOf(new String(bs));
        }
        if (mytype == 1) {
            return Boolean.valueOf(bs.length == 1 && "1".equals(new String(bs)));
        }
        if (mytype == 249) {
            Object object;
            if (binary) {
                object = bs;
            } else {
                String string;
                object = string;
                string = new String(bs, StandardCharsets.UTF_8);
            }
            return object;
        }
        if (mytype == 15) {
            return new String(bs, StandardCharsets.UTF_8);
        }
        if (mytype == 253) {
            return new String(bs, StandardCharsets.UTF_8);
        }
        if (mytype == 13) {
            throw new UnsupportedOperationException("FIELD_TYPE_JSON not supported yet.");
        }
        return null;
    }

    public int length() {
        if (this.values == null) {
            return -1;
        }
        return this.values.length;
    }

    @Override
    public String toString() {
        return "{cols:" + (this.values == null ? -1 : this.values.length) + "}";
    }
}

