/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.redkale.net.AsyncConnection;
import org.redkale.source.PoolTcpSource;
import org.redkale.util.ByteBufferReader;
import org.redkale.util.ObjectPool;
import org.redkalex.source.mysql.MyAuthPacket;
import org.redkalex.source.mysql.MyHandshakePacket;
import org.redkalex.source.mysql.MyOKPacket;
import org.redkalex.source.mysql.MyQueryPacket;
import org.redkalex.source.mysql.Mysqls;

public class MyPoolSource
extends PoolTcpSource {
    protected static final String CONN_ATTR_BYTES_NAME = "BYTES_NAME";
    protected static final String CONN_ATTR_CURR_DBNAME = "CURR_DBNAME";
    protected static final byte[] CURRDBNAME_BYTES = "SELECT DATABASE()".getBytes();
    protected static final byte[] PING_BYTES = "SELECT 1".getBytes();
    protected static final String CONN_ATTR_PROTOCOL_VERSION = "PROTOCOL_VERSION";

    public MyPoolSource(String rwtype, ArrayBlockingQueue queue, Semaphore semaphore, Properties prop, Logger logger, ObjectPool<ByteBuffer> bufferPool, ThreadPoolExecutor executor) {
        super(rwtype, queue, semaphore, prop, logger, bufferPool, executor);
        if (this.encoding == null || this.encoding.isEmpty()) {
            this.encoding = "UTF8MB4";
        }
    }

    protected ByteBuffer reqConnectBuffer(AsyncConnection conn) {
        if (conn.getAttribute(CONN_ATTR_BYTES_NAME) == null) {
            conn.setAttribute(CONN_ATTR_BYTES_NAME, (Object)new byte[1024]);
        }
        return null;
    }

    protected void respConnectBuffer(final ByteBuffer buffer, final CompletableFuture<AsyncConnection> future, final AsyncConnection conn) {
        final byte[] bytes = (byte[])conn.getAttribute(CONN_ATTR_BYTES_NAME);
        MyHandshakePacket handshakePacket = null;
        try {
            handshakePacket = new MyHandshakePacket(buffer, bytes);
        }
        catch (Exception ex) {
            this.bufferPool.accept((Object)buffer);
            conn.dispose();
            future.completeExceptionally(ex);
            return;
        }
        MyAuthPacket authPacket = new MyAuthPacket(handshakePacket, this.username, this.password, this.database);
        buffer.clear();
        authPacket.writeTo(buffer);
        buffer.flip();
        conn.write(buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment1) {
                if (result < 0) {
                    this.failed((Throwable)new RuntimeException("Write Buffer Error"), attachment1);
                    return;
                }
                if (buffer.hasRemaining()) {
                    conn.write(buffer, (Object)attachment1, (CompletionHandler)this);
                    return;
                }
                buffer.clear();
                conn.setReadBuffer(buffer);
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment2) {
                        if (result < 0) {
                            this.failed((Throwable)new RuntimeException("Read Buffer Error"), attachment2);
                            return;
                        }
                        attachment2.flip();
                        MyOKPacket okPacket = new MyOKPacket(-1, ByteBufferReader.create((ByteBuffer)buffer), bytes);
                        if (!okPacket.isOK()) {
                            conn.offerBuffer(buffer);
                            future.completeExceptionally(new SQLException(okPacket.toMessageString("MySQLOKPacket statusCode not success"), okPacket.sqlState));
                            conn.dispose();
                            return;
                        }
                        buffer.clear();
                        new MyQueryPacket(("SET NAMES " + MyPoolSource.this.encoding).getBytes()).writeTo(buffer);
                        buffer.flip();
                        conn.write(buffer, (Object)buffer, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                            @Override
                            public void completed(Integer result, ByteBuffer attachment3) {
                                if (result < 0) {
                                    this.failed((Throwable)new RuntimeException("Write Buffer Error"), attachment3);
                                    return;
                                }
                                if (buffer.hasRemaining()) {
                                    conn.write(buffer, (Object)attachment3, (CompletionHandler)this);
                                    return;
                                }
                                buffer.clear();
                                conn.setReadBuffer(buffer);
                                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                                    @Override
                                    public void completed(Integer result, ByteBuffer attachment4) {
                                        if (result < 0) {
                                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment4);
                                            return;
                                        }
                                        attachment4.flip();
                                        MyOKPacket okPacket = new MyOKPacket(-1, ByteBufferReader.create((ByteBuffer)attachment4), bytes);
                                        if (!okPacket.isOK()) {
                                            conn.offerBuffer(buffer);
                                            future.completeExceptionally(new SQLException(okPacket.toMessageString("MySQLOKPacket statusCode not success"), okPacket.sqlState));
                                            conn.dispose();
                                            return;
                                        }
                                        MyPoolSource.this.bufferPool.accept((Object)buffer);
                                        future.complete(conn);
                                    }

                                    @Override
                                    public void failed(Throwable exc, ByteBuffer attachment4) {
                                        conn.offerBuffer(attachment4);
                                        future.completeExceptionally(exc);
                                        conn.dispose();
                                    }
                                });
                            }

                            @Override
                            public void failed(Throwable exc, ByteBuffer attachment3) {
                                conn.offerBuffer(attachment3);
                                future.completeExceptionally(exc);
                                conn.dispose();
                            }
                        });
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment2) {
                        conn.offerBuffer(attachment2);
                        future.completeExceptionally(exc);
                        conn.dispose();
                    }
                });
            }

            @Override
            public void failed(Throwable exc, Void attachment1) {
                MyPoolSource.this.bufferPool.accept((Object)buffer);
                conn.dispose();
                future.completeExceptionally(exc);
            }
        });
    }

    protected int getDefaultPort() {
        return 3306;
    }

    protected CompletableFuture<AsyncConnection> sendPingCommand(final AsyncConnection conn) {
        final ByteBuffer buffer = (ByteBuffer)this.bufferPool.get();
        Mysqls.writeUB3(buffer, 1 + PING_BYTES.length);
        buffer.put((byte)0);
        buffer.put((byte)3);
        buffer.put(PING_BYTES);
        buffer.flip();
        final CompletableFuture<AsyncConnection> future = new CompletableFuture<AsyncConnection>();
        conn.write(buffer, (Object)buffer, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                if (result < 0) {
                    this.failed((Throwable)new RuntimeException("Write Buffer Error"), attachment);
                    return;
                }
                if (buffer.hasRemaining()) {
                    conn.write(buffer, (Object)attachment, (CompletionHandler)this);
                    return;
                }
                buffer.clear();
                conn.setReadBuffer(buffer);
                conn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                    @Override
                    public void completed(Integer result, ByteBuffer attachment) {
                        if (result < 0) {
                            this.failed((Throwable)new SQLException("Read Buffer Error"), attachment);
                            return;
                        }
                        MyPoolSource.this.bufferPool.accept((Object)buffer);
                        future.complete(conn);
                    }

                    @Override
                    public void failed(Throwable exc, ByteBuffer attachment) {
                        MyPoolSource.this.bufferPool.accept((Object)buffer);
                        conn.dispose();
                        future.completeExceptionally(exc);
                    }
                });
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                MyPoolSource.this.bufferPool.accept((Object)buffer);
                conn.dispose();
                future.completeExceptionally(exc);
            }
        });
        return future;
    }

    protected CompletableFuture<AsyncConnection> sendCloseCommand(final AsyncConnection conn) {
        final ByteBuffer buffer = (ByteBuffer)this.bufferPool.get();
        Mysqls.writeUB3(buffer, 1);
        buffer.put((byte)0);
        buffer.put((byte)1);
        buffer.flip();
        final CompletableFuture<AsyncConnection> future = new CompletableFuture<AsyncConnection>();
        conn.write(buffer, (Object)buffer, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                if (result < 0) {
                    this.failed((Throwable)new RuntimeException("Write Buffer Error"), attachment);
                    return;
                }
                if (buffer.hasRemaining()) {
                    conn.write(buffer, (Object)attachment, (CompletionHandler)this);
                    return;
                }
                buffer.clear();
                MyPoolSource.this.bufferPool.accept((Object)buffer);
                future.complete(conn);
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                MyPoolSource.this.bufferPool.accept((Object)buffer);
                conn.dispose();
                future.completeExceptionally(exc);
            }
        });
        return future;
    }
}

