/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import org.redkale.convert.ConvertDisabled;
import org.redkale.util.ByteBufferReader;
import org.redkalex.source.mysql.MyErrorNumbers;
import org.redkalex.source.mysql.MyPacket;
import org.redkalex.source.mysql.Mysqls;

public class MyOKPacket
extends MyPacket {
    public static final byte[] OK = new byte[]{7, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0};
    public static final byte[] AC_OFF = new byte[]{7, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0};
    public static final short TYPE_ID_ERROR = 255;
    public static final short TYPE_ID_EOF = 254;
    public static final short TYPE_ID_AUTH_SWITCH = 254;
    public static final short TYPE_ID_LOCAL_INFILE = 251;
    public static final short TYPE_ID_OK = 0;
    public int typeid;
    public int vendorCode;
    public String sqlState;
    public String info;
    public long updateCount = -1L;
    public long updateID = -1L;
    public int warningCount;
    public int statusFlags;

    public MyOKPacket(int len, ByteBufferReader reader, byte[] array) {
        this.packetLength = len < 1 ? Mysqls.readUB3(reader) : len;
        this.packetIndex = reader.get();
        this.typeid = reader.get() & 0xFF;
        if (this.typeid == 254) {
            this.warningCount = Mysqls.readUB2(reader);
            this.statusFlags = Mysqls.readUB2(reader);
        } else if (this.typeid == 255) {
            this.vendorCode = Mysqls.readUB2(reader);
            byte[] bs = Mysqls.readBytes(reader, array);
            if (bs != null) {
                this.info = new String(bs);
                if (this.info.charAt(0) == '#') {
                    if (this.info.length() > 6) {
                        this.sqlState = this.info.substring(1, 6);
                        this.info = this.info.substring(6);
                        if (this.sqlState.equals("HY000")) {
                            this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                        }
                    } else {
                        this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                    }
                } else {
                    this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                }
            }
        } else {
            byte[] bs;
            this.updateCount = Mysqls.readLength(reader);
            this.updateID = Mysqls.readLength(reader);
            this.statusFlags = Mysqls.readUB2(reader);
            this.warningCount = Mysqls.readUB2(reader);
            if (reader.hasRemaining() && (bs = Mysqls.readBytes(reader, array)) != null) {
                this.info = new String(bs);
                if (this.info.charAt(0) == '#') {
                    if (this.info.length() > 6) {
                        this.sqlState = this.info.substring(1, 6);
                        this.info = this.info.substring(6);
                        if (this.sqlState.equals("HY000")) {
                            this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                        }
                    } else {
                        this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                    }
                } else {
                    this.sqlState = MyErrorNumbers.mysqlToSqlState(this.vendorCode);
                }
            }
        }
    }

    @ConvertDisabled
    public boolean isEOF() {
        return this.typeid == 254 && this.packetLength <= 5;
    }

    public boolean isOK() {
        return this.typeid == 0;
    }

    public String toMessageString(String defval) {
        if (this.info == null) {
            return defval;
        }
        return this.info;
    }
}

