/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.redkalex.source.mysql.MyPacket;
import org.redkalex.source.mysql.Mysqls;

public class MyHandshakePacket
extends MyPacket {
    private static final byte[] FILLER_13 = new byte[13];
    public int protocolVersion;
    public String serverVersion;
    public byte[] authPlugin;
    public long threadId;
    public byte[] seed;
    public int serverCapabilities;
    public int serverCharsetIndex;
    public int serverStatus;
    public byte[] seed2;

    public MyHandshakePacket(ByteBuffer buffer, byte[] array) throws SQLException {
        this.packetLength = Mysqls.readUB3(buffer);
        this.packetIndex = buffer.get();
        this.protocolVersion = buffer.get() & 0xFF;
        if (this.protocolVersion == 255) {
            int vendorCode = Mysqls.readUB2(buffer);
            String desc = Mysqls.readASCIIString(buffer, array);
            throw new SQLException(desc + " (vendorCode=" + vendorCode + ")", null, vendorCode);
        }
        if (this.protocolVersion < 10) {
            throw new SQLException("Not supported protocolVersion(" + this.protocolVersion + "), must greaterthan 10");
        }
        this.serverVersion = Mysqls.readASCIIString(buffer, array);
        if (Integer.parseInt(this.serverVersion.substring(0, this.serverVersion.indexOf(46))) < 5) {
            throw new SQLException("Not supported serverVersion(" + this.serverVersion + "), must greaterthan 5.0");
        }
        this.threadId = Mysqls.readUB4(buffer);
        this.seed = Mysqls.readBytes(buffer, array);
        this.serverCapabilities = buffer.hasRemaining() ? Mysqls.readUB2(buffer) : 0;
        this.serverCharsetIndex = buffer.get() & 0xFF;
        this.serverStatus = Mysqls.readUB2(buffer);
        buffer.get(FILLER_13);
        this.seed2 = Mysqls.readBytes(buffer, array);
        if (buffer.hasRemaining()) {
            this.authPlugin = Mysqls.readBytes(buffer, array);
        }
    }
}

