/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.source.mysql;

import java.nio.ByteBuffer;
import org.redkale.util.Utility;
import org.redkalex.source.mysql.MyHandshakePacket;
import org.redkalex.source.mysql.MyPacket;
import org.redkalex.source.mysql.Mysqls;

public class MyAuthPacket
extends MyPacket {
    private static final byte[] FILLER = new byte[23];
    public int charsetIndex;
    public byte[] extra;
    public String username;
    public byte[] password;
    public String database;

    public MyAuthPacket(MyHandshakePacket handshakePacket, String username, String password, String database) {
        byte[] seed = Utility.append((byte[])handshakePacket.seed, (byte[])handshakePacket.seed2);
        this.packetIndex = 1;
        this.username = username;
        this.password = Mysqls.scramble411(password, seed);
        this.database = database;
    }

    public ByteBuffer writeTo(ByteBuffer buffer) {
        Mysqls.writeUB3(buffer, this.calcPacketSize());
        buffer.put(this.packetIndex);
        Mysqls.writeUB4(buffer, (long)this.getClientCapabilities());
        Mysqls.writeUB4(buffer, 0xFFFFFFL);
        buffer.put((byte)8);
        buffer.put(FILLER);
        if (this.username == null || this.username.isEmpty()) {
            buffer.put((byte)0);
        } else {
            Mysqls.writeWithNull(buffer, this.username.getBytes());
        }
        if (this.password == null) {
            buffer.put((byte)0);
        } else {
            Mysqls.writeWithLength(buffer, this.password);
        }
        if (this.database == null || this.database.isEmpty()) {
            buffer.put((byte)0);
        } else {
            Mysqls.writeWithNull(buffer, this.database.getBytes());
        }
        return buffer;
    }

    protected int calcPacketSize() {
        int size = 32;
        size += this.username == null || this.username.isEmpty() ? 1 : this.username.length() + 1;
        size += this.password == null ? 1 : Mysqls.getLength(this.password);
        return size += this.database == null || this.database.isEmpty() ? 1 : this.database.length() + 1;
    }

    private int getClientCapabilities() {
        int flag = 0;
        flag |= 1;
        flag |= 2;
        flag |= 4;
        flag |= 8;
        flag |= 0x40;
        flag |= 0x100;
        flag |= 0x200;
        flag |= 0x400;
        flag |= 0x1000;
        flag |= 0x2000;
        return flag |= 0x8000;
    }
}

