/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.redkale.net.PrepareServlet;
import org.redkale.net.Response;
import org.redkale.net.Server;
import org.redkale.net.http.HttpContext;
import org.redkale.util.AnyValue;
import org.redkale.util.Creator;
import org.redkale.util.ObjectPool;
import org.redkale.util.ResourceFactory;
import org.redkalex.socks.SocksContext;
import org.redkalex.socks.SocksPrepareServlet;
import org.redkalex.socks.SocksRequest;
import org.redkalex.socks.SocksResponse;
import org.redkalex.socks.SocksServlet;

public final class SocksServer
extends Server<Serializable, SocksContext, SocksRequest, SocksResponse, SocksServlet> {
    public SocksServer() {
        this(System.currentTimeMillis(), ResourceFactory.root());
    }

    public SocksServer(long serverStartTime, ResourceFactory resourceFactory) {
        super(serverStartTime, "TCP", resourceFactory, (PrepareServlet)new SocksPrepareServlet());
    }

    public void init(AnyValue config) throws Exception {
        super.init(config);
    }

    protected SocksContext createContext() {
        if (this.readTimeoutSeconds < 1) {
            this.readTimeoutSeconds = 6;
        }
        if (this.writeTimeoutSeconds < 1) {
            this.writeTimeoutSeconds = 6;
        }
        AtomicLong createBufferCounter = new AtomicLong();
        AtomicLong cycleBufferCounter = new AtomicLong();
        int rcapacity = Math.max(this.bufferCapacity, 8192);
        ObjectPool bufferPool = new ObjectPool(createBufferCounter, cycleBufferCounter, this.bufferPoolSize, params -> ByteBuffer.allocateDirect(rcapacity), null, e -> {
            if (e == null || e.isReadOnly() || e.capacity() != rcapacity) {
                return false;
            }
            e.clear();
            return true;
        });
        AtomicLong createResponseCounter = new AtomicLong();
        AtomicLong cycleResponseCounter = new AtomicLong();
        ObjectPool<Response> responsePool = SocksResponse.createPool(createResponseCounter, cycleResponseCounter, this.responsePoolSize, null);
        HttpContext.HttpContextConfig contextConfig = new HttpContext.HttpContextConfig();
        contextConfig.serverStartTime = this.serverStartTime;
        contextConfig.logger = this.logger;
        contextConfig.executor = this.executor;
        contextConfig.sslContext = this.sslContext;
        contextConfig.bufferCapacity = rcapacity;
        contextConfig.maxbody = this.maxbody;
        contextConfig.charset = this.charset;
        contextConfig.address = this.address;
        contextConfig.prepare = this.prepare;
        contextConfig.resourceFactory = this.resourceFactory;
        contextConfig.aliveTimeoutSeconds = this.aliveTimeoutSeconds;
        contextConfig.readTimeoutSeconds = this.readTimeoutSeconds;
        contextConfig.writeTimeoutSeconds = this.writeTimeoutSeconds;
        return new SocksContext(contextConfig);
    }

    protected ObjectPool<ByteBuffer> createBufferPool(AtomicLong createCounter, AtomicLong cycleCounter, int bufferPoolSize) {
        AtomicLong createBufferCounter = new AtomicLong();
        AtomicLong cycleBufferCounter = new AtomicLong();
        int rcapacity = this.bufferCapacity;
        ObjectPool bufferPool = new ObjectPool(createBufferCounter, cycleBufferCounter, bufferPoolSize, params -> ByteBuffer.allocateDirect(rcapacity), null, e -> {
            if (e == null || e.isReadOnly() || e.capacity() != rcapacity) {
                return false;
            }
            e.clear();
            return true;
        });
        return bufferPool;
    }

    protected ObjectPool<Response> createResponsePool(AtomicLong createCounter, AtomicLong cycleCounter, int responsePoolSize) {
        return SocksResponse.createPool(createCounter, cycleCounter, responsePoolSize, null);
    }

    protected Creator<Response> createResponseCreator(ObjectPool<ByteBuffer> bufferPool, ObjectPool<Response> responsePool) {
        return params -> new SocksResponse((SocksContext)this.context, new SocksRequest((SocksContext)this.context, bufferPool), responsePool);
    }
}

