/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.redkale.net.AsyncConnection;
import org.redkale.util.ObjectPool;
import org.redkalex.socks.SocksContext;

public class SocksRunner
implements Runnable {
    private final AsyncConnection channel;
    private final Logger logger;
    private final boolean finest;
    private final SocksContext context;
    private final ObjectPool<ByteBuffer> bufferPool;
    private final byte[] bindAddressBytes;
    private ByteBuffer buffer;
    protected boolean closed = false;
    private InetSocketAddress remoteAddress;
    private AsyncConnection remoteChannel;

    public SocksRunner(SocksContext context, ObjectPool<ByteBuffer> bufferPool, AsyncConnection channel, byte[] bindAddressBytes) {
        this.context = context;
        this.bufferPool = bufferPool;
        this.logger = context.getLogger();
        this.finest = this.context.getLogger().isLoggable(Level.FINEST);
        this.channel = channel;
        this.buffer = channel.pollReadBuffer();
        this.bindAddressBytes = bindAddressBytes;
    }

    @Override
    public void run() {
        try {
            this.ask();
        }
        catch (Exception e) {
            this.closeRunner(e);
        }
    }

    private void ask() {
        this.buffer.putChar('\u0500');
        this.buffer.flip();
        this.channel.write(this.buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                if (SocksRunner.this.buffer.hasRemaining()) {
                    SocksRunner.this.channel.write(SocksRunner.this.buffer, null, (CompletionHandler)this);
                    return;
                }
                try {
                    SocksRunner.this.connect();
                }
                catch (Exception e) {
                    SocksRunner.this.closeRunner(e);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                SocksRunner.this.closeRunner(exc);
            }
        });
    }

    private void connect() {
        this.buffer.clear();
        this.channel.setReadBuffer(this.buffer);
        this.channel.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                SocksRunner.this.buffer.flip();
                if (!SocksRunner.this.buffer.hasRemaining()) {
                    SocksRunner.this.closeRunner(null);
                    return;
                }
                if (SocksRunner.this.buffer.getChar() != '\u0501') {
                    if (SocksRunner.this.finest) {
                        SocksRunner.this.logger.finest("connect header not 0x0501");
                    }
                    SocksRunner.this.closeRunner(null);
                    return;
                }
                char addrtype = SocksRunner.this.buffer.getChar();
                try {
                    byte[] bytes = new byte[addrtype == '\u0003' ? SocksRunner.this.buffer.get() & 0xFF : addrtype * 4];
                    SocksRunner.this.buffer.get(bytes);
                    SocksRunner.this.remoteAddress = new InetSocketAddress(addrtype == '\u0003' ? InetAddress.getByName(new String(bytes)) : InetAddress.getByAddress(bytes), (int)SocksRunner.this.buffer.getChar());
                }
                catch (UnknownHostException e) {
                    this.failed((Throwable)e, attachment);
                    return;
                }
                try {
                    SocksRunner.this.remoteChannel = (AsyncConnection)AsyncConnection.createTCP((ObjectPool)SocksRunner.this.bufferPool, (AsynchronousChannelGroup)SocksRunner.this.context.getAsynchronousChannelGroup(), (SocketAddress)SocksRunner.this.remoteAddress, (int)6, (int)6).join();
                    SocksRunner.this.buffer.clear();
                    SocksRunner.this.buffer.putChar('\u0500');
                    SocksRunner.this.buffer.put((byte)0);
                    SocksRunner.this.buffer.put(SocksRunner.this.bindAddressBytes);
                    SocksRunner.this.buffer.flip();
                    final ByteBuffer rbuffer = (ByteBuffer)SocksRunner.this.bufferPool.get();
                    final ByteBuffer wbuffer = (ByteBuffer)SocksRunner.this.bufferPool.get();
                    SocksRunner.this.channel.write(SocksRunner.this.buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                        @Override
                        public void completed(Integer result, Void attachment) {
                            if (SocksRunner.this.buffer.hasRemaining()) {
                                SocksRunner.this.channel.write(SocksRunner.this.buffer, null, (CompletionHandler)this);
                                return;
                            }
                            SocksRunner.this.stream();
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment) {
                            SocksRunner.this.bufferPool.accept((Object)rbuffer);
                            SocksRunner.this.bufferPool.accept((Object)wbuffer);
                            SocksRunner.this.closeRunner(exc);
                        }
                    });
                }
                catch (Exception e) {
                    SocksRunner.this.buffer.clear();
                    SocksRunner.this.buffer.putChar('\u0504');
                    if (SocksRunner.this.finest) {
                        SocksRunner.this.logger.log(Level.FINEST, SocksRunner.this.remoteAddress + " remote connect error", e);
                    }
                    SocksRunner.this.channel.write(SocksRunner.this.buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                        @Override
                        public void completed(Integer result, Void attachment) {
                            if (SocksRunner.this.buffer.hasRemaining()) {
                                SocksRunner.this.channel.write(SocksRunner.this.buffer, null, (CompletionHandler)this);
                                return;
                            }
                            SocksRunner.this.closeRunner(null);
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment) {
                            SocksRunner.this.closeRunner(exc);
                        }
                    });
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                SocksRunner.this.closeRunner(exc);
            }
        });
    }

    private void stream() {
        new StreamCompletionHandler(this.channel, this.remoteChannel).completed(1, null);
        new StreamCompletionHandler(this.remoteChannel, this.channel).completed(1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRunner(Throwable e) {
        if (this.closed) {
            return;
        }
        SocksRunner socksRunner = this;
        synchronized (socksRunner) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.bufferPool.accept((Object)this.buffer);
            this.buffer = null;
            if (e != null && this.finest) {
                this.logger.log(Level.FINEST, "close socks channel by error", e);
            }
        }
    }

    private class StreamCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private final AsyncConnection readconn;
        private final AsyncConnection writeconn;
        private final ByteBuffer rbuffer;

        public StreamCompletionHandler(AsyncConnection conn1, AsyncConnection conn2) {
            this.readconn = conn1;
            this.writeconn = conn2;
            this.rbuffer = (ByteBuffer)SocksRunner.this.bufferPool.get();
            this.rbuffer.flip();
        }

        @Override
        public void completed(Integer result0, final Void v0) {
            final StreamCompletionHandler self = this;
            if (this.rbuffer.hasRemaining()) {
                this.writeconn.write(this.rbuffer, (Object)v0, (CompletionHandler)self);
                return;
            }
            if (result0 < 1) {
                self.failed((Throwable)null, v0);
                return;
            }
            this.rbuffer.clear();
            this.readconn.setReadBuffer(this.rbuffer);
            this.readconn.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    if (result < 1) {
                        self.failed(null, v0);
                        return;
                    }
                    attachment.flip();
                    StreamCompletionHandler.this.writeconn.write(attachment, (Object)v0, self);
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    self.failed(exc, v0);
                }
            });
        }

        @Override
        public void failed(Throwable exc, Void v) {
            SocksRunner.this.bufferPool.accept((Object)this.rbuffer);
            this.readconn.dispose();
            this.writeconn.dispose();
            if (SocksRunner.this.finest) {
                SocksRunner.this.logger.log(Level.FINEST, "StreamCompletionHandler closed", exc);
            }
        }
    }
}

