/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.nio.ByteBuffer;
import org.redkale.net.Context;
import org.redkale.net.Request;
import org.redkale.util.ObjectPool;
import org.redkalex.socks.HttpxRequest;
import org.redkalex.socks.SocksContext;

public class SocksRequest
extends Request<SocksContext> {
    private final HttpxRequest httpRequest;
    private boolean http;

    protected SocksRequest(SocksContext context, ObjectPool<ByteBuffer> bufferPool) {
        super((Context)context, bufferPool);
        this.httpRequest = new HttpxRequest(context, null);
    }

    protected int readHeader(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (buffer.get(0) > 5 && remaining > 4) {
            this.http = true;
            return this.httpRequest.readHeader(buffer);
        }
        this.http = false;
        if (remaining == 4) {
            if (buffer.get() != 5) {
                return -1;
            }
            if (buffer.get() != 2) {
                return -1;
            }
            if (buffer.get() != 0) {
                return -1;
            }
            if (buffer.get() != 2) {
                return -1;
            }
        } else {
            if (buffer.get() != 5) {
                return -1;
            }
            if (buffer.get() != 1) {
                return -1;
            }
            if (buffer.get() != 0) {
                return -1;
            }
        }
        return 0;
    }

    protected int readBody(ByteBuffer buffer) {
        return this.http ? this.httpRequest.readBody(buffer) : buffer.remaining();
    }

    protected void prepare() {
        this.httpRequest.prepare();
    }

    protected void recycle() {
        this.http = false;
        this.httpRequest.setChannel(null);
        this.httpRequest.recycle();
        super.recycle();
    }

    public boolean isHttp() {
        return this.http;
    }

    public void setHttp(boolean http) {
        this.http = http;
    }

    HttpxRequest getHttpxRequest() {
        return this.httpRequest;
    }
}

