/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import org.redkale.net.AsyncConnection;
import org.redkale.util.AutoLoad;
import org.redkale.util.ByteArray;
import org.redkalex.socks.HttpxRequest;
import org.redkalex.socks.HttpxResponse;
import org.redkalex.socks.SocksContext;
import org.redkalex.socks.SocksRequest;
import org.redkalex.socks.SocksResponse;
import org.redkalex.socks.SocksServlet;

@AutoLoad(value=false)
public final class SocksHttpxServlet
extends SocksServlet {
    protected static final byte[] LINE = new byte[]{13, 10};

    public void execute(SocksRequest request, SocksResponse response) throws IOException {
        request.getHttpxRequest().setChannel(response.getChannel());
        response.getHttpxResponse().setChannel(response.getChannel());
        this.execute(request.getHttpxRequest(), response.getHttpxResponse(), ((SocksContext)request.getContext()).getAsynchronousChannelGroup());
    }

    private void execute(final HttpxRequest request, final HttpxResponse response, AsynchronousChannelGroup group) throws IOException {
        response.skipHeader();
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.connect(request, response, group);
            return;
        }
        String url = request.getRequestURI();
        url = url.substring(url.indexOf("://") + 3);
        url = url.substring(url.indexOf(47));
        final ByteBuffer buffer = (ByteBuffer)response.getBufferPool().get();
        buffer.put((request.getMethod() + " " + url + " HTTP/1.1\r\n").getBytes());
        for (String header : request.getHeaderNames()) {
            if (header.startsWith("Proxy-")) continue;
            buffer.put((header + ": " + request.getHeader(header) + "\r\n").getBytes());
        }
        if (request.getHost() != null) {
            buffer.put(("Host: " + request.getHost() + "\r\n").getBytes());
        }
        if (request.getContentType() != null) {
            buffer.put(("Content-Type: " + request.getContentType() + "\r\n").getBytes());
        }
        if (request.getContentLength() > 0L) {
            buffer.put(("Content-Length: " + request.getContentLength() + "\r\n").getBytes());
        }
        buffer.put(LINE);
        ByteArray body = request.getDirectBody();
        if (!body.isEmpty()) {
            buffer.put(body.directBytes(), 0, body.size());
        }
        buffer.put(LINE);
        buffer.flip();
        final AsyncConnection remote = (AsyncConnection)AsyncConnection.createTCP(response.getBufferPool(), (AsynchronousChannelGroup)group, (SocketAddress)request.getHostSocketAddress(), (int)6, (int)6).join();
        remote.write(buffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                if (buffer.hasRemaining()) {
                    remote.write(buffer, (Object)attachment, (CompletionHandler)this);
                    return;
                }
                response.offerBuffer(buffer);
                new ProxyCompletionHandler(remote, request, response).completed(0, null);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                response.offerBuffer(buffer);
                response.finish(true);
                try {
                    remote.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private void connect(final HttpxRequest request, final HttpxResponse response, AsynchronousChannelGroup group) throws IOException {
        InetSocketAddress remoteAddress = request.getURLSocketAddress();
        final AsyncConnection remote = remoteAddress.getPort() == 443 ? null : (AsyncConnection)AsyncConnection.createTCP(response.getBufferPool(), (AsynchronousChannelGroup)group, (SocketAddress)remoteAddress, (int)6, (int)6).join();
        ByteBuffer buffer0 = (ByteBuffer)response.getBufferPool().get();
        buffer0.put("HTTP/1.1 200 Connection established\r\nConnection: close\r\n\r\n".getBytes());
        buffer0.flip();
        response.sendBody(buffer0, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                new ProxyCompletionHandler(remote, request, response).completed(0, null);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                response.finish(true);
                try {
                    remote.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static class ProxyCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private final AsyncConnection remote;
        private final HttpxRequest request;
        private final HttpxResponse response;

        public ProxyCompletionHandler(AsyncConnection remote, HttpxRequest request, HttpxResponse response) {
            this.remote = remote;
            this.request = request;
            this.response = response;
        }

        @Override
        public void completed(Integer result0, Void v0) {
            this.remote.read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, final ByteBuffer rbuffer) {
                    if (result <= 0) {
                        this.failed((Throwable)null, rbuffer);
                        return;
                    }
                    rbuffer.flip();
                    final 1 parent = this;
                    response.sendBody(rbuffer.duplicate().asReadOnlyBuffer(), null, new CompletionHandler<Integer, Void>(){

                        @Override
                        public void completed(Integer result, Void attachment) {
                            rbuffer.clear();
                            remote.setReadBuffer(rbuffer);
                            remote.read(parent);
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment) {
                            parent.failed(exc, attachment);
                        }
                    });
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    response.offerBuffer(attachment);
                    response.finish(true);
                    try {
                        remote.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.request.getChannel().read((CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, final ByteBuffer qbuffer) {
                    if (result <= 0) {
                        this.failed((Throwable)null, qbuffer);
                        return;
                    }
                    qbuffer.flip();
                    final 2 parent = this;
                    remote.write(qbuffer, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                        @Override
                        public void completed(Integer result, Void attachment) {
                            qbuffer.clear();
                            request.getChannel().setReadBuffer(qbuffer);
                            request.getChannel().read(parent);
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment) {
                            parent.failed(exc, attachment);
                        }
                    });
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    response.offerBuffer(attachment);
                    response.finish(true);
                    try {
                        remote.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void failed(Throwable exc, Void v) {
            this.response.finish(true);
            try {
                this.remote.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

