/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Utility;
import org.redkalex.socks.SocksContext;
import org.redkalex.socks.SocksRequest;
import org.redkalex.socks.SocksResponse;
import org.redkalex.socks.SocksRunner;
import org.redkalex.socks.SocksServlet;

@AutoLoad(value=false)
public class Socks5Servlet
extends SocksServlet {
    private InetSocketAddress bindAddress;
    private byte[] bindAddressBytes = new byte[0];

    public void init(SocksContext context, AnyValue config) {
        ByteBuffer bb;
        InetAddress addr;
        this.bindAddress = config == null ? new InetSocketAddress(Utility.localInetAddress(), context.getServerAddress().getPort()) : new InetSocketAddress(config.getValue("bindaddr", Utility.localInetAddress().getHostAddress()), context.getServerAddress().getPort());
        Logger logger = context.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("[" + Thread.currentThread().getName() + "] bindAddress = " + this.bindAddress);
        }
        if ((addr = this.bindAddress.getAddress()) instanceof Inet6Address) {
            bb = ByteBuffer.allocate(19);
            bb.put((byte)4);
        } else {
            bb = ByteBuffer.allocate(7);
            bb.put((byte)1);
        }
        bb.put(addr.getAddress());
        bb.putChar((char)this.bindAddress.getPort());
        bb.flip();
        this.bindAddressBytes = bb.array();
    }

    public void execute(SocksRequest request, SocksResponse response) throws IOException {
        ((SocksContext)response.getContext()).submitAsync(new SocksRunner((SocksContext)response.getContext(), response.getBufferPool(), response.removeChannel(), this.bindAddressBytes));
        response.finish(true);
    }
}

