/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.socks;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import org.redkale.boot.Application;
import org.redkale.boot.ClassFilter;
import org.redkale.boot.NodeProtocol;
import org.redkale.boot.NodeServer;
import org.redkale.net.Filter;
import org.redkale.net.Server;
import org.redkale.net.Servlet;
import org.redkale.util.AnyValue;
import org.redkalex.socks.SocksServer;
import org.redkalex.socks.SocksServlet;

@NodeProtocol(value={"SOCKS"})
public class NodeSocksServer
extends NodeServer {
    private final SocksServer socksServer;

    public NodeSocksServer(Application application, AnyValue serconf) {
        super(application, NodeSocksServer.createServer(application, serconf));
        this.socksServer = (SocksServer)this.server;
    }

    private static Server createServer(Application application, AnyValue serconf) {
        return new SocksServer(application.getStartTime(), application.getResourceFactory().createChild());
    }

    public InetSocketAddress getSocketAddress() {
        return this.socksServer == null ? null : this.socksServer.getSocketAddress();
    }

    protected ClassFilter<Servlet> createServletClassFilter() {
        return this.createClassFilter(null, null, SocksServlet.class, null, null, "servlets", "servlet");
    }

    protected void loadServlet(ClassFilter<? extends Servlet> servletFilter, ClassFilter otherFilter) throws Exception {
        if (this.socksServer != null) {
            this.loadSocksServlet(this.serverConf.getAnyValue("servlets"), servletFilter);
        }
    }

    protected void loadSocksServlet(AnyValue conf, ClassFilter<? extends Servlet> filter) throws Exception {
        StringBuilder sb = this.logger.isLoggable(Level.FINE) ? new StringBuilder() : null;
        String threadName = "[" + Thread.currentThread().getName() + "] ";
        for (ClassFilter.FilterEntry en : filter.getFilterEntrys()) {
            Class clazz = en.getType();
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            SocksServlet servlet = (SocksServlet)((Object)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.resourceFactory.inject((Object)servlet);
            AnyValue.DefaultAnyValue servletConf = (AnyValue.DefaultAnyValue)en.getProperty();
            this.socksServer.addServlet(servlet, null, (AnyValue)servletConf, new Serializable[0]);
            if (sb == null) continue;
            sb.append(threadName).append(" Loaded ").append(clazz.getName()).append(" --> ").append(servletConf).append("\r\n");
        }
        if (sb != null && sb.length() > 0) {
            this.logger.log(Level.FINE, sb.toString());
        }
    }

    protected void loadFilter(ClassFilter<? extends Filter> filterFilter, ClassFilter otherFilter) throws Exception {
    }

    protected ClassFilter<Filter> createFilterClassFilter() {
        return null;
    }
}

