/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Local;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Comment;
import org.redkale.util.Utility;
import org.redkalex.pay.AbstractPayService;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;

@Local
@AutoLoad(value=false)
public class WeiXinPayService
extends AbstractPayService {
    protected static final String format = "%1$tY%1$tm%1$td%1$tH%1$tM%1$tS";
    protected static final Pattern PAYXML = Pattern.compile("<([^/>]+)>(.+)</.+>");
    protected Map<String, WeixinPayElement> elements = new HashMap<String, WeixinPayElement>();
    @Resource(name="property.pay.weixin.conf")
    protected String conf = "config.properties";
    @Resource(name="APP_HOME")
    protected File home;
    @Resource
    protected JsonConvert convert;

    public void init(AnyValue conf) {
        if (this.convert == null) {
            this.convert = JsonConvert.root();
        }
        this.reloadConfig((short)13);
    }

    @Override
    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public boolean supportPayType(short paytype) {
        return paytype == 13 && !this.elements.isEmpty();
    }

    @Override
    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public void reloadConfig(short paytype) {
        if (this.conf != null && !this.conf.isEmpty()) {
            try {
                FileInputStream in;
                File file = this.conf.indexOf(47) == 0 || this.conf.indexOf(58) > 0 ? new File(this.conf) : new File(this.home, "conf/" + this.conf);
                InputStream inputStream = in = file.isFile() && file.canRead() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.conf);
                if (in == null) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                this.elements = WeixinPayElement.create(this.logger, properties, this.home);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "init weixinpay conf error", e);
            }
        }
    }

    public void setPayElements(Map<String, WeixinPayElement> elements) {
        this.elements = elements;
    }

    public void putPayElements(Map<String, WeixinPayElement> elements) {
        this.elements.putAll(elements);
    }

    @Override
    public WeixinPayElement getPayElement(String appid) {
        return this.elements.get(appid);
    }

    public void setPayElement(String appid, WeixinPayElement element) {
        this.elements.put(appid, element);
    }

    public boolean existsPayElement(String appid) {
        return this.elements != null && this.elements.containsKey(appid);
    }

    @Override
    public PayPreResponse prepay(PayPreRequest request) {
        request.checkVaild();
        PayPreResponse result = new PayPreResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            result.setAppid(element.appid);
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (request.getAttach() != null) {
                map.putAll(request.getAttach());
            }
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("body", request.getPaybody());
            map.put("out_trade_no", request.getPayno());
            map.put("total_fee", "" + request.getPaymoney());
            map.put("spbill_create_ip", request.getClientAddr());
            map.put("time_expire", String.format(format, System.currentTimeMillis() + (long)(request.getTimeoutms() * 60 * 1000)));
            map.put("notify_url", request.notifyurl != null && !request.notifyurl.isEmpty() ? request.notifyurl : element.notifyurl);
            map.put("trade_type", request.getPayway() == 40 ? "JSAPI" : "APP");
            if (request.getPayway() == 40 && !map.containsKey("openid")) {
                return result.retcode(20010021);
            }
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            if (!"SUCCESS".equals(resultmap.get("return_code"))) {
                return result.retcode(20010001);
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
            String noncestr = Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime());
            TreeMap<String, String> retmap = new TreeMap<String, String>();
            if (request.getPayway() == 40) {
                retmap.put("appId", element.appid);
                retmap.put("timeStamp", timestamp);
                retmap.put("nonceStr", noncestr);
                retmap.put("package", "prepay_id=" + resultmap.get("prepay_id"));
                retmap.put("signType", "MD5");
                retmap.put("paySign", this.createSign(element, retmap));
            } else {
                retmap.put("appid", element.appid);
                retmap.put("partnerid", element.merchno);
                retmap.put("prepayid", resultmap.get("prepay_id"));
                retmap.put("timestamp", timestamp);
                retmap.put("noncestr", noncestr);
                retmap.put("package", "Sign=WXPay");
                retmap.put("sign", this.createSign(element, retmap));
            }
            result.setResult(retmap);
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "prepay_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayNotifyResponse notify(PayNotifyRequest request) {
        WeixinPayElement element;
        request.checkVaild();
        PayNotifyResponse result = new PayNotifyResponse();
        result.setPaytype(request.getPaytype());
        String rstext = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
        Map<String, String> map = WeiXinPayService.formatXMLToMap(request.getText());
        String appid = request.getAppid();
        if (appid == null || appid.isEmpty()) {
            appid = map.getOrDefault("appid", "");
        }
        if ((element = this.elements.get(appid)) == null) {
            return result.retcode(20010003);
        }
        result.setPayno(map.getOrDefault("out_trade_no", ""));
        result.setThirdpayno(map.getOrDefault("transaction_id", ""));
        if ("NOTPAY".equals(map.get("return_code"))) {
            return result.retcode(20010005).notifytext("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
        }
        if (!"SUCCESS".equals(map.get("return_code"))) {
            return result.retcode(20010002).notifytext("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
        }
        if (!(map instanceof SortedMap)) {
            map = new TreeMap<String, String>(map);
        }
        if (!this.checkSign(element, map)) {
            return result.retcode(20010011).notifytext("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
        }
        String state = map.get("trade_state");
        if (state == null && "SUCCESS".equals(map.get("result_code")) && Long.parseLong(map.get("total_fee")) > 0L) {
            state = "SUCCESS";
            result.setPayedmoney(Long.parseLong(map.get("total_fee")));
        }
        if (!"SUCCESS".equals(state)) {
            return result.retcode(20010002).notifytext("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
        }
        return result.notifytext("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
    }

    @Override
    public PayCreatResponse create(PayCreatRequest request) {
        request.checkVaild();
        PayCreatResponse result = new PayCreatResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (request.getAttach() != null) {
                map.putAll(request.getAttach());
            }
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("body", request.getPaybody());
            map.put("out_trade_no", request.getPayno());
            map.put("total_fee", "" + request.getPaymoney());
            map.put("spbill_create_ip", request.getClientAddr());
            map.put("time_expire", String.format(format, System.currentTimeMillis() + (long)(request.getPaytimeout() * 1000)));
            map.put("notify_url", element.notifyurl);
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            if (!"SUCCESS".equals(resultmap.get("return_code"))) {
                return result.retcode(20010001);
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            TreeMap<String, String> rmap = new TreeMap<String, String>();
            result.setResult(rmap);
            rmap.put("appId", element.appid);
            rmap.put("timeStamp", Long.toString(System.currentTimeMillis() / 1000L));
            rmap.put("nonceStr", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            rmap.put("package", "prepay_id=" + resultmap.get("prepay_id"));
            rmap.put("signType", "MD5");
            rmap.put("paySign", this.createSign(element, rmap));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "create_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayQueryResponse query(PayRequest request) {
        request.checkVaild();
        PayQueryResponse result = new PayQueryResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("out_trade_no", request.getPayno());
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://api.mch.weixin.qq.com/pay/orderquery", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            result.setResult(resultmap);
            String state = resultmap.getOrDefault("trade_state", "");
            if (state.isEmpty() && "SUCCESS".equals(resultmap.get("result_code")) && Long.parseLong(resultmap.get("total_fee")) > 0L) {
                state = "SUCCESS";
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (state.isEmpty()) {
                this.logger.warning("weixin.pay.query = " + resultmap);
            }
            short paystatus = 40;
            switch (state) {
                case "SUCCESS": {
                    paystatus = 30;
                    break;
                }
                case "NOTPAY": {
                    paystatus = 10;
                    break;
                }
                case "CLOSED": {
                    paystatus = 90;
                    break;
                }
                case "REVOKED": {
                    paystatus = 95;
                    break;
                }
                case "USERPAYING": {
                    paystatus = 20;
                    break;
                }
                case "PAYERROR": {
                    paystatus = 40;
                }
            }
            result.setPaystatus(paystatus);
            result.setThirdpayno(resultmap.getOrDefault("transaction_id", ""));
            result.setPayedmoney(Long.parseLong(resultmap.getOrDefault("total_fee", "0")));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "query_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayResponse close(PayCloseRequest request) {
        request.checkVaild();
        PayResponse result = new PayResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("out_trade_no", request.getPayno());
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://api.mch.weixin.qq.com/pay/closeorder", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            if (!"SUCCESS".equals(resultmap.get("return_code"))) {
                return result.retcode(20010001);
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            result.setResult(resultmap);
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "close_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse refund(PayRefundRequest request) {
        request.checkVaild();
        PayRefundResponse result = new PayRefundResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("out_trade_no", request.getPayno());
            map.put("total_fee", "" + request.getPaymoney());
            map.put("out_refund_no", request.getRefundno());
            map.put("refund_fee", "" + request.getRefundmoney());
            map.put("op_user_id", element.merchno);
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((SSLContext)element.paySSLContext, (String)"https://api.mch.weixin.qq.com/secapi/pay/refund", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            if (!"SUCCESS".equals(resultmap.get("return_code"))) {
                return result.retcode(20010013);
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            result.setRefundedmoney(Long.parseLong(resultmap.get("refund_fee")));
        }
        catch (Exception e) {
            result.setRetcode(20010013);
            this.logger.log(Level.WARNING, "refund_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse queryRefund(PayRequest request) {
        request.checkVaild();
        PayRefundResponse result = new PayRefundResponse();
        try {
            WeixinPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("appid", element.appid);
            map.put("mch_id", element.merchno);
            map.put("out_trade_no", request.getPayno());
            map.put("nonce_str", Long.toHexString(System.currentTimeMillis()) + Long.toHexString(System.nanoTime()));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://api.mch.weixin.qq.com/pay/refundquery", (String)WeiXinPayService.formatMapToXML(map));
            result.setResponsetext(responseText);
            Map<String, String> resultmap = WeiXinPayService.formatXMLToMap(responseText);
            result.setResult(resultmap);
            if (!"SUCCESS".equals(resultmap.get("return_code"))) {
                return result.retcode(20010001);
            }
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            result.setResult(resultmap);
            result.setRefundedmoney(Long.parseLong(resultmap.get("refund_fee_$n")));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "query_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    protected String createSign(AbstractPayService.PayElement element, Map<String, ?> map) throws Exception {
        StringBuilder sb = new StringBuilder();
        map.forEach((x, y) -> {
            if (!((String)y).isEmpty()) {
                sb.append((String)x).append('=').append(y).append('&');
            }
        });
        sb.append("key=").append(((WeixinPayElement)element).signkey);
        return Utility.binToHexString((byte[])MessageDigest.getInstance("MD5").digest(sb.toString().getBytes())).toUpperCase();
    }

    @Override
    protected boolean checkSign(AbstractPayService.PayElement element, Map<String, ?> map) {
        if (!(map instanceof SortedMap)) {
            map = new TreeMap(map);
        }
        String sign = (String)map.remove("sign");
        StringBuilder sb = new StringBuilder();
        map.forEach((x, y) -> {
            if (!((String)y).isEmpty()) {
                sb.append((String)x).append('=').append(y).append('&');
            }
        });
        sb.append("key=").append(((WeixinPayElement)element).signkey);
        try {
            return sign.equals(Utility.binToHexString((byte[])MessageDigest.getInstance("MD5").digest(sb.toString().getBytes())).toUpperCase());
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static String formatMapToXML(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        map.forEach((x, y) -> sb.append('<').append((String)x).append('>').append(y.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;")).append("</").append((String)x).append('>'));
        sb.append("</xml>");
        return sb.toString();
    }

    public static Map<String, String> formatXMLToMap(String xml) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Matcher m = PAYXML.matcher(xml.substring(xml.indexOf(62) + 1));
        while (m.find()) {
            String val = m.group(2);
            if (val.startsWith("<![CDATA[")) {
                val = val.substring("<![CDATA[".length(), val.length() - 3);
            }
            map.put(m.group(1), val);
        }
        return map;
    }

    public static class WeixinPayElement
    extends AbstractPayService.PayElement {
        public String merchno = "";
        public String submerchno = "";
        public String appid = "";
        public String signkey = "";
        public String certpwd = "";
        public String certpath = "";
        public String certbase64 = "";
        protected SSLContext paySSLContext;

        public static Map<String, WeixinPayElement> create(Logger logger, Properties properties, File home) {
            String def_appid = properties.getProperty("pay.weixin.appid", "").trim();
            String def_merchno = properties.getProperty("pay.weixin.merchno", "").trim();
            String def_submerchno = properties.getProperty("pay.weixin.submerchno", "").trim();
            String def_notifyurl = properties.getProperty("pay.weixin.notifyurl", "").trim();
            String def_signkey = properties.getProperty("pay.weixin.signkey", "").trim();
            String def_certpwd = properties.getProperty("pay.weixin.certpwd", "").trim();
            String def_certpath = properties.getProperty("pay.weixin.certpath", "").trim();
            String def_certbase64 = properties.getProperty("pay.weixin.certbase64", "").trim();
            HashMap<String, WeixinPayElement> map = new HashMap<String, WeixinPayElement>();
            properties.keySet().stream().filter(x -> x.toString().startsWith("pay.weixin.") && x.toString().endsWith(".appid")).forEach(appid_key -> {
                String prefix = appid_key.toString().substring(0, appid_key.toString().length() - ".appid".length());
                String appid = properties.getProperty(prefix + ".appid", def_appid).trim();
                String merchno = properties.getProperty(prefix + ".merchno", def_merchno).trim();
                String submerchno = properties.getProperty(prefix + ".submerchno", def_submerchno).trim();
                String notifyurl = properties.getProperty(prefix + ".notifyurl", def_notifyurl).trim();
                String signkey = properties.getProperty(prefix + ".signkey", def_signkey).trim();
                String certpwd = properties.getProperty(prefix + ".certpwd", def_certpwd).trim();
                String certpath = properties.getProperty(prefix + ".certpath", def_certpath).trim();
                String certbase64 = properties.getProperty(prefix + ".certbase64", def_certbase64).trim();
                if (appid.isEmpty() || merchno.isEmpty() || notifyurl.isEmpty() || signkey.isEmpty() || certpath.isEmpty() && certbase64.isEmpty()) {
                    logger.log(Level.WARNING, properties + "; has illegal weixinpay conf by prefix" + prefix);
                    return;
                }
                WeixinPayElement element = new WeixinPayElement();
                element.appid = appid;
                element.merchno = merchno;
                element.submerchno = submerchno;
                element.notifyurl = notifyurl;
                element.signkey = signkey;
                element.certpwd = certpwd;
                element.certpath = certpath;
                element.certbase64 = certbase64;
                if (element.initElement(logger, home)) {
                    map.put(appid, element);
                    if (def_appid.equals(appid)) {
                        map.put("", element);
                    }
                }
            });
            return map;
        }

        @Override
        public boolean initElement(Logger logger, File home) {
            try {
                InputStream in;
                if (this.certbase64 != null && !this.certbase64.isEmpty()) {
                    in = new ByteArrayInputStream(Base64.getDecoder().decode(this.certbase64));
                } else {
                    File file = this.certpath.indexOf(47) == 0 || this.certpath.indexOf(58) > 0 ? new File(this.certpath) : new File(home, "conf/" + this.certpath);
                    InputStream inputStream = in = file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.certpath);
                }
                if (in == null) {
                    return false;
                }
                this.setPaySSLContext(in);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "init weixinpay sslcontext error", e);
                return false;
            }
        }

        public void setPaySSLContext(InputStream in) throws Exception {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(in, this.certpwd.toCharArray());
            in.close();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.certpwd.toCharArray());
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            ctx.init(keyManagerFactory.getKeyManagers(), null, null);
            this.paySSLContext = ctx;
        }

        @Override
        public String toString() {
            return JsonConvert.root().convertTo((Object)this);
        }
    }
}

