/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Local;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Comment;
import org.redkale.util.Utility;
import org.redkalex.pay.AbstractPayService;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;

@Local
@AutoLoad(value=false)
public class UnionPayService
extends AbstractPayService {
    protected static final String format = "%1$tY%1$tm%1$td%1$tH%1$tM%1$tS";
    protected Map<String, UnionPayElement> elements = new HashMap<String, UnionPayElement>();
    @Resource(name="APP_HOME")
    protected File home;
    @Resource(name="property.pay.union.conf")
    protected String conf = "config.properties";
    @Resource
    protected JsonConvert convert;

    public void init(AnyValue conf) {
        if (this.convert == null) {
            this.convert = JsonConvert.root();
        }
        this.reloadConfig((short)12);
    }

    @Override
    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public boolean supportPayType(short paytype) {
        return paytype == 12 && !this.elements.isEmpty();
    }

    @Override
    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public void reloadConfig(short paytype) {
        if (this.conf != null && !this.conf.isEmpty()) {
            try {
                FileInputStream in;
                File file = this.conf.indexOf(47) == 0 || this.conf.indexOf(58) > 0 ? new File(this.conf) : new File(this.home, "conf/" + this.conf);
                InputStream inputStream = in = file.isFile() && file.canRead() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.conf);
                if (in == null) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                this.elements = UnionPayElement.create(this.logger, properties, this.home);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "init alipay conf error", e);
            }
        }
    }

    public void setPayElements(Map<String, UnionPayElement> elements) {
        this.elements = elements;
    }

    public void putPayElements(Map<String, UnionPayElement> elements) {
        this.elements.putAll(elements);
    }

    @Override
    public UnionPayElement getPayElement(String appid) {
        return this.elements.get(appid);
    }

    public void setPayElement(String appid, UnionPayElement element) {
        this.elements.put(appid, element);
    }

    public boolean existsPayElement(String appid) {
        return this.elements != null && this.elements.containsKey(appid);
    }

    public static void main(String[] args) throws Throwable {
        UnionPayService service = new UnionPayService();
        service.init(null);
        PayCreatRequest creatRequest = new PayCreatRequest();
        creatRequest.setPaytype((short)12);
        creatRequest.setPayno("Redkale100000001");
        creatRequest.setPaymoney(10L);
        creatRequest.setPaytitle("\u4e00\u65a4\u7ea2\u83dc\u82d4");
        creatRequest.setPaybody("\u4e00\u65a4\u7ea2\u83dc\u82d4");
        creatRequest.setClientAddr(Utility.localInetAddress().getHostAddress());
        PayCreatResponse creatResponse = service.create(creatRequest);
        System.out.println((Object)creatResponse);
        PayRequest queryRequest = new PayRequest();
        queryRequest.setPaytype((short)12);
        queryRequest.setPayno(creatRequest.getPayno());
    }

    @Override
    public PayPreResponse prepay(PayPreRequest request) {
        request.checkVaild();
        PayPreResponse result = new PayPreResponse();
        try {
            UnionPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            result.setAppid(element.appid);
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (request.getAttach() != null) {
                map.putAll(request.getAttach());
            }
            map.put("version", element.version);
            map.put("encoding", "UTF-8");
            map.put("signMethod", "01");
            map.put("txnType", "01");
            map.put("txnSubType", "01");
            map.put("bizType", "000201");
            map.putIfAbsent("channelType", "08");
            map.put("merId", element.merchno);
            map.put("certId", element.signcertid);
            map.put("accessType", "0");
            map.put("orderId", request.getPayno());
            map.put("txnTime", String.format(format, System.currentTimeMillis()));
            map.put("accType", "01");
            map.put("txnAmt", "" + request.getPaymoney());
            map.put("currencyCode", "156");
            map.put("backUrl", request.notifyurl != null && !request.notifyurl.isEmpty() ? request.notifyurl : element.notifyurl);
            map.put("signature", this.createSign(element, map));
            result.responsetext = Utility.postHttpContent((String)element.createurl, (String)this.joinMap(map));
            Map<String, String> resultmap = this.formatTextToMap(result.responsetext);
            result.setResult(resultmap);
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (!"00".equalsIgnoreCase(resultmap.get("respCode"))) {
                return result.retcode(20010001).retinfo(resultmap.get("respMsg"));
            }
            TreeMap<String, String> rmap = new TreeMap<String, String>();
            rmap.put("content", resultmap.getOrDefault("tn", ""));
            result.setResult(rmap);
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "prepay_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayNotifyResponse notify(PayNotifyRequest request) {
        request.checkVaild();
        PayNotifyResponse result = new PayNotifyResponse();
        result.setPaytype(request.getPaytype());
        String rstext = "success";
        Map<String, String> map = request.getAttach();
        result.setPayno(map.getOrDefault("orderId", ""));
        result.setThirdpayno(map.getOrDefault("queryId", ""));
        UnionPayElement element = this.elements.get(request.getAppid());
        if (element == null) {
            return result.retcode(20010003);
        }
        if (!this.checkSign(element, map)) {
            return result.retcode(20010011);
        }
        if ("70".equals(map.get("respCode"))) {
            return result.retcode(20010005).notifytext(map.getOrDefault("respMsg", "unpay"));
        }
        if (!"00".equalsIgnoreCase(map.get("respCode")) || Long.parseLong(map.getOrDefault("txnAmt", "0")) < 1L) {
            return result.retcode(20010001).retinfo(map.getOrDefault("respMsg", null));
        }
        result.setPayedmoney(Long.parseLong(map.get("txnAmt")));
        return result.notifytext("success");
    }

    @Override
    public PayCreatResponse create(PayCreatRequest request) {
        request.checkVaild();
        PayCreatResponse result = new PayCreatResponse();
        try {
            UnionPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (request.getAttach() != null) {
                map.putAll(request.getAttach());
            }
            map.put("version", element.version);
            map.put("encoding", "UTF-8");
            map.put("signMethod", "01");
            map.put("txnType", "01");
            map.put("txnSubType", "01");
            map.put("bizType", "000201");
            map.putIfAbsent("channelType", "08");
            map.put("merId", element.merchno);
            map.put("certId", element.signcertid);
            map.put("accessType", "0");
            map.put("orderId", request.getPayno());
            map.put("txnTime", String.format(format, System.currentTimeMillis()));
            map.put("accType", "01");
            map.put("txnAmt", "" + request.getPaymoney());
            map.put("currencyCode", "156");
            if (!element.notifyurl.isEmpty()) {
                map.put("backUrl", element.notifyurl);
            }
            map.put("signature", this.createSign(element, map));
            result.responsetext = Utility.postHttpContent((String)element.createurl, (String)this.joinMap(map));
            Map<String, String> resultmap = this.formatTextToMap(result.responsetext);
            result.setResult(resultmap);
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (!"00".equalsIgnoreCase(resultmap.get("respCode"))) {
                return result.retcode(20010001).retinfo(resultmap.get("respMsg"));
            }
            result.setThirdpayno(resultmap.getOrDefault("queryId", ""));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "create_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayQueryResponse query(PayRequest request) {
        request.checkVaild();
        PayQueryResponse result = new PayQueryResponse();
        try {
            UnionPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("version", element.version);
            map.put("encoding", "UTF-8");
            map.put("signMethod", "01");
            map.put("txnType", "00");
            map.put("txnSubType", "00");
            map.put("bizType", "000201");
            map.put("merId", element.merchno);
            map.put("certId", element.signcertid);
            map.put("accessType", "0");
            map.put("orderId", request.getPayno());
            map.put("txnTime", String.format(format, System.currentTimeMillis()));
            map.put("signature", this.createSign(element, map));
            result.responsetext = Utility.postHttpContent((String)element.queryurl, (String)this.joinMap(map));
            Map<String, String> resultmap = this.formatTextToMap(result.responsetext);
            result.setResult(resultmap);
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (!"00".equalsIgnoreCase(resultmap.get("respCode"))) {
                return result.retcode(20010001).retinfo(resultmap.get("respMsg"));
            }
            short paystatus = 40;
            switch (resultmap.get("origRespCode")) {
                case "00": {
                    paystatus = 30;
                    break;
                }
                case "WAIT_BUYER_PAY": {
                    paystatus = 10;
                    break;
                }
                case "TRADE_CLOSED": {
                    paystatus = 90;
                    break;
                }
                case "TRADE_FINISHED": {
                    paystatus = 30;
                }
            }
            result.setPaystatus(paystatus);
            result.setThirdpayno(resultmap.getOrDefault("queryId", ""));
            result.setPayedmoney((long)(Double.parseDouble(resultmap.getOrDefault("txnAmt", "0.0")) * 100.0));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "query_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayResponse close(PayCloseRequest request) {
        request.checkVaild();
        PayResponse result = new PayResponse();
        try {
            UnionPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("version", element.version);
            map.put("encoding", "UTF-8");
            map.put("signMethod", "01");
            map.put("txnType", "31");
            map.put("txnSubType", "00");
            map.put("bizType", "000201");
            map.putIfAbsent("channelType", "08");
            map.put("merId", element.merchno);
            map.put("certId", element.signcertid);
            map.put("accessType", "0");
            map.put("orderId", request.getPayno());
            map.put("txnTime", String.format(format, System.currentTimeMillis()));
            map.put("accType", "01");
            map.put("txnAmt", "" + request.getPaymoney());
            map.put("currencyCode", "156");
            map.put("origQryId", request.getThirdpayno());
            if (!element.notifyurl.isEmpty()) {
                map.put("backUrl", element.notifyurl);
            }
            map.put("signature", this.createSign(element, map));
            result.responsetext = Utility.postHttpContent((String)element.closeurl, (String)this.joinMap(map));
            Map<String, String> resultmap = this.formatTextToMap(result.responsetext);
            result.setResult(resultmap);
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (!"00".equalsIgnoreCase(resultmap.get("respCode"))) {
                return result.retcode(20010001).retinfo(resultmap.get("respMsg"));
            }
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "close_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse refund(PayRefundRequest request) {
        request.checkVaild();
        PayRefundResponse result = new PayRefundResponse();
        try {
            UnionPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("version", element.version);
            map.put("encoding", "UTF-8");
            map.put("signMethod", "01");
            map.put("txnType", "04");
            map.put("txnSubType", "00");
            map.put("bizType", "000201");
            map.putIfAbsent("channelType", "08");
            map.put("merId", element.merchno);
            map.put("certId", element.signcertid);
            map.put("accessType", "0");
            map.put("orderId", request.getPayno());
            map.put("txnTime", String.format(format, System.currentTimeMillis()));
            map.put("txnAmt", "" + request.getRefundmoney());
            map.put("currencyCode", "156");
            map.put("origQryId", request.getThirdpayno());
            if (!element.notifyurl.isEmpty()) {
                map.put("backUrl", element.notifyurl);
            }
            map.put("signature", this.createSign(element, map));
            result.responsetext = Utility.postHttpContent((String)element.closeurl, (String)this.joinMap(map));
            Map<String, String> resultmap = this.formatTextToMap(result.responsetext);
            result.setResult(resultmap);
            if (!this.checkSign(element, resultmap)) {
                return result.retcode(20010011);
            }
            if (!"00".equalsIgnoreCase(resultmap.get("respCode"))) {
                return result.retcode(20010001).retinfo(resultmap.get("respMsg"));
            }
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "close_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse queryRefund(PayRequest request) {
        PayQueryResponse queryResponse = this.query(request);
        PayRefundResponse response = new PayRefundResponse();
        response.setRetcode(queryResponse.getRetcode());
        response.setRetinfo(queryResponse.getRetinfo());
        response.setResponsetext(queryResponse.getResponsetext());
        response.setResult(queryResponse.getResult());
        if (queryResponse.isSuccess()) {
            response.setRefundedmoney(Long.parseLong((String)((Map)response.getResult()).get("txnAmt")));
        }
        return response;
    }

    protected Map<String, String> formatTextToMap(String responseText) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String item : responseText.split("&")) {
            int pos = item.indexOf(61);
            if (pos < 0) {
                return map;
            }
            map.put(item.substring(0, pos), item.substring(pos + 1));
        }
        return map;
    }

    @Override
    protected String createSign(AbstractPayService.PayElement element, Map<String, ?> map) throws Exception {
        byte[] digest = MessageDigest.getInstance("SHA-1").digest(this.joinMap(map).getBytes("UTF-8"));
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(((UnionPayElement)element).priKey);
        signature.update(Utility.binToHexString((byte[])digest).getBytes("UTF-8"));
        return URLEncoder.encode(Base64.getEncoder().encodeToString(signature.sign()), "UTF-8");
    }

    @Override
    protected boolean checkSign(AbstractPayService.PayElement element, Map<String, ?> map) {
        if (!((UnionPayElement)element).verifycertid.equals(map.get("certId"))) {
            return false;
        }
        if (!(map instanceof SortedMap)) {
            map = new TreeMap(map);
        }
        try {
            byte[] sign = Base64.getDecoder().decode(((String)map.remove("signature")).getBytes("UTF-8"));
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(this.joinMap(map).getBytes("UTF-8"));
            byte[] digest = Utility.binToHexString((byte[])sha1).getBytes("UTF-8");
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(((UnionPayElement)element).pubKey);
            signature.update(digest);
            return signature.verify(sign);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        try {
            Class<?> clazz;
            Class<?> providerClazz = clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            if (Security.getProvider("BC") != null) {
                Security.removeProvider("BC");
            }
            Security.addProvider((Provider)providerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class UnionPayElement
    extends AbstractPayService.PayElement {
        public String merchno = "";
        public String appid = "";
        public String version = "5.0.0";
        public String createurl = "https://gateway.95516.com/gateway/api/appTransReq.do";
        public String queryurl = "https://gateway.95516.com/gateway/api/queryTrans.do";
        public String refundurl = "https://gateway.95516.com/gateway/api/backTransReq.do";
        public String closeurl = "https://gateway.95516.com/gateway/api/backTransReq.do";
        public String signcertpwd = "";
        public String signcertpath = "";
        public String signcertbase64 = "";
        public String verifycertpath = "";
        public String verifycertbase64 = "";
        protected String signcertid = "";
        protected String verifycertid = "";
        protected PrivateKey priKey;
        protected PublicKey pubKey;

        @Override
        public boolean initElement(Logger logger, File home) {
            try {
                InputStream verifyin;
                InputStream signin;
                if (this.signcertbase64 != null && !this.signcertbase64.isEmpty()) {
                    signin = new ByteArrayInputStream(Base64.getDecoder().decode(this.signcertbase64));
                } else {
                    File signfile = this.signcertpath.indexOf(47) == 0 || this.signcertpath.indexOf(58) > 0 ? new File(this.signcertpath) : new File(home, "conf/" + this.signcertpath);
                    InputStream inputStream = signin = signfile.isFile() ? new FileInputStream(signfile) : UnionPayService.class.getResourceAsStream("/META-INF/" + this.signcertpath);
                }
                if (signin == null) {
                    return false;
                }
                if (this.verifycertbase64 != null && !this.verifycertbase64.isEmpty()) {
                    verifyin = new ByteArrayInputStream(Base64.getDecoder().decode(this.verifycertbase64));
                } else {
                    File verifyfile = this.verifycertpath.indexOf(47) == 0 || this.verifycertpath.indexOf(58) > 0 ? new File(this.verifycertpath) : new File(home, "conf/" + this.verifycertpath);
                    InputStream inputStream = verifyin = verifyfile.isFile() ? new FileInputStream(verifyfile) : UnionPayService.class.getResourceAsStream("/META-INF/" + this.verifycertpath);
                }
                if (verifyin == null) {
                    return false;
                }
                KeyStore keyStore = Security.getProvider("BC") == null ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("PKCS12", "BC");
                keyStore.load(signin, this.signcertpwd.toCharArray());
                signin.close();
                Enumeration<String> aliasenum = keyStore.aliases();
                String keyAlias = aliasenum.hasMoreElements() ? aliasenum.nextElement() : null;
                this.priKey = (PrivateKey)keyStore.getKey(keyAlias, this.signcertpwd.toCharArray());
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
                this.signcertid = cert.getSerialNumber().toString();
                CertificateFactory cf = Security.getProvider("BC") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", "BC");
                X509Certificate verifycert = (X509Certificate)cf.generateCertificate(verifyin);
                verifyin.close();
                this.verifycertid = verifycert.getSerialNumber().toString();
                this.pubKey = verifycert.getPublicKey();
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "init unionpay certcontext error", e);
                return false;
            }
        }

        public static Map<String, UnionPayElement> create(Logger logger, Properties properties, File home) {
            String def_merchno = properties.getProperty("pay.union.merchno", "").trim();
            String def_appid = properties.getProperty("pay.union.appid", def_merchno).trim();
            String def_version = properties.getProperty("pay.union.version", "5.0.0").trim();
            String def_notifyurl = properties.getProperty("pay.union.notifyurl", "").trim();
            String def_createurl = properties.getProperty("pay.union.createurl", "https://gateway.95516.com/gateway/api/appTransReq.do").trim();
            String def_queryurl = properties.getProperty("pay.union.queryurl", "https://gateway.95516.com/gateway/api/queryTrans.do").trim();
            String def_refundurl = properties.getProperty("pay.union.refundurl", "https://gateway.95516.com/gateway/api/backTransReq.do").trim();
            String def_closeurl = properties.getProperty("pay.union.closeurl", "https://gateway.95516.com/gateway/api/backTransReq.do").trim();
            String def_signcertpwd = properties.getProperty("pay.union.signcertpwd", "").trim();
            String def_signcertpath = properties.getProperty("pay.union.signcertpath", "").trim();
            String def_signcertbase64 = properties.getProperty("pay.union.signcertbase64", "").trim();
            String def_verifycertpath = properties.getProperty("pay.union.verifycertpath", "").trim();
            String def_verifycertbase64 = properties.getProperty("pay.union.verifycertbase64", "").trim();
            HashMap<String, UnionPayElement> map = new HashMap<String, UnionPayElement>();
            properties.keySet().stream().filter(x -> x.toString().startsWith("pay.union.") && x.toString().endsWith(".merchno")).forEach(merchno_key -> {
                String prefix = merchno_key.toString().substring(0, merchno_key.toString().length() - ".merchno".length());
                String merchno = properties.getProperty(prefix + ".merchno", def_merchno).trim();
                String appid = properties.getProperty(prefix + ".appid", def_appid).trim();
                String version = properties.getProperty(prefix + ".version", def_version).trim();
                String notifyurl = properties.getProperty(prefix + ".notifyurl", def_notifyurl).trim();
                String createurl = properties.getProperty(prefix + ".createurl", def_createurl).trim();
                String queryurl = properties.getProperty(prefix + ".queryurl", def_queryurl).trim();
                String refundurl = properties.getProperty(prefix + ".refundurl", def_refundurl).trim();
                String closeurl = properties.getProperty(prefix + ".closeurl", def_closeurl).trim();
                String signcertpwd = properties.getProperty(prefix + ".signcertpwd", def_signcertpwd).trim();
                String signcertpath = properties.getProperty(prefix + ".signcertpath", def_signcertpath).trim();
                String signcertbase64 = properties.getProperty(prefix + ".signcertbase64", def_signcertbase64).trim();
                String verifycertpath = properties.getProperty(prefix + ".verifycertpath", def_verifycertpath).trim();
                String verifycertbase64 = properties.getProperty(prefix + ".verifycertbase64", def_verifycertbase64).trim();
                if (merchno.isEmpty() || notifyurl.isEmpty() || signcertpath.isEmpty() && signcertbase64.isEmpty()) {
                    logger.log(Level.WARNING, properties + "; has illegal unionpay conf by prefix" + prefix);
                    return;
                }
                UnionPayElement element = new UnionPayElement();
                element.merchno = merchno;
                element.appid = appid;
                element.version = version;
                element.notifyurl = notifyurl;
                element.createurl = createurl;
                element.queryurl = queryurl;
                element.refundurl = refundurl;
                element.closeurl = closeurl;
                element.signcertpwd = signcertpwd;
                element.signcertpath = signcertpath;
                element.signcertbase64 = signcertbase64;
                element.verifycertpath = verifycertpath;
                element.verifycertbase64 = verifycertbase64;
                if (element.initElement(logger, home)) {
                    map.put(appid, element);
                    if (def_appid.equals(appid)) {
                        map.put("", element);
                    }
                }
            });
            return map;
        }
    }
}

