/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.redkale.service.Local;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Comment;
import org.redkale.util.ResourceFactory;
import org.redkalex.pay.AbstractPayService;
import org.redkalex.pay.AliPayService;
import org.redkalex.pay.DIYPayService;
import org.redkalex.pay.EhkingPayService;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;
import org.redkalex.pay.UnionPayService;
import org.redkalex.pay.WeiXinPayService;

@Local
@AutoLoad(value=false)
public class PayService
extends AbstractPayService {
    @Resource
    private UnionPayService unionPayService;
    @Resource
    private WeiXinPayService weiXinPayService;
    @Resource
    private AliPayService aliPayService;
    @Resource
    private EhkingPayService ehkingPayService;
    @Resource
    private ResourceFactory resourceFactory;
    private Map<Short, AbstractPayService> diyPayServiceMap = new HashMap<Short, AbstractPayService>();

    public void init(AnyValue config) {
        List services = this.resourceFactory.query((name, service) -> {
            if (!(service instanceof AbstractPayService)) {
                return false;
            }
            DIYPayService diy = service.getClass().getAnnotation(DIYPayService.class);
            if (diy == null) {
                return false;
            }
            if (diy.paytype() < 50) {
                throw new RuntimeException("DIYPayService.paytype must be greater than 50");
            }
            return true;
        });
        for (AbstractPayService service2 : services) {
            DIYPayService diy = service2.getClass().getAnnotation(DIYPayService.class);
            this.diyPayServiceMap.put(diy.paytype(), service2);
        }
    }

    @Override
    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public boolean supportPayType(short paytype) {
        if (paytype == 12) {
            return this.unionPayService.supportPayType(paytype);
        }
        if (paytype == 13) {
            return this.weiXinPayService.supportPayType(paytype);
        }
        if (paytype == 14) {
            return this.aliPayService.supportPayType(paytype);
        }
        if (paytype == 15) {
            return this.ehkingPayService.supportPayType(paytype);
        }
        AbstractPayService service = this.diyPayServiceMap.get(paytype);
        if (service == null) {
            return false;
        }
        return service.supportPayType(paytype);
    }

    @Override
    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public void reloadConfig(short paytype) {
        if (paytype == 12) {
            this.unionPayService.reloadConfig(paytype);
        } else if (paytype == 13) {
            this.weiXinPayService.reloadConfig(paytype);
        } else if (paytype == 14) {
            this.aliPayService.reloadConfig(paytype);
        } else if (paytype == 15) {
            this.ehkingPayService.reloadConfig(paytype);
        } else {
            AbstractPayService service = this.diyPayServiceMap.get(paytype);
            if (service != null) {
                service.reloadConfig(paytype);
            }
        }
    }

    @Override
    public PayPreResponse prepay(PayPreRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.prepay(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.prepay(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.prepay(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.prepay(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.prepay(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayNotifyResponse notify(PayNotifyRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.notify(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.notify(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.notify(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.notify(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.notify(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayCreatResponse create(PayCreatRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.create(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.create(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.create(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.create(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.create(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayQueryResponse query(PayRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.query(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.query(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.query(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.query(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.query(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayResponse close(PayCloseRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.close(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.close(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.close(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.close(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.close(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayRefundResponse refund(PayRefundRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.refund(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.refund(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.refund(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.refund(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.refund(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    public PayRefundResponse queryRefund(PayRequest request) {
        if (request.paytype == 12) {
            return this.unionPayService.queryRefund(request);
        }
        if (request.paytype == 13) {
            return this.weiXinPayService.queryRefund(request);
        }
        if (request.paytype == 14) {
            return this.aliPayService.queryRefund(request);
        }
        if (request.paytype == 15) {
            return this.ehkingPayService.queryRefund(request);
        }
        AbstractPayService diyPayService = this.diyPayServiceMap.get(request.paytype);
        if (diyPayService != null) {
            return diyPayService.queryRefund(request);
        }
        throw new RuntimeException(request + ".paytype is illegal");
    }

    @Override
    protected String createSign(AbstractPayService.PayElement element, Map<String, ?> map) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected boolean checkSign(AbstractPayService.PayElement element, Map<String, ?> map) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractPayService.PayElement getPayElement(String appid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getNotifyurl(short paytype, String appid) {
        AbstractPayService.PayElement element = null;
        if (paytype == 12) {
            element = this.unionPayService.getPayElement(appid);
        } else if (paytype == 13) {
            element = this.weiXinPayService.getPayElement(appid);
        } else if (paytype == 14) {
            element = this.aliPayService.getPayElement(appid);
        } else if (paytype == 15) {
            element = this.ehkingPayService.getPayElement(appid);
        } else {
            AbstractPayService diyPayService = this.diyPayServiceMap.get(paytype);
            if (diyPayService == null) {
                throw new RuntimeException("paytype = " + paytype + " is illegal");
            }
            element = diyPayService.getPayElement(appid);
        }
        return element == null ? "" : element.notifyurl;
    }

    public AbstractPayService getDIYPayService(short paytype) {
        return this.diyPayServiceMap.get(paytype);
    }

    public UnionPayService getUnionPayService() {
        return this.unionPayService;
    }

    public WeiXinPayService getWeiXinPayService() {
        return this.weiXinPayService;
    }

    public AliPayService getAliPayService() {
        return this.aliPayService;
    }

    public EhkingPayService getEhkingPayService() {
        return this.ehkingPayService;
    }
}

