/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.redkale.service.RetLabel;
import org.redkale.service.RetResult;

public abstract class PayRetCodes {
    @RetLabel(value="\u652f\u4ed8\u5931\u8d25")
    public static final int RETPAY_PAY_ERROR = 20010001;
    @RetLabel(value="\u7b2c\u4e09\u65b9\u652f\u4ed8\u5931\u8d25")
    public static final int RETPAY_PAY_FAILED = 20010002;
    @RetLabel(value="\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38")
    public static final int RETPAY_CONF_ERROR = 20010003;
    @RetLabel(value="\u91cd\u590d\u652f\u4ed8")
    public static final int RETPAY_PAY_REPEAT = 20010004;
    @RetLabel(value="\u7b49\u5f85\u7528\u6237\u652f\u4ed8")
    public static final int RETPAY_PAY_WAITING = 20010005;
    @RetLabel(value="\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u7c7b\u578b")
    public static final int RETPAY_PAY_TYPEILLEGAL = 20010006;
    @RetLabel(value="\u652f\u4ed8\u8d85\u65f6")
    public static final int RETPAY_PAY_EXPIRED = 20010007;
    @RetLabel(value="\u4ea4\u6613\u7b7e\u540d\u88ab\u7be1\u6539")
    public static final int RETPAY_FALSIFY_ERROR = 20010011;
    @RetLabel(value="\u652f\u4ed8\u72b6\u6001\u5f02\u5e38")
    public static final int RETPAY_STATUS_ERROR = 20010012;
    @RetLabel(value="\u9000\u6b3e\u5f02\u5e38")
    public static final int RETPAY_REFUND_ERROR = 20010013;
    @RetLabel(value="\u7528\u6237\u6807\u8bc6\u7f3a\u5931")
    public static final int RETPAY_OPENID_ERROR = 20010021;
    protected static final Map<String, Map<Integer, String>> rets = RetLabel.RetLoader.loadMap(PayRetCodes.class);
    protected static final Map<Integer, String> defret = rets.get("");

    protected PayRetCodes() {
    }

    public static RetResult retResult(int retcode) {
        if (retcode == 0) {
            return RetResult.success();
        }
        return new RetResult(retcode, PayRetCodes.retInfo(retcode));
    }

    public static RetResult retResult(String locale, int retcode) {
        if (retcode == 0) {
            return RetResult.success();
        }
        return new RetResult(retcode, PayRetCodes.retInfo(locale, retcode));
    }

    public static RetResult retResult(int retcode, Object ... args) {
        if (retcode == 0) {
            return RetResult.success();
        }
        if (args == null || args.length < 1) {
            return new RetResult(retcode, PayRetCodes.retInfo(retcode));
        }
        String info = MessageFormat.format(PayRetCodes.retInfo(retcode), args);
        return new RetResult(retcode, info);
    }

    public static RetResult retResult(String locale, int retcode, Object ... args) {
        if (retcode == 0) {
            return RetResult.success();
        }
        if (args == null || args.length < 1) {
            return new RetResult(retcode, PayRetCodes.retInfo(locale, retcode));
        }
        String info = MessageFormat.format(PayRetCodes.retInfo(locale, retcode), args);
        return new RetResult(retcode, info);
    }

    public static <T> CompletableFuture<RetResult<T>> retResultFuture(int retcode) {
        return CompletableFuture.completedFuture(PayRetCodes.retResult(retcode));
    }

    public static <T> CompletableFuture<RetResult<T>> retResultFuture(String locale, int retcode) {
        return CompletableFuture.completedFuture(PayRetCodes.retResult(locale, retcode));
    }

    public static <T> CompletableFuture<RetResult<T>> retResultFuture(int retcode, Object ... args) {
        return CompletableFuture.completedFuture(PayRetCodes.retResult(retcode, args));
    }

    public static <T> CompletableFuture<RetResult<T>> retResultFuture(String locale, int retcode, Object ... args) {
        return CompletableFuture.completedFuture(PayRetCodes.retResult(locale, retcode, args));
    }

    public static RetResult set(RetResult result, int retcode, Object ... args) {
        if (retcode == 0) {
            return result.retcode(0).retinfo("");
        }
        if (args == null || args.length < 1) {
            return result.retcode(retcode).retinfo(PayRetCodes.retInfo(retcode));
        }
        String info = MessageFormat.format(PayRetCodes.retInfo(retcode), args);
        return result.retcode(retcode).retinfo(info);
    }

    public static RetResult set(RetResult result, String locale, int retcode, Object ... args) {
        if (retcode == 0) {
            return result.retcode(0).retinfo("");
        }
        if (args == null || args.length < 1) {
            return result.retcode(retcode).retinfo(PayRetCodes.retInfo(locale, retcode));
        }
        String info = MessageFormat.format(PayRetCodes.retInfo(locale, retcode), args);
        return result.retcode(retcode).retinfo(info);
    }

    public static String retInfo(int retcode) {
        if (retcode == 0) {
            return "Success";
        }
        return defret.getOrDefault(retcode, "Error");
    }

    public static String retInfo(String locale, int retcode) {
        if (locale == null || locale.isEmpty()) {
            return PayRetCodes.retInfo(retcode);
        }
        if (retcode == 0) {
            return "Success";
        }
        String key = locale == null ? "" : locale;
        Map<Integer, String> map = rets.get(key);
        if (map == null) {
            return "Error";
        }
        return map.getOrDefault(retcode, "Error");
    }
}

