/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.util.Map;
import java.util.TreeMap;
import org.redkale.convert.json.JsonFactory;

public class PayNotifyRequest {
    protected String appid = "";
    protected short paytype;
    protected String text;
    protected Map<String, String> attach;

    public PayNotifyRequest() {
    }

    public PayNotifyRequest(short paytype, String text) {
        this.paytype = paytype;
        this.text = text;
    }

    public PayNotifyRequest(short paytype, Map<String, String> attach) {
        this.paytype = paytype;
        this.attach = attach;
    }

    public void checkVaild() {
        if (this.paytype < 1) {
            throw new RuntimeException("paytype is illegal");
        }
        if (this.paytype == 14 && (this.appid == null || this.appid.isEmpty())) {
            throw new RuntimeException("appid is illegal");
        }
        if ((this.text == null || this.text.isEmpty()) && (this.attach == null || this.attach.isEmpty())) {
            throw new RuntimeException("text and attach both is empty");
        }
    }

    public Map<String, String> attach(String key, Object value) {
        if (this.attach == null) {
            this.attach = new TreeMap<String, String>();
        }
        this.attach.put(key, String.valueOf(value));
        return this.attach;
    }

    public String attach(String name) {
        return this.attach == null ? null : this.attach.get(name);
    }

    public String attach(String name, String defValue) {
        return this.attach == null ? defValue : this.attach.getOrDefault(name, defValue);
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public short getPaytype() {
        return this.paytype;
    }

    public void setPaytype(short paytype) {
        this.paytype = paytype;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, String> getAttach() {
        return this.attach;
    }

    public void setAttach(Map<String, String> attach) {
        this.attach = attach;
    }

    public String toString() {
        return JsonFactory.root().getConvert().convertTo((Object)this);
    }

    @Deprecated
    public Map<String, String> getMap() {
        return this.attach;
    }

    @Deprecated
    public void setMap(Map<String, String> map) {
        this.attach = map;
    }
}

