/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Local;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Comment;
import org.redkale.util.Utility;
import org.redkalex.pay.AbstractPayService;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;

@Local
@AutoLoad(value=false)
public class EhkingPayService
extends AbstractPayService {
    private static final Map<String, String> header = new HashMap<String, String>();
    protected static final String format = "%1$tY%1$tm%1$td%1$tH%1$tM%1$tS";
    protected Map<String, EhkingPayElement> elements = new HashMap<String, EhkingPayElement>();
    @Resource(name="APP_HOME")
    protected File home;
    @Resource(name="property.pay.ehking.conf")
    protected String conf = "config.properties";
    @Resource
    protected JsonConvert convert;

    public void init(AnyValue conf) {
        if (this.convert == null) {
            this.convert = JsonConvert.root();
        }
        this.reloadConfig((short)15);
    }

    @Override
    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public boolean supportPayType(short paytype) {
        return paytype == 15 && !this.elements.isEmpty();
    }

    @Override
    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public void reloadConfig(short paytype) {
        if (this.conf != null && !this.conf.isEmpty()) {
            try {
                FileInputStream in;
                File file = this.conf.indexOf(47) == 0 || this.conf.indexOf(58) > 0 ? new File(this.conf) : new File(this.home, "conf/" + this.conf);
                InputStream inputStream = in = file.isFile() && file.canRead() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.conf);
                if (in == null) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                this.elements = EhkingPayElement.create(this.logger, properties, this.home);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "init ehkingpay conf error", e);
            }
        }
    }

    public void setPayElements(Map<String, EhkingPayElement> elements) {
        this.elements = elements;
    }

    public void putPayElements(Map<String, EhkingPayElement> elements) {
        this.elements.putAll(elements);
    }

    @Override
    public EhkingPayElement getPayElement(String appid) {
        return this.elements.get(appid);
    }

    public void setPayElement(String appid, EhkingPayElement element) {
        this.elements.put(appid, element);
    }

    public boolean existsPayElement(String appid) {
        return this.elements != null && this.elements.containsKey(appid);
    }

    @Override
    public PayPreResponse prepay(PayPreRequest request) {
        request.checkVaild();
        PayPreResponse result = new PayPreResponse();
        try {
            EhkingPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            result.setAppid(element.appid);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> pd = new LinkedHashMap<String, String>();
            pd.put("name", request.getPaytitle());
            pd.put("quantity", "1");
            pd.put("amount", "" + request.getPaymoney());
            pd.put("receiver", request.getAttach("receiver", ""));
            map.put("merchantId", element.merchno);
            map.put("orderAmount", "" + request.getPaymoney());
            map.put("orderCurrency", "CNY");
            map.put("requestId", request.getPayno());
            String notifyurl = request.notifyurl != null && !request.notifyurl.isEmpty() ? request.notifyurl : element.notifyurl;
            map.put("notifyUrl", notifyurl);
            map.put("callbackUrl", request.getAttach("gotourl", notifyurl));
            map.put("remark", request.getPayno());
            map.put("paymentModeCode", request.getAttach("bankcode", ""));
            map.put("forUse", request.getAttach("foruse", ""));
            map.put("productDetails", new Object[]{pd});
            map.put("payer", new LinkedHashMap());
            map.put("bankCard", new LinkedHashMap());
            map.put("hmac", this.createSign((AbstractPayService.PayElement)element, map));
            result.responsetext = Utility.postHttpContent((String)element.createurl, header, (String)this.convert.convertTo(map));
            Map resultmap = (Map)this.convert.convertFrom(JsonConvert.TYPE_MAP_STRING_STRING, result.responsetext.replace("\"violations\":{", "\"violations\":'{").replace("}}", "}}'"));
            result.setResult(resultmap);
            LinkedHashMap<String, String> rsmap = new LinkedHashMap<String, String>();
            rsmap.put("merchantId", resultmap.getOrDefault("merchantId", ""));
            rsmap.put("requestId", resultmap.getOrDefault("requestId", ""));
            rsmap.put("status", resultmap.getOrDefault("status", ""));
            rsmap.put("redirectUrl", resultmap.getOrDefault("redirectUrl", ""));
            rsmap.put("hmac", resultmap.getOrDefault("hmac", ""));
            if (!this.checkSign(element, rsmap)) {
                return result.retcode(20010011);
            }
            if (!"SUCCESS".equalsIgnoreCase((String)resultmap.get("status")) && !"REDIRECT".equalsIgnoreCase((String)resultmap.get("status"))) {
                return result.retcode(20010001);
            }
            TreeMap<String, String> rmap = new TreeMap<String, String>();
            rmap.put("redirect", resultmap.getOrDefault("redirectUrl", ""));
            rmap.put("requestid", resultmap.getOrDefault("requestId", ""));
            result.setThirdpayno((String)rmap.get("requestid"));
            result.setResult(rmap);
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "prepay_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayNotifyResponse notify(PayNotifyRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PayCreatResponse create(PayCreatRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PayQueryResponse query(PayRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PayResponse close(PayCloseRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PayRefundResponse refund(PayRefundRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PayRefundResponse queryRefund(PayRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String createSign(AbstractPayService.PayElement element, String aValue) {
        MessageDigest md;
        byte[] value = aValue.getBytes(UTF8);
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(((EhkingPayElement)element).inpad);
        md.update(value);
        byte[] dg = md.digest();
        md.reset();
        md.update(((EhkingPayElement)element).outpad);
        md.update(dg, 0, 16);
        dg = md.digest();
        return Utility.binToHexString((byte[])dg);
    }

    @Override
    protected String createSign(AbstractPayService.PayElement element, Map<String, ?> map0) {
        Map<String, ?> map = map0;
        String hmac = (String)map.remove("hmac");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> en : map.entrySet()) {
            if ("productDetails".equals(en.getKey())) {
                Map pd = (Map)((Object[])en.getValue())[0];
                pd.forEach((x, y) -> sb.append((String)y));
                continue;
            }
            if (!(en.getValue() instanceof String)) continue;
            sb.append(en.getValue());
        }
        String rs = this.createSign(element, sb.toString());
        if (hmac != null) {
            map.put("hmac", hmac);
        }
        return rs;
    }

    @Override
    protected boolean checkSign(AbstractPayService.PayElement element, Map<String, ?> map0) {
        Map<String, ?> map = map0;
        return map.getOrDefault("hmac", "").equalsIgnoreCase(this.createSign(element, map));
    }

    static {
        header.put("Content-Type", "application/vnd.ehking-v1.0+json");
    }

    public static class EhkingPayElement
    extends AbstractPayService.PayElement {
        public String merchno = "";
        public String appid = "";
        public String merchkey = "";
        public String notifyurl = "";
        public String createurl = "https://api.ehking.com/onlinePay/order";
        public String queryurl = "https://api.ehking.com/onlinePay/query";
        public String refundurl = "https://xxxx";
        public String closeurl = "https://xxxx";
        protected byte[] inpad;
        protected byte[] outpad;

        @Override
        public boolean initElement(Logger logger, File home) {
            byte[] k_ipad = new byte[64];
            byte[] k_opad = new byte[64];
            byte[] keyb = this.merchkey.getBytes(AbstractPayService.UTF8);
            Arrays.fill(k_ipad, keyb.length, 64, (byte)54);
            Arrays.fill(k_opad, keyb.length, 64, (byte)92);
            for (int i = 0; i < keyb.length; ++i) {
                k_ipad[i] = (byte)(keyb[i] ^ 0x36);
                k_opad[i] = (byte)(keyb[i] ^ 0x5C);
            }
            this.inpad = k_ipad;
            this.outpad = k_opad;
            return true;
        }

        public static Map<String, EhkingPayElement> create(Logger logger, Properties properties, File home) {
            String def_merchno = properties.getProperty("pay.ehking.merchno", "").trim();
            String def_appid = properties.getProperty("pay.ehking.appid", def_merchno).trim();
            String def_merchkey = properties.getProperty("pay.ehking.merchkey", "").trim();
            String def_notifyurl = properties.getProperty("pay.ehking.notifyurl", "").trim();
            String def_createurl = properties.getProperty("pay.ehking.createurl", "https://api.ehking.com/onlinePay/order").trim();
            String def_queryurl = properties.getProperty("pay.ehking.queryurl", "https://api.ehking.com/onlinePay/query").trim();
            String def_refundurl = properties.getProperty("pay.ehking.refundurl", "https://xxxx").trim();
            String def_closeurl = properties.getProperty("pay.ehking.closeurl", "https://xxxx").trim();
            HashMap<String, EhkingPayElement> map = new HashMap<String, EhkingPayElement>();
            properties.keySet().stream().filter(x -> x.toString().startsWith("pay.ehking.") && x.toString().endsWith(".merchno")).forEach(merchno_key -> {
                String prefix = merchno_key.toString().substring(0, merchno_key.toString().length() - ".merchno".length());
                String merchno = properties.getProperty(prefix + ".merchno", def_merchno).trim();
                String appid = properties.getProperty(prefix + ".appid", def_appid).trim();
                String merchkey = properties.getProperty(prefix + ".merchkey", def_merchkey).trim();
                String notifyurl = properties.getProperty(prefix + ".notifyurl", def_notifyurl).trim();
                String createurl = properties.getProperty(prefix + ".createurl", def_createurl).trim();
                String queryurl = properties.getProperty(prefix + ".queryurl", def_queryurl).trim();
                String refundurl = properties.getProperty(prefix + ".refundurl", def_refundurl).trim();
                String closeurl = properties.getProperty(prefix + ".closeurl", def_closeurl).trim();
                if (merchno.isEmpty() || notifyurl.isEmpty()) {
                    logger.log(Level.WARNING, properties + "; has illegal ehkingpay conf by prefix" + prefix);
                    return;
                }
                EhkingPayElement element = new EhkingPayElement();
                element.merchno = merchno;
                element.appid = appid;
                element.merchkey = merchkey;
                element.notifyurl = notifyurl;
                element.createurl = createurl;
                element.queryurl = queryurl;
                element.refundurl = refundurl;
                element.closeurl = closeurl;
                if (element.initElement(logger, null)) {
                    map.put(appid, element);
                    if (def_appid.equals(appid)) {
                        map.put("", element);
                    }
                }
            });
            return map;
        }
    }
}

