/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.redkale.convert.json.JsonConvert;
import org.redkale.convert.json.JsonFactory;
import org.redkale.service.Local;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Comment;
import org.redkale.util.Utility;
import org.redkalex.pay.AbstractPayService;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;

@Local
@AutoLoad(value=false)
@Comment(value="\u652f\u4ed8\u5b9d\u652f\u4ed8\u670d\u52a1")
public class AliPayService
extends AbstractPayService {
    protected static final String format = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS";
    protected Map<String, AliPayElement> elements = new HashMap<String, AliPayElement>();
    @Resource(name="property.pay.alipay.conf")
    protected String conf = "config.properties";
    @Resource(name="APP_HOME")
    protected File home;
    @Resource
    protected JsonConvert convert;

    public void init(AnyValue conf) {
        if (this.convert == null) {
            this.convert = JsonConvert.root();
        }
        this.reloadConfig((short)14);
    }

    @Override
    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public boolean supportPayType(short paytype) {
        return paytype == 14 && !this.elements.isEmpty();
    }

    @Override
    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public void reloadConfig(short paytype) {
        if (this.conf != null && !this.conf.isEmpty()) {
            try {
                FileInputStream in;
                File file = this.conf.indexOf(47) == 0 || this.conf.indexOf(58) > 0 ? new File(this.conf) : new File(this.home, "conf/" + this.conf);
                InputStream inputStream = in = file.isFile() && file.canRead() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + this.conf);
                if (in == null) {
                    return;
                }
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                this.elements = AliPayElement.create(this.logger, properties);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "init alipay conf error", e);
            }
        }
    }

    public void setPayElements(Map<String, AliPayElement> elements) {
        this.elements = elements;
    }

    public void putPayElements(Map<String, AliPayElement> elements) {
        this.elements.putAll(elements);
    }

    @Override
    public AliPayElement getPayElement(String appid) {
        return this.elements.get(appid);
    }

    public void setPayElement(String appid, AliPayElement element) {
        this.elements.put(appid, element);
    }

    public boolean existsPayElement(String appid) {
        return this.elements != null && this.elements.containsKey(appid);
    }

    @Override
    public PayPreResponse prepay(PayPreRequest request) {
        request.checkVaild();
        PayPreResponse result = new PayPreResponse();
        try {
            AliPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            result.setAppid(element.appid);
            String param = "partner=\"" + element.merchno + "\"";
            param = param + "&seller_id=\"" + element.sellerid + "\"";
            param = param + "&out_trade_no=\"" + request.getPayno() + "\"";
            param = param + "&subject=\"" + request.getPaytitle() + "\"";
            param = param + "&body=\"" + request.getPaybody() + "\"";
            param = param + "&total_fee=\"" + (double)request.getPaymoney() / 100.0 + "\"";
            param = param + "&notify_url=\"" + (request.notifyurl != null && !request.notifyurl.isEmpty() ? request.notifyurl : element.notifyurl) + "\"";
            param = param + "&service=\"mobile.securitypay.pay\"";
            param = param + "&payment_type=\"1\"";
            param = param + "&_input_charset=\"utf-8\"";
            param = param + "&it_b_pay=\"" + request.getTimeoutms() + "m\"";
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(element.priKey);
            signature.update(param.getBytes("UTF-8"));
            param = param + "&sign=\"" + URLEncoder.encode(Base64.getEncoder().encodeToString(signature.sign()), "UTF-8") + "\"";
            param = param + "&sign_type=\"RSA\"";
            TreeMap<String, String> rmap = new TreeMap<String, String>();
            rmap.put("content", param);
            result.setResult(rmap);
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "prepay_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayNotifyResponse notify(PayNotifyRequest request) {
        request.checkVaild();
        PayNotifyResponse result = new PayNotifyResponse();
        result.setPaytype(request.getPaytype());
        String rstext = "success";
        Map<String, String> map = request.getAttach();
        AliPayElement element = this.elements.get(request.getAppid());
        if (element == null) {
            return result.retcode(20010003);
        }
        result.setPayno(map.getOrDefault("out_trade_no", ""));
        result.setThirdpayno(map.getOrDefault("trade_no", ""));
        if (!this.checkSign((AbstractPayService.PayElement)element, map)) {
            return result.retcode(20010011);
        }
        String state = map.getOrDefault("trade_status", "");
        if ("WAIT_BUYER_PAY".equals(state)) {
            return result.retcode(20010005);
        }
        if (!"TRADE_SUCCESS".equals(state)) {
            return result.retcode(20010002);
        }
        result.setPayedmoney((long)(Float.parseFloat(map.get("total_fee")) * 100.0f));
        return result.notifytext("success");
    }

    @Override
    public PayCreatResponse create(PayCreatRequest request) {
        request.checkVaild();
        PayCreatResponse result = new PayCreatResponse();
        try {
            AliPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("app_id", element.appid);
            map.put("method", "alipay.trade.create");
            map.put("format", "JSON");
            map.put("charset", element.charset);
            map.put("sign_type", "RSA");
            map.put("timestamp", String.format(format, System.currentTimeMillis()));
            map.put("version", "1.0");
            if (element.notifyurl != null && !element.notifyurl.isEmpty()) {
                map.put("notify_url", element.notifyurl);
            }
            TreeMap<String, String> biz_content = new TreeMap<String, String>();
            if (request.getAttach() != null) {
                biz_content.putAll(request.getAttach());
            }
            biz_content.put("out_trade_no", request.getPayno());
            biz_content.putIfAbsent("scene", "bar_code");
            biz_content.put("total_amount", "" + (double)request.getPaymoney() / 100.0);
            biz_content.put("subject", "" + request.getPaytitle());
            biz_content.put("body", request.getPaybody());
            map.put("biz_content", this.convert.convertTo(biz_content));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://openapi.alipay.com/gateway.do", (Charset)Charset.forName(element.charset), (String)this.joinMap(map));
            result.setResponsetext(responseText);
            InnerCreateResponse resp = (InnerCreateResponse)this.convert.convertFrom(InnerCreateResponse.class, responseText);
            resp.responseText = responseText;
            if (!this.checkSign((AbstractPayService.PayElement)element, resp)) {
                return result.retcode(20010011);
            }
            Map<String, String> resultmap = resp.alipay_trade_create_response;
            result.setResult(resultmap);
            if (!"SUCCESS".equalsIgnoreCase(resultmap.get("msg"))) {
                return result.retcode(20010001).retinfo(resultmap.get("sub_msg"));
            }
            result.setThirdpayno(resultmap.getOrDefault("trade_no", ""));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "create_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayQueryResponse query(PayRequest request) {
        request.checkVaild();
        PayQueryResponse result = new PayQueryResponse();
        try {
            AliPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("app_id", element.appid);
            map.put("sign_type", "RSA");
            map.put("charset", element.charset);
            map.put("format", "json");
            map.put("version", "1.0");
            map.put("timestamp", String.format(format, System.currentTimeMillis()));
            map.put("method", "alipay.trade.query");
            TreeMap<String, String> biz_content = new TreeMap<String, String>();
            biz_content.put("out_trade_no", request.getPayno());
            map.put("biz_content", this.convert.convertTo(biz_content));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://openapi.alipay.com/gateway.do", (Charset)Charset.forName(element.charset), (String)this.joinMap(map));
            result.setResponsetext(responseText);
            InnerQueryResponse resp = (InnerQueryResponse)this.convert.convertFrom(InnerQueryResponse.class, responseText);
            resp.responseText = responseText;
            if (!this.checkSign((AbstractPayService.PayElement)element, resp)) {
                return result.retcode(20010011);
            }
            Map<String, String> resultmap = resp.alipay_trade_query_response;
            result.setResult(resultmap);
            if (!"SUCCESS".equalsIgnoreCase(resultmap.get("msg"))) {
                return result.retcode(20010001).retinfo(resultmap.get("sub_msg"));
            }
            short paystatus = 40;
            switch (resultmap.get("trade_status")) {
                case "TRADE_SUCCESS": {
                    paystatus = 30;
                    break;
                }
                case "WAIT_BUYER_PAY": {
                    paystatus = 10;
                    break;
                }
                case "TRADE_CLOSED": {
                    paystatus = 90;
                    break;
                }
                case "TRADE_FINISHED": {
                    paystatus = 30;
                }
            }
            result.setPaystatus(paystatus);
            result.setThirdpayno(resultmap.getOrDefault("trade_no", ""));
            result.setPayedmoney((long)(Double.parseDouble(resultmap.get("receipt_amount")) * 100.0));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "query_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayResponse close(PayCloseRequest request) {
        request.checkVaild();
        PayResponse result = new PayResponse();
        try {
            AliPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("app_id", element.appid);
            map.put("sign_type", "RSA");
            map.put("charset", element.charset);
            map.put("format", "json");
            map.put("version", "1.0");
            if (element.notifyurl != null && !element.notifyurl.isEmpty()) {
                map.put("notify_url", element.notifyurl);
            }
            map.put("timestamp", String.format(format, System.currentTimeMillis()));
            map.put("method", "alipay.trade.close");
            TreeMap<String, String> biz_content = new TreeMap<String, String>();
            biz_content.put("out_trade_no", request.getPayno());
            map.put("biz_content", this.convert.convertTo(biz_content));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://openapi.alipay.com/gateway.do", (Charset)Charset.forName(element.charset), (String)this.joinMap(map));
            result.setResponsetext(responseText);
            InnerCloseResponse resp = (InnerCloseResponse)this.convert.convertFrom(InnerCloseResponse.class, responseText);
            resp.responseText = responseText;
            if (!this.checkSign((AbstractPayService.PayElement)element, resp)) {
                return result.retcode(20010011);
            }
            Map<String, String> resultmap = resp.alipay_trade_close_response;
            result.setResult(resultmap);
            if (!"SUCCESS".equalsIgnoreCase(resultmap.get("msg"))) {
                return result.retcode(20010001).retinfo(resultmap.get("sub_msg"));
            }
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "close_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse refund(PayRefundRequest request) {
        request.checkVaild();
        PayRefundResponse result = new PayRefundResponse();
        try {
            AliPayElement element = this.elements.get(request.getAppid());
            if (element == null) {
                return result.retcode(20010003);
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("app_id", element.appid);
            map.put("sign_type", "RSA");
            map.put("charset", element.charset);
            map.put("format", "json");
            map.put("version", "1.0");
            map.put("timestamp", String.format(format, System.currentTimeMillis()));
            map.put("method", "alipay.trade.refund");
            TreeMap<String, String> biz_content = new TreeMap<String, String>();
            biz_content.put("out_trade_no", request.getPayno());
            biz_content.put("refund_amount", "" + (double)request.getRefundmoney() / 100.0);
            map.put("biz_content", this.convert.convertTo(biz_content));
            map.put("sign", this.createSign(element, map));
            String responseText = Utility.postHttpContent((String)"https://openapi.alipay.com/gateway.do", (Charset)Charset.forName(element.charset), (String)this.joinMap(map));
            result.setResponsetext(responseText);
            InnerCloseResponse resp = (InnerCloseResponse)this.convert.convertFrom(InnerCloseResponse.class, responseText);
            resp.responseText = responseText;
            if (!this.checkSign((AbstractPayService.PayElement)element, resp)) {
                return result.retcode(20010011);
            }
            Map<String, String> resultmap = resp.alipay_trade_close_response;
            result.setResult(resultmap);
            if (!"SUCCESS".equalsIgnoreCase(resultmap.get("msg"))) {
                return result.retcode(20010001).retinfo(resultmap.get("sub_msg"));
            }
            result.setRefundedmoney((long)(Double.parseDouble(resultmap.get("refund_fee")) * 100.0));
        }
        catch (Exception e) {
            result.setRetcode(20010001);
            this.logger.log(Level.WARNING, "refund_pay_error req=" + request + ", resp=" + result.responsetext, e);
        }
        return result;
    }

    @Override
    public PayRefundResponse queryRefund(PayRequest request) {
        PayQueryResponse queryResponse = this.query(request);
        PayRefundResponse response = new PayRefundResponse();
        response.setRetcode(queryResponse.getRetcode());
        response.setRetinfo(queryResponse.getRetinfo());
        response.setResponsetext(queryResponse.getResponsetext());
        response.setResult(queryResponse.getResult());
        if (queryResponse.isSuccess()) {
            response.setRefundedmoney((long)(Double.parseDouble((String)((Map)response.getResult()).get("receipt_amount")) * 100.0));
        }
        return response;
    }

    protected boolean checkSign(AbstractPayService.PayElement element, InnerResponse response) throws Exception {
        if (((AliPayElement)element).pubKey == null) {
            return true;
        }
        String text = response.responseText;
        text = text.substring(text.indexOf(58) + 1, text.indexOf(",\"sign\""));
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(((AliPayElement)element).pubKey);
        signature.update(text.getBytes(((AliPayElement)element).charset));
        return signature.verify(Base64.getDecoder().decode(response.sign.getBytes()));
    }

    @Override
    protected String createSign(AbstractPayService.PayElement element, Map<String, ?> map) throws Exception {
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(((AliPayElement)element).priKey);
        signature.update(this.joinMap(map).getBytes(((AliPayElement)element).charset));
        return URLEncoder.encode(Base64.getEncoder().encodeToString(signature.sign()), "UTF-8");
    }

    @Override
    protected boolean checkSign(AbstractPayService.PayElement element, Map<String, ?> map0) {
        if (((AliPayElement)element).pubKey == null) {
            return true;
        }
        Map<String, ?> map = map0;
        String sign = (String)map.remove("sign");
        if (sign == null) {
            return false;
        }
        String sign_type = (String)map.remove("sign_type");
        String text = this.joinMap(map);
        map.put("sign", sign);
        if (sign_type != null) {
            map.put("sign_type", sign_type);
        }
        try {
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(((AliPayElement)element).pubKey);
            signature.update(text.getBytes("UTF-8"));
            return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class AliPayElement
    extends AbstractPayService.PayElement {
        public String merchno = "";
        public String sellerid = "";
        public String charset = "UTF-8";
        public String appid = "";
        public String signcertkey = "";
        public String verifycertkey = "";
        protected PrivateKey priKey;
        protected PublicKey pubKey;

        public static Map<String, AliPayElement> create(Logger logger, Properties properties) {
            String def_appid = properties.getProperty("pay.alipay.appid", "").trim();
            String def_merchno = properties.getProperty("pay.alipay.merchno", "").trim();
            String def_sellerid = properties.getProperty("pay.alipay.sellerid", "").trim();
            String def_charset = properties.getProperty("pay.alipay.charset", "UTF-8").trim();
            String def_notifyurl = properties.getProperty("pay.alipay.notifyurl", "").trim();
            String def_signcertkey = properties.getProperty("pay.alipay.signcertkey", "").trim();
            String def_verifycertkey = properties.getProperty("pay.alipay.verifycertkey", "").trim();
            HashMap<String, AliPayElement> map = new HashMap<String, AliPayElement>();
            properties.keySet().stream().filter(x -> x.toString().startsWith("pay.alipay.") && x.toString().endsWith(".appid")).forEach(appid_key -> {
                String prefix = appid_key.toString().substring(0, appid_key.toString().length() - ".appid".length());
                String appid = properties.getProperty(prefix + ".appid", def_appid).trim();
                String merchno = properties.getProperty(prefix + ".merchno", def_merchno).trim();
                String sellerid = properties.getProperty(prefix + ".sellerid", def_sellerid).trim();
                String charset = properties.getProperty(prefix + ".charset", def_charset).trim();
                String notifyurl = properties.getProperty(prefix + ".notifyurl", def_notifyurl).trim();
                String signcertkey = properties.getProperty(prefix + ".signcertkey", def_signcertkey).trim();
                String verifycertkey = properties.getProperty(prefix + ".verifycertkey", def_verifycertkey).trim();
                if (appid.isEmpty() || merchno.isEmpty() || notifyurl.isEmpty() || signcertkey.isEmpty()) {
                    logger.log(Level.WARNING, properties + "; has illegal alipay conf by prefix" + prefix);
                    return;
                }
                AliPayElement element = new AliPayElement();
                element.appid = appid;
                element.merchno = merchno;
                element.sellerid = sellerid.isEmpty() ? merchno : sellerid;
                element.charset = charset;
                element.notifyurl = notifyurl;
                element.signcertkey = signcertkey;
                element.verifycertkey = verifycertkey;
                if (element.initElement(logger, null)) {
                    map.put(appid, element);
                    if (def_appid.equals(appid)) {
                        map.put("", element);
                    }
                }
            });
            return map;
        }

        @Override
        public boolean initElement(Logger logger, File home) {
            try {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                this.pubKey = this.verifycertkey != null && !this.verifycertkey.isEmpty() ? factory.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(this.verifycertkey))) : null;
                PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(this.signcertkey));
                this.priKey = factory.generatePrivate(priPKCS8);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "init alipay sslcontext error", e);
                return false;
            }
        }

        @Override
        public String toString() {
            return JsonConvert.root().convertTo((Object)this);
        }
    }

    public static class InnerResponse {
        public String responseText;
        public String sign;

        public String toString() {
            return JsonFactory.root().getConvert().convertTo((Object)this);
        }
    }

    public static class InnerCreateResponse
    extends InnerResponse {
        public Map<String, String> alipay_trade_create_response;
    }

    public static class InnerQueryResponse
    extends InnerResponse {
        public Map<String, String> alipay_trade_query_response;
    }

    public static class InnerCloseResponse
    extends InnerResponse {
        public Map<String, String> alipay_trade_close_response;
    }
}

