/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.pay;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Service;
import org.redkale.util.Comment;
import org.redkale.util.Utility;
import org.redkalex.pay.PayCloseRequest;
import org.redkalex.pay.PayCreatRequest;
import org.redkalex.pay.PayCreatResponse;
import org.redkalex.pay.PayNotifyRequest;
import org.redkalex.pay.PayNotifyResponse;
import org.redkalex.pay.PayPreRequest;
import org.redkalex.pay.PayPreResponse;
import org.redkalex.pay.PayQueryResponse;
import org.redkalex.pay.PayRefundRequest;
import org.redkalex.pay.PayRefundResponse;
import org.redkalex.pay.PayRequest;
import org.redkalex.pay.PayResponse;

@Comment(value="\u652f\u4ed8\u670d\u52a1\u62bd\u8c61\u7c7b")
public abstract class AbstractPayService
implements Service {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    protected final boolean fine = this.logger.isLoggable(Level.FINE);
    protected final boolean finer = this.logger.isLoggable(Level.FINER);
    protected final boolean finest = this.logger.isLoggable(Level.FINEST);

    @Comment(value="\u5224\u65ad\u662f\u5426\u652f\u6301\u6307\u5b9a\u652f\u4ed8\u7c7b\u578b")
    public abstract boolean supportPayType(short var1);

    @Comment(value="\u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e")
    public abstract void reloadConfig(short var1);

    @Comment(value="\u624b\u673a\u9884\u652f\u4ed8")
    public abstract PayPreResponse prepay(PayPreRequest var1);

    @Comment(value="\u624b\u673a\u652f\u4ed8\u56de\u8c03")
    public abstract PayNotifyResponse notify(PayNotifyRequest var1);

    @Comment(value="\u8bf7\u6c42\u652f\u4ed8")
    public abstract PayCreatResponse create(PayCreatRequest var1);

    @Comment(value="\u8bf7\u6c42\u67e5\u8be2")
    public abstract PayQueryResponse query(PayRequest var1);

    @Comment(value="\u8bf7\u6c42\u5173\u95ed")
    public abstract PayResponse close(PayCloseRequest var1);

    @Comment(value="\u8bf7\u6c42\u9000\u6b3e")
    public abstract PayRefundResponse refund(PayRefundRequest var1);

    @Comment(value="\u67e5\u8be2\u9000\u6b3e")
    public abstract PayRefundResponse queryRefund(PayRequest var1);

    @Comment(value="\u8ba1\u7b97\u7b7e\u540d")
    protected abstract String createSign(PayElement var1, Map<String, ?> var2) throws Exception;

    @Comment(value="\u9a8c\u8bc1\u7b7e\u540d")
    protected abstract boolean checkSign(PayElement var1, Map<String, ?> var2);

    @Comment(value="\u83b7\u53d6\u914d\u7f6e\u9879")
    public abstract PayElement getPayElement(String var1);

    @Comment(value="map\u5bf9\u8c61\u8f6c\u6362\u6210 key1=value1&key2=value2&key3=value3")
    protected String joinMap(Map<String, ?> map) {
        if (!(map instanceof SortedMap)) {
            map = new TreeMap(map);
        }
        return map.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
    }

    protected String urlEncodeUTF8(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return URLEncoder.encode(val.toString(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Throwable {
        File file = new File("apiclient_cert.p12");
        System.out.println(Base64.getEncoder().encodeToString(Utility.readBytesThenClose((InputStream)new FileInputStream(file))));
    }

    @Comment(value="\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u62bd\u8c61\u7c7b")
    public static abstract class PayElement {
        public String notifyurl = "";

        public abstract boolean initElement(Logger var1, File var2);

        public String toString() {
            return JsonConvert.root().convertTo((Object)this);
        }
    }
}

