/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.redkale.convert.ArrayEncoder;
import org.redkale.convert.CollectionEncoder;
import org.redkale.convert.EnMember;
import org.redkale.convert.Encodeable;
import org.redkale.convert.MapEncoder;
import org.redkale.convert.StreamEncoder;
import org.redkale.convert.Writer;
import org.redkale.util.ObjectPool;
import org.redkale.util.StringWrapper;
import org.redkale.util.Utility;
import org.redkalex.convert.pson.ProtobufFactory;

public class ProtobufWriter
extends Writer {
    private static final int defaultSize = Integer.getInteger("convert.protobuf.writer.buffer.defsize", 1024);
    private byte[] content;
    protected int count;
    protected boolean tiny;

    public static ObjectPool<ProtobufWriter> createPool(int max) {
        return new ObjectPool(max, params -> new ProtobufWriter(), null, t -> t.recycle());
    }

    protected ProtobufWriter(byte[] bs) {
        this.content = bs;
    }

    public ProtobufWriter() {
        this(defaultSize);
    }

    public ProtobufWriter(int size) {
        this.content = new byte[size > 128 ? size : 128];
    }

    public ByteBuffer[] toBuffers() {
        return new ByteBuffer[]{ByteBuffer.wrap(this.content, 0, this.count)};
    }

    public byte[] toArray() {
        if (this.count == this.content.length) {
            return this.content;
        }
        byte[] newdata = new byte[this.count];
        System.arraycopy(this.content, 0, newdata, 0, this.count);
        return newdata;
    }

    public final boolean tiny() {
        return this.tiny;
    }

    public ProtobufWriter tiny(boolean tiny) {
        this.tiny = tiny;
        return this;
    }

    protected int expand(int len) {
        int newcount = this.count + len;
        if (newcount <= this.content.length) {
            return 0;
        }
        byte[] newdata = new byte[Math.max(this.content.length * 3 / 2, newcount)];
        System.arraycopy(this.content, 0, newdata, 0, this.count);
        this.content = newdata;
        return 0;
    }

    public void writeTo(byte ch) {
        this.expand(1);
        this.content[this.count++] = ch;
    }

    public final void writeTo(byte ... chs) {
        this.writeTo(chs, 0, chs.length);
    }

    public void writeTo(byte[] chs, int start, int len) {
        this.expand(len);
        System.arraycopy(chs, start, this.content, this.count, len);
        this.count += len;
    }

    protected boolean recycle() {
        super.recycle();
        this.count = 0;
        this.specify = null;
        if (this.content.length > defaultSize) {
            this.content = new byte[defaultSize];
        }
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[count=" + this.count + "]";
    }

    public final int count() {
        return this.count;
    }

    public final void writeBoolean(boolean value) {
        this.writeTo(value ? (byte)1 : 0);
    }

    public void writeNull() {
    }

    public boolean needWriteClassName() {
        return false;
    }

    public void writeClassName(String clazz) {
    }

    public int writeObjectB(Object obj) {
        super.writeObjectB(obj);
        return -1;
    }

    public void writeObjectE(Object obj) {
    }

    public int writeArrayB(int size, Encodeable<Writer, Object> encoder, Object obj) {
        if (obj == null) {
            this.writeNull();
            return 0;
        }
        if (size < 1) {
            this.writeUInt32(0);
            return 0;
        }
        if (obj instanceof byte[]) {
            int length = ((byte[])obj).length;
            this.writeUInt32(length);
            this.writeTo((byte[])obj);
            return length;
        }
        Class<?> type = obj.getClass();
        ProtobufWriter tmp = new ProtobufWriter();
        if (type == boolean[].class) {
            for (boolean bl : (boolean[])obj) {
                tmp.writeBoolean(bl);
            }
        } else if (type == Boolean[].class) {
            for (Boolean bl : (Boolean[])obj) {
                tmp.writeBoolean(bl == null ? false : bl);
            }
        } else if (type == short[].class) {
            for (short s : (short[])obj) {
                tmp.writeShort(s);
            }
        } else if (type == Short[].class) {
            for (Short s : (Short[])obj) {
                tmp.writeShort(s == null ? (short)0 : s);
            }
        } else if (type == char[].class) {
            for (char c : (char[])obj) {
                tmp.writeChar(c);
            }
        } else if (type == Character[].class) {
            for (Character c : (Character[])obj) {
                tmp.writeChar(c == null ? (char)'\u0000' : c.charValue());
            }
        } else if (type == int[].class) {
            for (int n : (int[])obj) {
                tmp.writeInt(n);
            }
        } else if (type == Integer[].class) {
            for (Integer n : (Integer[])obj) {
                tmp.writeInt(n == null ? 0 : n);
            }
        } else if (type == float[].class) {
            for (float f : (float[])obj) {
                tmp.writeFloat(f);
            }
        } else if (type == Float[].class) {
            for (Float f : (Float[])obj) {
                tmp.writeFloat(f == null ? 0.0f : f.floatValue());
            }
        } else if (type == long[].class) {
            for (long l : (long[])obj) {
                tmp.writeLong(l);
            }
        } else if (type == Long[].class) {
            for (Long l : (Long[])obj) {
                tmp.writeLong(l == null ? 0L : l);
            }
        } else if (type == double[].class) {
            for (double d : (double[])obj) {
                tmp.writeDouble(d);
            }
        } else if (type == Double[].class) {
            for (Double d : (Double[])obj) {
                tmp.writeDouble(d == null ? 0.0 : d);
            }
        } else {
            return -1;
        }
        int n = tmp.count();
        this.writeUInt32(n);
        this.writeTo(tmp.toArray());
        return n;
    }

    public void writeArrayMark() {
    }

    public void writeArrayE() {
    }

    public int writeMapB(int size, Encodeable<Writer, Object> keyEncoder, Encodeable<Writer, Object> valueEncoder, Object obj) {
        return -1;
    }

    public void writeMapMark() {
    }

    public void writeMapE() {
    }

    public void writeFieldName(String fieldName, Type fieldType, int fieldPos) {
        this.writeUInt32(ProtobufFactory.getTag(fieldName, fieldType, fieldPos));
    }

    public void writeObjectField(EnMember member, Object obj) {
        Object value = member.getAttribute().get(obj);
        if (value == null) {
            return;
        }
        Encodeable encoder = member.getEncoder();
        if (encoder instanceof MapEncoder) {
            ((MapEncoder)encoder).convertTo((Writer)this, member, (Map)value);
        } else if (encoder instanceof ArrayEncoder) {
            ((ArrayEncoder)encoder).convertTo((Writer)this, member, (Object[])value);
        } else if (encoder instanceof CollectionEncoder) {
            ((CollectionEncoder)encoder).convertTo((Writer)this, member, (Collection)value);
        } else if (encoder instanceof StreamEncoder) {
            ((StreamEncoder)encoder).convertTo((Writer)this, member, (Stream)value);
        } else {
            this.writeFieldName(member);
            encoder.convertTo((Writer)this, value);
        }
        this.comma = true;
    }

    public void writeByte(byte value) {
        this.writeInt(value);
    }

    public final void writeByteArray(byte[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        if (this.writeArrayB(values.length, null, values) < 0) {
            boolean flag = false;
            for (byte v : values) {
                if (flag) {
                    this.writeArrayMark();
                }
                this.writeByte(v);
                flag = true;
            }
        }
        this.writeArrayE();
    }

    public void writeChar(char value) {
        this.writeInt(value);
    }

    public void writeShort(short value) {
        this.writeInt(value);
    }

    public void writeInt(int value) {
        this.writeUInt32(value << 1 ^ value >> 31);
    }

    public void writeLong(long value) {
        this.writeUInt64(value << 1 ^ value >> 63);
    }

    public void writeFloat(float value) {
        this.writeFixed32(Float.floatToRawIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeFixed64(Double.doubleToRawLongBits(value));
    }

    public void writeSmallString(String value) {
        this.writeString(value);
    }

    public void writeString(String value) {
        byte[] bs = Utility.encodeUTF8((String)value);
        this.writeUInt32(bs.length);
        this.writeTo(bs);
    }

    public void writeWrapper(StringWrapper value) {
        if (value != null) {
            this.writeString(value.getValue());
        }
    }

    protected void writeUInt32(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeTo((byte)value);
                return;
            }
            this.writeTo((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    protected void writeUInt64(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeTo((byte)value);
                return;
            }
            this.writeTo((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    protected void writeFixed32(int value) {
        this.writeTo((byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF));
    }

    protected void writeFixed64(long value) {
        this.writeTo((byte)((int)value & 0xFF), (byte)((int)(value >> 8) & 0xFF), (byte)((int)(value >> 16) & 0xFF), (byte)((int)(value >> 24) & 0xFF), (byte)((int)(value >> 32) & 0xFF), (byte)((int)(value >> 40) & 0xFF), (byte)((int)(value >> 48) & 0xFF), (byte)((int)(value >> 56) & 0xFF));
    }
}

