/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.redkale.convert.ConvertException;
import org.redkale.convert.DeMember;
import org.redkale.convert.Decodeable;
import org.redkale.convert.Reader;
import org.redkale.util.ObjectPool;
import org.redkalex.convert.pson.ProtobufArrayDecoder;

public class ProtobufReader
extends Reader {
    protected int position = -1;
    private byte[] content;
    protected int cachetag = Integer.MIN_VALUE;

    public static ObjectPool<ProtobufReader> createPool(int max) {
        return new ObjectPool(max, params -> new ProtobufReader(), null, t -> t.recycle());
    }

    public ProtobufReader() {
    }

    public ProtobufReader(byte[] bytes) {
        this.setBytes(bytes, 0, bytes.length);
    }

    public ProtobufReader(byte[] bytes, int start, int len) {
        this.setBytes(bytes, start, len);
    }

    public final void setBytes(byte[] bytes) {
        if (bytes == null) {
            this.position = 0;
        } else {
            this.setBytes(bytes, 0, bytes.length);
        }
    }

    public final void setBytes(byte[] bytes, int start, int len) {
        if (bytes == null) {
            this.position = 0;
        } else {
            this.content = bytes;
            this.position = start - 1;
        }
    }

    protected boolean recycle() {
        this.position = -1;
        this.content = null;
        return true;
    }

    public void close() {
        this.recycle();
    }

    public final void skipValue() {
        this.readTag();
    }

    public final String readObjectB(Class clazz) {
        return "";
    }

    public final void readObjectE(Class clazz) {
    }

    public final int readMapB(DeMember member, byte[] typevals, Decodeable keyDecoder, Decodeable valueDecoder) {
        return -2;
    }

    public final void readMapE() {
    }

    public final int readArrayB(DeMember member, byte[] typevals, Decodeable componentDecoder) {
        if (member == null || componentDecoder == null) {
            return -3;
        }
        Type type = componentDecoder.getType();
        if (!(type instanceof Class)) {
            return -3;
        }
        Class clazz = (Class)type;
        if (clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class || clazz == Integer.class || clazz == Float.class || clazz == Long.class || clazz == Double.class) {
            return -3;
        }
        return -2;
    }

    public final void readArrayE() {
    }

    public final void readBlank() {
    }

    public final int position() {
        return this.position;
    }

    public final int readMemberContentLength(DeMember member, Decodeable decoder) {
        if (member == null && decoder == null) {
            return -1;
        }
        if (member != null && !(member.getDecoder() instanceof ProtobufArrayDecoder)) {
            return -1;
        }
        return this.readRawVarint32();
    }

    public final DeMember readFieldName(DeMember[] members) {
        int tag = this.readTag();
        int pos = tag >>> 3;
        for (DeMember member : members) {
            if (member.getPosition() != pos) continue;
            return member;
        }
        this.backTag(tag);
        return null;
    }

    public final boolean readBoolean() {
        return this.readRawVarint64() != 0L;
    }

    public final byte readByte() {
        return (byte)this.readInt();
    }

    public final char readChar() {
        return (char)this.readInt();
    }

    public final short readShort() {
        return (short)this.readInt();
    }

    public final int readInt() {
        int n = this.readRawVarint32();
        return n >>> 1 ^ -(n & 1);
    }

    public final long readLong() {
        long n = this.readRawVarint64();
        return n >>> 1 ^ -(n & 1L);
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public final String readClassName() {
        return "";
    }

    public final String readSmallString() {
        return this.readString();
    }

    public final String readString() {
        return new String(this.readByteArray(), StandardCharsets.UTF_8);
    }

    protected final int readTag() {
        if (this.cachetag != Integer.MIN_VALUE) {
            int tag = this.cachetag;
            this.cachetag = Integer.MIN_VALUE;
            return tag;
        }
        return this.readRawVarint32();
    }

    protected final void backTag(int tag) {
        this.cachetag = tag;
    }

    protected byte currentByte() {
        return this.content[this.position];
    }

    public boolean hasNext(int startPosition, int contentLength) {
        if (startPosition >= 0 && contentLength >= 0) {
            return this.position < startPosition + contentLength;
        }
        return this.position + 1 < this.content.length;
    }

    public byte[] readByteArray() {
        int size = this.readRawVarint32();
        byte[] bs = new byte[size];
        System.arraycopy(this.content, this.position + 1, bs, 0, size);
        this.position += size;
        return bs;
    }

    protected int readRawVarint32() {
        block4: {
            int x;
            int tempPos;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.position;
                            if (tempPos + 1 == this.content.length) break block4;
                            if ((x = this.content[++tempPos]) >= 0) {
                                this.position = tempPos;
                                return x;
                            }
                            if (this.content.length - (tempPos + 1) < 9) break block4;
                            if ((x ^= this.content[++tempPos] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= this.content[++tempPos] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= this.content[++tempPos] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = this.content[++tempPos];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && this.content[++tempPos] < 0 && this.content[++tempPos] < 0 && this.content[++tempPos] < 0 && this.content[++tempPos] < 0 && this.content[++tempPos] < 0) break block4;
            }
            this.position = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    protected long readRawVarint64() {
        block4: {
            long x;
            int tempPos;
            block6: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int y;
                                block8: {
                                    block7: {
                                        block5: {
                                            tempPos = this.position;
                                            if (tempPos + 1 == this.content.length) break block4;
                                            if ((y = this.content[++tempPos]) >= 0) {
                                                this.position = tempPos;
                                                return y;
                                            }
                                            if (this.content.length - (tempPos + 1) < 9) break block4;
                                            if ((y ^= this.content[++tempPos] << 7) >= 0) break block5;
                                            x = y ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((y ^= this.content[++tempPos] << 14) < 0) break block7;
                                        x = y ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((y ^= this.content[++tempPos] << 21) >= 0) break block8;
                                    x = y ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((x = (long)y ^ (long)this.content[++tempPos] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)this.content[++tempPos] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)this.content[++tempPos] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)this.content[++tempPos] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)this.content[++tempPos] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)this.content[++tempPos] < 0L) break block4;
            }
            this.position = tempPos;
            return x;
        }
        return this.readRawVarint64SlowPath();
    }

    protected long readRawVarint64SlowPath() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.content[++this.position];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ConvertException("readRawVarint64SlowPath error");
    }

    protected int readRawLittleEndian32() {
        return this.content[++this.position] & 0xFF | (this.content[++this.position] & 0xFF) << 8 | (this.content[++this.position] & 0xFF) << 16 | (this.content[++this.position] & 0xFF) << 24;
    }

    protected long readRawLittleEndian64() {
        return (long)this.content[++this.position] & 0xFFL | ((long)this.content[++this.position] & 0xFFL) << 8 | ((long)this.content[++this.position] & 0xFFL) << 16 | ((long)this.content[++this.position] & 0xFFL) << 24 | ((long)this.content[++this.position] & 0xFFL) << 32 | ((long)this.content[++this.position] & 0xFFL) << 40 | ((long)this.content[++this.position] & 0xFFL) << 48 | ((long)this.content[++this.position] & 0xFFL) << 56;
    }

    public Reader.ValueType readType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

