/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.redkale.convert.ConvertFactory;
import org.redkale.convert.ConvertType;
import org.redkale.convert.DeMember;
import org.redkale.convert.Decodeable;
import org.redkale.convert.Encodeable;
import org.redkale.convert.ObjectDecoder;
import org.redkale.convert.Reader;
import org.redkale.convert.SimpledCoder;
import org.redkale.util.AnyValue;
import org.redkalex.convert.pson.ProtobufArrayDecoder;
import org.redkalex.convert.pson.ProtobufArrayEncoder;
import org.redkalex.convert.pson.ProtobufCollectionDecoder;
import org.redkalex.convert.pson.ProtobufCollectionEncoder;
import org.redkalex.convert.pson.ProtobufConvert;
import org.redkalex.convert.pson.ProtobufEnumSimpledCoder;
import org.redkalex.convert.pson.ProtobufMapDecoder;
import org.redkalex.convert.pson.ProtobufMapEncoder;
import org.redkalex.convert.pson.ProtobufObjectDecoder;
import org.redkalex.convert.pson.ProtobufReader;
import org.redkalex.convert.pson.ProtobufStreamDecoder;
import org.redkalex.convert.pson.ProtobufStreamEncoder;
import org.redkalex.convert.pson.ProtobufWriter;

public class ProtobufFactory
extends ConvertFactory<ProtobufReader, ProtobufWriter> {
    private static final ProtobufFactory instance = new ProtobufFactory(null, Boolean.getBoolean("convert.protobuf.tiny"));
    static final Decodeable objectDecoder = instance.loadDecoder((Type)((Object)Object.class));
    static final Encodeable objectEncoder = instance.loadEncoder((Type)((Object)Object.class));

    private ProtobufFactory(ProtobufFactory parent, boolean tiny) {
        super((ConvertFactory)parent, tiny);
        tiny = false;
        if (parent == null) {
            this.register((Type)((Object)String[].class), this.createArrayDecoder((Type)((Object)String[].class)));
            this.register((Type)((Object)String[].class), this.createArrayEncoder((Type)((Object)String[].class)));
        }
    }

    public static ProtobufFactory root() {
        return instance;
    }

    public static ProtobufFactory create() {
        return new ProtobufFactory(null, Boolean.getBoolean("convert.protobuf.tiny"));
    }

    protected SimpledCoder createEnumSimpledCoder(Class enumClass) {
        return new ProtobufEnumSimpledCoder(enumClass);
    }

    protected ObjectDecoder createObjectDecoder(Type type) {
        return new ProtobufObjectDecoder(type);
    }

    protected <E> Decodeable<ProtobufReader, E> createMapDecoder(Type type) {
        return new ProtobufMapDecoder(this, type);
    }

    protected <E> Encodeable<ProtobufWriter, E> createMapEncoder(Type type) {
        return new ProtobufMapEncoder(this, type);
    }

    protected <E> Decodeable<ProtobufReader, E> createArrayDecoder(Type type) {
        return new ProtobufArrayDecoder(this, type);
    }

    protected <E> Encodeable<ProtobufWriter, E> createArrayEncoder(Type type) {
        return new ProtobufArrayEncoder(this, type);
    }

    protected <E> Decodeable<ProtobufReader, E> createCollectionDecoder(Type type) {
        return new ProtobufCollectionDecoder(this, type);
    }

    protected <E> Encodeable<ProtobufWriter, E> createCollectionEncoder(Type type) {
        return new ProtobufCollectionEncoder(this, type);
    }

    protected <E> Decodeable<ProtobufReader, E> createStreamDecoder(Type type) {
        return new ProtobufStreamDecoder(this, type);
    }

    protected <E> Encodeable<ProtobufWriter, E> createStreamEncoder(Type type) {
        return new ProtobufStreamEncoder(this, type);
    }

    public final ProtobufConvert getConvert() {
        if (this.convert == null) {
            this.convert = new ProtobufConvert(this, this.tiny);
        }
        return (ProtobufConvert)this.convert;
    }

    public ProtobufFactory createChild() {
        return new ProtobufFactory(this, this.tiny);
    }

    public ProtobufFactory createChild(boolean tiny) {
        return new ProtobufFactory(this, tiny);
    }

    public ConvertType getConvertType() {
        return ConvertType.DIY;
    }

    public boolean isReversible() {
        return true;
    }

    public boolean isFieldSort() {
        return false;
    }

    protected static Reader getItemReader(boolean string, Reader in, DeMember member, boolean first) {
        int tag;
        if (string) {
            if (member == null || first) {
                return in;
            }
            ProtobufReader reader = (ProtobufReader)in;
            int tag2 = reader.readTag();
            if (tag2 != ProtobufFactory.getTag(member)) {
                reader.backTag(tag2);
                return null;
            }
            return in;
        }
        ProtobufReader reader = (ProtobufReader)in;
        if (!first && member != null && (tag = reader.readTag()) != ProtobufFactory.getTag(member)) {
            reader.backTag(tag);
            return null;
        }
        byte[] bs = reader.readByteArray();
        return new ProtobufReader(bs);
    }

    public static int getTag(String fieldName, Type fieldType, int fieldPos) {
        int wiretype = ProtobufFactory.wireType(fieldType);
        return fieldPos << 3 | wiretype;
    }

    public static int getTag(DeMember member) {
        int wiretype = ProtobufFactory.wireType(member.getAttribute().type());
        return member.getPosition() << 3 | wiretype;
    }

    public static int wireType(Type javaType) {
        if (javaType == Double.TYPE || javaType == Double.class) {
            return 1;
        }
        if (javaType == Float.TYPE || javaType == Float.class) {
            return 5;
        }
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            return 0;
        }
        if (javaType instanceof Class) {
            Class javaClazz = (Class)javaType;
            if (javaClazz.isEnum()) {
                return 0;
            }
            if (javaClazz.isPrimitive() || Number.class.isAssignableFrom(javaClazz)) {
                return 0;
            }
        }
        return 2;
    }

    public static String wireTypeString(Type javaType) {
        if (javaType == Double.TYPE || javaType == Double.class) {
            return "double";
        }
        if (javaType == Long.TYPE || javaType == Long.class) {
            return "sint64";
        }
        if (javaType == Float.TYPE || javaType == Float.class) {
            return "float";
        }
        if (javaType == Integer.TYPE || javaType == Integer.class) {
            return "sint32";
        }
        if (javaType == Short.TYPE || javaType == Short.class) {
            return "sint32";
        }
        if (javaType == Character.TYPE || javaType == Character.class) {
            return "sint32";
        }
        if (javaType == Byte.TYPE || javaType == Byte.class) {
            return "sint32";
        }
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            return "bool";
        }
        if (javaType == AtomicLong.class) {
            return "sint64";
        }
        if (javaType == AtomicInteger.class) {
            return "sint32";
        }
        if (javaType == AtomicBoolean.class) {
            return "bool";
        }
        if (javaType == double[].class || javaType == Double[].class) {
            return "repeated double";
        }
        if (javaType == long[].class || javaType == Long[].class) {
            return "repeated sint64";
        }
        if (javaType == float[].class || javaType == Float[].class) {
            return "repeated float";
        }
        if (javaType == int[].class || javaType == Integer[].class) {
            return "repeated sint32";
        }
        if (javaType == short[].class || javaType == Short[].class) {
            return "repeated sint32";
        }
        if (javaType == char[].class || javaType == Character[].class) {
            return "repeated sint32";
        }
        if (javaType == byte[].class || javaType == Byte[].class) {
            return "bytes";
        }
        if (javaType == boolean[].class || javaType == Boolean[].class) {
            return "repeated bool";
        }
        if (javaType == AtomicLong[].class) {
            return "repeated sint64";
        }
        if (javaType == AtomicInteger[].class) {
            return "repeated sint32";
        }
        if (javaType == AtomicBoolean[].class) {
            return "repeated bool";
        }
        if (javaType == Properties.class) {
            return "map<string,string>";
        }
        if (javaType instanceof Class) {
            Class javaClazz = (Class)javaType;
            if (javaClazz.isArray()) {
                return "repeated " + ProtobufFactory.wireTypeString(javaClazz.getComponentType());
            }
            if (javaClazz.isEnum()) {
                return javaClazz.getSimpleName();
            }
            if (CharSequence.class.isAssignableFrom(javaClazz)) {
                return "string";
            }
            return javaClazz.getSimpleName();
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Class rawType = (Class)pt.getRawType();
            if (Map.class.isAssignableFrom(rawType)) {
                Type keyType = pt.getActualTypeArguments()[0];
                Type valueType = pt.getActualTypeArguments()[1];
                return "map<" + ProtobufFactory.wireTypeString(keyType) + "," + ProtobufFactory.wireTypeString(valueType) + ">";
            }
            if (Collection.class.isAssignableFrom(rawType) || Stream.class.isAssignableFrom(rawType)) {
                return "repeated " + ProtobufFactory.wireTypeString(pt.getActualTypeArguments()[0]);
            }
        }
        throw new UnsupportedOperationException("ProtobufConvert not supported type(" + javaType + ")");
    }

    static {
        instance.register((Type)((Object)Serializable.class), objectDecoder);
        instance.register((Type)((Object)Serializable.class), objectEncoder);
        instance.register((Type)((Object)AnyValue.class), instance.loadDecoder((Type)((Object)AnyValue.DefaultAnyValue.class)));
        instance.register((Type)((Object)AnyValue.class), instance.loadEncoder((Type)((Object)AnyValue.DefaultAnyValue.class)));
    }
}

