/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.redkale.convert.Reader;
import org.redkale.convert.SimpledCoder;
import org.redkale.convert.Writer;
import org.redkalex.convert.pson.ProtobufReader;
import org.redkalex.convert.pson.ProtobufWriter;

public class ProtobufEnumSimpledCoder<R extends Reader, W extends Writer, E extends Enum>
extends SimpledCoder<R, W, E> {
    private final Class<E> type;
    private final Map<E, Integer> values1 = new HashMap<E, Integer>();
    private final Map<Integer, E> values2 = new HashMap<Integer, E>();

    public ProtobufEnumSimpledCoder(Class<E> type) {
        this.type = type;
        try {
            Method method = type.getMethod("values", new Class[0]);
            int index = -1;
            for (Enum item : (Enum[])method.invoke(null, new Object[0])) {
                this.values1.put(item, ++index);
                this.values2.put(index, item);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void convertTo(W out, E value) {
        if (value == null) {
            out.writeNull();
        } else {
            ((ProtobufWriter)((Object)out)).writeUInt32(this.values1.getOrDefault(value, -1));
        }
    }

    public E convertFrom(R in) {
        int value = ((ProtobufReader)((Object)in)).readRawVarint32();
        if (value == -1) {
            return null;
        }
        return (E)((Enum)this.values2.get(value));
    }

    public Class<E> getType() {
        return this.type;
    }
}

