/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.redkale.convert.BinaryConvert;
import org.redkale.convert.ConvertFactory;
import org.redkale.convert.ConvertField;
import org.redkale.convert.ConvertMask;
import org.redkale.convert.Decodeable;
import org.redkale.convert.EnMember;
import org.redkale.convert.Encodeable;
import org.redkale.convert.ObjectDecoder;
import org.redkale.convert.ObjectEncoder;
import org.redkale.convert.Reader;
import org.redkale.convert.Writer;
import org.redkale.util.Attribute;
import org.redkale.util.ObjectPool;
import org.redkalex.convert.pson.ProtobufByteBufferReader;
import org.redkalex.convert.pson.ProtobufByteBufferWriter;
import org.redkalex.convert.pson.ProtobufFactory;
import org.redkalex.convert.pson.ProtobufReader;
import org.redkalex.convert.pson.ProtobufStreamReader;
import org.redkalex.convert.pson.ProtobufStreamWriter;
import org.redkalex.convert.pson.ProtobufWriter;

public class ProtobufConvert
extends BinaryConvert<ProtobufReader, ProtobufWriter> {
    private static final ObjectPool<ProtobufReader> readerPool = ProtobufReader.createPool(Integer.getInteger("convert.protobuf.pool.size", 16));
    private static final ObjectPool<ProtobufWriter> writerPool = ProtobufWriter.createPool(Integer.getInteger("convert.protobuf.pool.size", 16));
    private final boolean tiny;

    protected ProtobufConvert(ConvertFactory<ProtobufReader, ProtobufWriter> factory, boolean tiny) {
        super(factory);
        this.tiny = tiny;
    }

    public ProtobufFactory getFactory() {
        return (ProtobufFactory)this.factory;
    }

    public static ProtobufConvert root() {
        return ProtobufFactory.root().getConvert();
    }

    public ProtobufConvert newConvert(BiFunction<Attribute, Object, Object> fieldFunc) {
        return this.newConvert(fieldFunc, null);
    }

    public ProtobufConvert newConvert(final BiFunction<Attribute, Object, Object> fieldFunc, final Function<Object, ConvertField[]> objExtFunc) {
        return new ProtobufConvert(this.getFactory(), this.tiny){

            protected <S extends ProtobufWriter> S configWrite(S writer) {
                return (S)((Object)((ProtobufWriter)this.fieldFunc(writer, fieldFunc, objExtFunc)));
            }
        };
    }

    public ProtobufReader pollProtobufReader(ByteBuffer ... buffers) {
        return new ProtobufByteBufferReader((ConvertMask)null, buffers);
    }

    public ProtobufReader pollProtobufReader(InputStream in) {
        return new ProtobufStreamReader(in);
    }

    public ProtobufReader pollProtobufReader() {
        return (ProtobufReader)((Object)readerPool.get());
    }

    public void offerProtobufReader(ProtobufReader in) {
        if (in != null) {
            readerPool.accept((Object)in);
        }
    }

    public ProtobufByteBufferWriter pollProtobufWriter(Supplier<ByteBuffer> supplier) {
        return (ProtobufByteBufferWriter)this.configWrite(new ProtobufByteBufferWriter(this.tiny, supplier));
    }

    public ProtobufWriter pollProtobufWriter(OutputStream out) {
        return (ProtobufWriter)this.configWrite(new ProtobufStreamWriter(this.tiny, out));
    }

    public ProtobufWriter pollProtobufWriter() {
        return (ProtobufWriter)this.configWrite(((ProtobufWriter)((Object)writerPool.get())).tiny(this.tiny));
    }

    public void offerProtobufWriter(ProtobufWriter out) {
        if (out != null) {
            writerPool.accept((Object)out);
        }
    }

    public <T> String getProtoDescriptor(Class<T> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("//java ").append(clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName()).append("\r\n\r\n");
        sb.append("option java_package = \"").append(clazz.getPackage().getName()).append("\";\r\n\r\n");
        sb.append("syntax = \"proto3\";\r\n\r\n");
        this.defineProtoDescriptor(clazz, sb, "");
        return sb.toString();
    }

    protected void defineProtoDescriptor(Type type, StringBuilder sb, String prefix) {
        Encodeable encoder = this.factory.loadEncoder(type);
        if (encoder instanceof ObjectEncoder) {
            sb.append(prefix).append("message ").append(((Class)type).getSimpleName().replace("[]", "_Array")).append(" {\r\n");
            for (EnMember member : ((ObjectEncoder)encoder).getMembers()) {
                sb.append(prefix).append("    ").append(ProtobufFactory.wireTypeString(member.getEncoder().getType())).append(" ").append(member.getAttribute().field()).append(" = ").append(member.getPosition()).append(";\r\n");
            }
            sb.append(prefix).append("}\r\n");
        }
    }

    public <T> T convertFrom(Type type, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.convertFrom(type, bytes, 0, bytes.length);
    }

    public <T> T convertFrom(Type type, byte[] bytes, int start, int len) {
        if (type == null) {
            return null;
        }
        ProtobufReader in = (ProtobufReader)((Object)readerPool.get());
        in.setBytes(bytes, start, len);
        Decodeable decoder = this.factory.loadDecoder(type);
        if (!(decoder instanceof ObjectDecoder)) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported type(" + type + ")");
        }
        Object rs = decoder.convertFrom((Reader)in);
        readerPool.accept((Object)in);
        return (T)rs;
    }

    public <T> T convertFrom(Type type, InputStream in) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertFrom InputStream");
    }

    public <T> T convertFrom(Type type, ByteBuffer ... buffers) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertFrom ByteBuffer");
    }

    public <T> T convertFrom(Type type, ConvertMask mask, ByteBuffer ... buffers) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertFrom ByteBuffer");
    }

    public <T> T convertFrom(Type type, ProtobufReader reader) {
        if (type == null) {
            return null;
        }
        Decodeable decoder = this.factory.loadDecoder(type);
        if (!(decoder instanceof ObjectDecoder)) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported type(" + type + ")");
        }
        Object rs = decoder.convertFrom((Reader)reader);
        return (T)rs;
    }

    public byte[] convertTo(Object value) {
        if (value == null) {
            ProtobufWriter out = this.pollProtobufWriter();
            out.writeNull();
            byte[] result = out.toArray();
            writerPool.accept((Object)out);
            return result;
        }
        return this.convertTo(value.getClass(), value);
    }

    public byte[] convertTo(Type type, Object value) {
        if (type == null) {
            return null;
        }
        ProtobufWriter out = this.pollProtobufWriter();
        Encodeable encoder = this.factory.loadEncoder(type);
        if (!(encoder instanceof ObjectEncoder)) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported type(" + type + ")");
        }
        encoder.convertTo((Writer)out, value);
        byte[] result = out.toArray();
        writerPool.accept((Object)out);
        return result;
    }

    public byte[] convertMapTo(Object ... values) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertMapTo");
    }

    public void convertTo(OutputStream out, Object value) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertTo OutputStream");
    }

    public void convertTo(OutputStream out, Type type, Object value) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertTo OutputStream");
    }

    public void convertMapTo(OutputStream out, Object ... values) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertMapTo");
    }

    public ByteBuffer[] convertTo(Supplier<ByteBuffer> supplier, Object value) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertTo ByteBuffer");
    }

    public ByteBuffer[] convertTo(Supplier<ByteBuffer> supplier, Type type, Object value) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertTo ByteBuffer");
    }

    public ByteBuffer[] convertMapTo(Supplier<ByteBuffer> supplier, Object ... values) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertMapTo");
    }

    public void convertTo(ProtobufWriter writer, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Encodeable encoder = this.factory.loadEncoder(value.getClass());
            if (!(encoder instanceof ObjectEncoder)) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported type(" + value.getClass() + ")");
            }
            encoder.convertTo((Writer)writer, value);
        }
    }

    public void convertTo(ProtobufWriter writer, Type type, Object value) {
        if (type == null) {
            return;
        }
        this.factory.loadEncoder(type).convertTo((Writer)writer, value);
    }

    public void convertMapTo(ProtobufWriter writer, Object ... values) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertMapTo");
    }

    public ProtobufWriter convertToWriter(Object value) {
        if (value == null) {
            return null;
        }
        return this.convertToWriter(value.getClass(), value);
    }

    public ProtobufWriter convertToWriter(Type type, Object value) {
        if (type == null) {
            return null;
        }
        ProtobufWriter out = this.pollProtobufWriter();
        Encodeable encoder = this.factory.loadEncoder(type);
        if (!(encoder instanceof ObjectEncoder)) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported type(" + type + ")");
        }
        encoder.convertTo((Writer)out, value);
        return out;
    }

    public ProtobufWriter convertMapToWriter(Object ... values) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " not supported convertMapTo");
    }
}

