/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.redkale.util.Utility;
import org.redkalex.convert.pson.ProtobufWriter;

public class ProtobufByteBufferWriter
extends ProtobufWriter {
    private final Supplier<ByteBuffer> supplier;
    private ByteBuffer[] buffers;
    private int index;

    public ProtobufByteBufferWriter(Supplier<ByteBuffer> supplier) {
        this(false, supplier);
    }

    protected ProtobufByteBufferWriter(boolean tiny, Supplier<ByteBuffer> supplier) {
        super(null);
        this.tiny = tiny;
        this.supplier = supplier;
    }

    @Override
    public ByteBuffer[] toBuffers() {
        if (this.buffers == null) {
            return new ByteBuffer[0];
        }
        for (int i = this.index; i < this.buffers.length; ++i) {
            ByteBuffer buf = this.buffers[i];
            if (buf.position() == 0) continue;
            buf.flip();
        }
        return this.buffers;
    }

    @Override
    public byte[] toArray() {
        if (this.buffers == null) {
            return new byte[0];
        }
        int pos = 0;
        byte[] bytes = new byte[this.count];
        for (ByteBuffer buf : this.toBuffers()) {
            int r = buf.remaining();
            buf.get(bytes, pos, r);
            buf.flip();
            pos += r;
        }
        return bytes;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[count=" + this.count + "]";
    }

    @Override
    public ProtobufByteBufferWriter tiny(boolean tiny) {
        this.tiny = tiny;
        return this;
    }

    @Override
    protected int expand(int byteLength) {
        ByteBuffer buffer;
        if (this.buffers == null) {
            this.index = 0;
            this.buffers = new ByteBuffer[]{this.supplier.get()};
        }
        if (!(buffer = this.buffers[this.index]).hasRemaining()) {
            buffer.flip();
            buffer = this.supplier.get();
            this.buffers = (ByteBuffer[])Utility.append((Object[])this.buffers, (Object[])new ByteBuffer[]{buffer});
            ++this.index;
        }
        int len = buffer.remaining();
        int size = 0;
        while (len < byteLength) {
            buffer = this.supplier.get();
            this.buffers = (ByteBuffer[])Utility.append((Object[])this.buffers, (Object[])new ByteBuffer[]{buffer});
            len += buffer.remaining();
            ++size;
        }
        return size;
    }

    @Override
    public void writeTo(byte[] chs, int start, int len) {
        if (this.expand(len) == 0) {
            this.buffers[this.index].put(chs, start, len);
        } else {
            ByteBuffer buffer = this.buffers[this.index];
            int end = start + len;
            int remain = len;
            while (remain > 0) {
                int br = buffer.remaining();
                if (remain > br) {
                    buffer.put(chs, end - remain, br);
                    buffer = this.nextByteBuffer();
                    remain -= br;
                    continue;
                }
                buffer.put(chs, end - remain, remain);
                remain = 0;
            }
        }
        this.count += len;
    }

    private ByteBuffer nextByteBuffer() {
        this.buffers[this.index].flip();
        return this.buffers[++this.index];
    }

    @Override
    public void writeTo(byte ch) {
        this.expand(1);
        this.buffers[this.index].put(ch);
        ++this.count;
    }

    @Override
    protected boolean recycle() {
        super.recycle();
        this.index = 0;
        this.specify = null;
        this.buffers = null;
        return false;
    }
}

