/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.convert.pson;

import java.nio.ByteBuffer;
import org.redkale.convert.ConvertMask;
import org.redkalex.convert.pson.ProtobufReader;

public class ProtobufByteBufferReader
extends ProtobufReader {
    private ByteBuffer[] buffers;
    private int currentIndex = 0;
    private ByteBuffer currentBuffer;
    protected ConvertMask mask;

    protected ProtobufByteBufferReader(ConvertMask mask, ByteBuffer ... buffers) {
        this.mask = mask;
        this.buffers = buffers;
        if (buffers != null && buffers.length > 0) {
            this.currentBuffer = buffers[this.currentIndex];
        }
    }

    @Override
    protected boolean recycle() {
        super.recycle();
        this.currentIndex = 0;
        this.currentBuffer = null;
        this.buffers = null;
        this.mask = null;
        return false;
    }

    @Override
    protected byte currentByte() {
        return this.mask == null ? this.currentBuffer.get(this.currentBuffer.position()) : this.mask.unmask(this.currentBuffer.get(this.currentBuffer.position()));
    }

    protected byte nextByte() {
        if (this.currentBuffer.hasRemaining()) {
            ++this.position;
            return this.mask == null ? this.currentBuffer.get() : this.mask.unmask(this.currentBuffer.get());
        }
        do {
            this.currentBuffer = this.buffers[++this.currentIndex];
        } while (!this.currentBuffer.hasRemaining());
        ++this.position;
        return this.mask == null ? this.currentBuffer.get() : this.mask.unmask(this.currentBuffer.get());
    }
}

